/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.mp3;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.monte.media.mp3.MP3ElementaryInputStream;

public class MP3AudioInputStream
extends AudioInputStream {
    private MP3ElementaryInputStream in;

    public MP3AudioInputStream(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file)));
    }

    public MP3AudioInputStream(InputStream in) throws IOException {
        super(null, new AudioFormat(MP3ElementaryInputStream.MP3, 44100.0f, 16, 2, 626, 38.28125f, true), -1L);
        this.in = new MP3ElementaryInputStream(in);
        if (this.in.getNextFrame() == null) {
            throw new IOException("Stream is not an MP3 elementary stream");
        }
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public AudioFormat getFormat() {
        return this.in.getFormat();
    }

    public long getFrameLength() {
        return -1L;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read() throws IOException {
        throw new IOException("cannot read a single byte if frame size > 1");
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in.getFrame() == null && this.in.getNextFrame() == null) {
            return -1;
        }
        if (this.in.getStreamPosition() != this.in.getFrame().getFrameOffset() && this.in.getNextFrame() == null) {
            return -1;
        }
        int bytesRead = 0;
        int frameSize = this.in.getFrame().getFrameSize();
        while (len >= frameSize) {
            this.in.readFully(b, off, frameSize);
            len -= frameSize;
            bytesRead += frameSize;
            off += frameSize;
            if (this.in.getNextFrame() != null && frameSize == this.in.getFrame().getFrameSize()) continue;
            break;
        }
        return bytesRead;
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }
}

