/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.image;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.monte.media.AbstractVideoCodec;
import org.monte.media.Buffer;
import org.monte.media.BufferFlag;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.iff.IFFVisitor;
import org.monte.media.ilbm.ColorCyclingMemoryImageSource;
import org.monte.media.ilbm.ILBMDecoder;
import org.monte.media.image.BitmapImage;
import org.monte.media.image.BitmapImageFactory;
import org.monte.media.pbm.PBMDecoder;

public class BitmapCodec
extends AbstractVideoCodec {
    public BitmapCodec() {
        super(new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image"})}, new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "ILBM", VideoFormatKeys.DataClassKey, BitmapImage.class})});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer in, Buffer out) {
        out.setMetaTo(in);
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        out.format = this.outputFormat;
        try {
            out.setFlag(BufferFlag.KEYFRAME);
            if (in.data instanceof File) {
                boolean success;
                ArrayList<Object> imgs;
                IFFVisitor d;
                File f = (File)in.data;
                BufferedInputStream ins = new BufferedInputStream(new FileInputStream(f));
                try {
                    d = new ILBMDecoder(ins);
                    imgs = ((ILBMDecoder)d).produceBitmaps();
                    BitmapImage img = imgs.get(0);
                    out.data = img;
                    success = true;
                }
                catch (IOException e) {
                    success = false;
                }
                finally {
                    ((InputStream)ins).close();
                }
                if (!success) {
                    ins = new BufferedInputStream(new FileInputStream(f));
                    try {
                        d = new PBMDecoder(ins);
                        imgs = ((PBMDecoder)d).produce();
                        ColorCyclingMemoryImageSource mis = (ColorCyclingMemoryImageSource)imgs.get(0);
                        out.data = BitmapImageFactory.toBitmapImage(mis);
                        success = true;
                    }
                    catch (IOException e) {
                        success = false;
                    }
                    finally {
                        ((InputStream)ins).close();
                    }
                }
                if (!success) {
                    BufferedImage img = ImageIO.read(f);
                    out.data = BitmapImageFactory.toBitmapImage(img);
                    success = true;
                }
            } else if (in.data instanceof BitmapImage) {
                out.data = in.data;
            } else if (in.data instanceof BufferedImage) {
                out.data = BitmapImageFactory.toBitmapImage((BufferedImage)in.data);
            }
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }
}

