/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;

public class CompositeTransferable
implements Transferable {
    private HashMap<DataFlavor, Transferable> transferables = new HashMap();
    private LinkedList<DataFlavor> flavors = new LinkedList();

    public void add(Transferable t) {
        DataFlavor[] f = t.getTransferDataFlavors();
        for (int i = 0; i < f.length; ++i) {
            if (!this.transferables.containsKey(f[i])) {
                this.flavors.add(f[i]);
            }
            this.transferables.put(f[i], t);
        }
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Transferable t = this.transferables.get(flavor);
        if (t == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        return t.getTransferData(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors.toArray(new DataFlavor[this.transferables.size()]);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.transferables.containsKey(flavor);
    }
}

