/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.gui;

import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Worker<T>
implements Runnable {
    private T value;
    private Throwable error;

    @Override
    public final void run() {
        try {
            this.setValue(this.construct());
        }
        catch (Throwable e) {
            this.setError(e);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Worker.this.failed(Worker.this.getError());
                    Worker.this.finished();
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Worker.this.done(Worker.this.getValue());
                Worker.this.finished();
            }
        });
    }

    protected abstract T construct() throws Exception;

    protected void done(T value) {
    }

    protected void failed(Throwable error) {
        error.printStackTrace();
    }

    protected void finished() {
    }

    public synchronized T getValue() {
        return this.value;
    }

    private synchronized void setValue(T x) {
        this.value = x;
    }

    protected synchronized Throwable getError() {
        return this.error;
    }

    private synchronized void setError(Throwable x) {
        this.error = x;
    }

    public void start() {
        new Thread(this).start();
    }
}

