/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.anim;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.monte.media.anim.ANIMDecoder;
import org.monte.media.anim.ANIMFrame;
import org.monte.media.anim.ANIMMovieTrack;
import org.monte.media.image.BitmapImage;

public class ANIMReader {
    private ANIMMovieTrack track;
    private int fetchedEven = -1;
    private int fetchedOdd = -1;
    private BitmapImage bitmapEven;
    private BitmapImage bitmapOdd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ANIMReader(File file) throws IOException {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            ANIMDecoder decoder = new ANIMDecoder(in);
            this.track = new ANIMMovieTrack();
            decoder.produce(this.track, 0, true);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void close() throws IOException {
    }

    public int getFrameCount() {
        return this.track.getFrameCount();
    }

    public int getTimeBase() {
        return this.track.getJiffies();
    }

    public BitmapImage createCompatibleBitmap() {
        return new BitmapImage(this.track.getWidth(), this.track.getHeight(), this.track.getNbPlanes() + (this.track.getMasking() == 1 ? 1 : 0), this.track.getFrame(0).getColorModel());
    }

    public void readFrame(int index, BitmapImage image) {
        BitmapImage fetched = this.fetchFrame(index);
        System.arraycopy(fetched.getBitmap(), 0, image.getBitmap(), 0, fetched.getBitmap().length);
        image.setPlanarColorModel(this.track.getFrame(index).getColorModel());
    }

    public int getDuration(int index) {
        return (int)this.track.getFrame(index).getRelTime();
    }

    private BitmapImage fetchFrame(int index) {
        BitmapImage bitmap;
        int fetched;
        if (this.bitmapOdd == null || this.bitmapEven == null) {
            this.bitmapOdd = this.createCompatibleBitmap();
            this.bitmapEven = this.createCompatibleBitmap();
        }
        ANIMFrame frame = null;
        int interleave = this.track.getInterleave();
        if (interleave == 1 || (index & 1) == 0) {
            if (this.fetchedEven == index) {
                return this.bitmapEven;
            }
            fetched = this.fetchedEven;
            bitmap = this.bitmapEven;
            this.fetchedEven = index;
            if (fetched == index + interleave && this.track.getFrame(fetched).isBidirectional()) {
                frame = this.track.getFrame(fetched);
                frame.decode(bitmap, this.track);
                return bitmap;
            }
            if (fetched > index) {
                frame = this.track.getFrame(0);
                frame.decode(bitmap, this.track);
                fetched = 0;
            }
        } else {
            if (this.fetchedOdd == index) {
                return this.bitmapOdd;
            }
            fetched = this.fetchedOdd;
            bitmap = this.bitmapOdd;
            this.fetchedOdd = index;
            if (fetched == index + interleave && this.track.getFrame(fetched).isBidirectional()) {
                frame = this.track.getFrame(fetched);
                frame.decode(bitmap, this.track);
                return bitmap;
            }
            if (fetched > index) {
                frame = this.track.getFrame(0);
                frame.decode(bitmap, this.track);
                frame = this.track.getFrame(1);
                frame.decode(bitmap, this.track);
                fetched = 1;
            }
        }
        for (int i = fetched + interleave; i <= index; i += interleave) {
            frame = this.track.getFrame(i);
            frame.decode(bitmap, this.track);
        }
        return bitmap;
    }

    public int getJiffies() {
        return this.track.getJiffies();
    }
}

