/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.monte.media.Animator;
import org.monte.media.Interpolator;

public class SynchronousAnimator
implements Animator {
    protected EventListenerList listenerList = new EventListenerList();
    protected ChangeEvent changeEvent;
    private Object lock;
    private long currentTimeMillis;
    private ArrayList<Interpolator> activeInterpolators = new ArrayList();
    private ArrayList<Interpolator> newInterpolators = new ArrayList();

    public void setLock(Object lock) {
        this.lock = lock;
    }

    public boolean isActive() {
        return !this.newInterpolators.isEmpty() || !this.activeInterpolators.isEmpty();
    }

    public void start() {
    }

    public void stop() {
        this.newInterpolators.clear();
        this.activeInterpolators.clear();
    }

    public void setTime(long currentTimeMillis) {
        this.currentTimeMillis = currentTimeMillis;
    }

    public void dispatch(Interpolator interpolator) {
        this.newInterpolators.add(interpolator);
    }

    public void animateStep() {
        int i;
        long now = this.currentTimeMillis;
        for (i = 0; i < this.newInterpolators.size(); ++i) {
            Interpolator before;
            int j;
            Interpolator candidate = this.newInterpolators.get(i);
            boolean isEnqueueable = true;
            for (j = 0; j < i; ++j) {
                before = this.newInterpolators.get(j);
                if (!candidate.isSequential(before)) continue;
                isEnqueueable = false;
                break;
            }
            if (isEnqueueable) {
                for (j = 0; j < this.activeInterpolators.size(); ++j) {
                    before = this.activeInterpolators.get(j);
                    if (candidate.replaces(before)) {
                        before.finish(now);
                    }
                    if (!candidate.isSequential(before)) continue;
                    isEnqueueable = false;
                    break;
                }
            }
            if (!isEnqueueable) continue;
            candidate.initialize(now);
            this.activeInterpolators.add(candidate);
            if (this.newInterpolators.size() <= 0) continue;
            this.newInterpolators.remove(i--);
        }
        for (i = 0; i < this.activeInterpolators.size(); ++i) {
            Interpolator active = this.activeInterpolators.get(i);
            if (active.isFinished()) {
                this.activeInterpolators.remove(i--);
                continue;
            }
            if (active.isElapsed(now)) {
                active.finish(now);
                this.activeInterpolators.remove(i--);
                continue;
            }
            active.interpolate(now);
        }
    }

    public void run() {
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public boolean isSynchronous() {
        return true;
    }
}

