/*
 * Decompiled with CFR 0.152.
 */
package net.schmunk.gui;

import gov.nasa.giss.graphics.filters.DarkFilter;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class JPlusMinus
extends JPanel {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int PLUS = 2000;
    public static final int MINUS = 2001;
    private static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);
    private static final Toolkit TOOLKIT = Toolkit.getDefaultToolkit();
    private int axis_;
    private int gap_;
    private static ImageIcon plusIcon_;
    private static ImageIcon minusIcon_;
    private Action plusAction_;
    private Action minusAction_;
    private boolean plusEnabled_;
    private boolean minusEnabled_;
    private EventListenerList listenerList_ = new EventListenerList();

    public JPlusMinus() {
        this(0, 2, null);
    }

    public JPlusMinus(String name) {
        this(0, 2, name);
    }

    public JPlusMinus(int axis, int gap) {
        this(axis, gap, null);
    }

    public JPlusMinus(int axis, int gap, String name) {
        this.setLayout(new BoxLayout(this, axis));
        this.setOpaque(false);
        if (plusIcon_ == null) {
            plusIcon_ = new ImageIcon(JPlusMinus.class.getResource("gfx/plusbutton.png"));
            minusIcon_ = new ImageIcon(JPlusMinus.class.getResource("gfx/minusbutton.png"));
        }
        this.plusAction_ = new PlusAction();
        this.minusAction_ = new MinusAction();
        WidgetButton plusButton = new WidgetButton(this.plusAction_, plusIcon_);
        WidgetButton minusButton = new WidgetButton(this.minusAction_, minusIcon_);
        this.axis_ = axis;
        this.gap_ = gap;
        if (axis == 1) {
            this.add(Box.createVerticalGlue());
            this.add(plusButton);
            this.add(minusButton);
            this.add(Box.createVerticalGlue());
        } else {
            this.add(Box.createHorizontalGlue());
            this.add(plusButton);
            if (name != null) {
                this.add(Box.createHorizontalStrut(gap));
                this.add(new JLabel(name));
                this.add(Box.createHorizontalStrut(gap));
            }
            this.add(minusButton);
            this.add(Box.createHorizontalGlue());
        }
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.plusAction_.setEnabled(this.plusEnabled_);
            this.plusAction_.setEnabled(this.minusEnabled_);
        } else {
            this.plusAction_.setEnabled(false);
            this.plusAction_.setEnabled(false);
        }
    }

    public boolean isIconEnabled(int iconID) {
        if (iconID != 2000 && iconID != 2001) {
            throw new IllegalArgumentException("Invalid icon ID.");
        }
        if (iconID == 2000) {
            return this.plusEnabled_;
        }
        if (iconID == 2001) {
            return this.minusEnabled_;
        }
        return false;
    }

    public void setIconEnabled(int iconID, boolean enabled) {
        if (iconID != 2000 && iconID != 2001) {
            throw new IllegalArgumentException("Invalid icon ID.");
        }
        if (iconID == 2000) {
            this.plusEnabled_ = enabled;
            this.plusAction_.setEnabled(this.plusEnabled_);
        } else if (iconID == 2001) {
            this.minusEnabled_ = enabled;
            this.minusAction_.setEnabled(this.minusEnabled_);
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    private void fireAction(int iconID) {
        ActionEvent e;
        if (iconID == 2000) {
            e = new ActionEvent(this, 2000, "plus");
        } else if (iconID == 2001) {
            e = new ActionEvent(this, 2001, "minus");
        } else {
            throw new IllegalArgumentException("Invalid icon ID.");
        }
        EventListener[] listeners = this.listenerList.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    class MinusAction
    extends AbstractAction {
        MinusAction() {
            super("Subtract");
        }

        public void actionPerformed(ActionEvent e) {
            JPlusMinus.this.fireAction(2001);
        }
    }

    class PlusAction
    extends AbstractAction {
        PlusAction() {
            super("Add");
        }

        public void actionPerformed(ActionEvent e) {
            JPlusMinus.this.fireAction(2000);
        }
    }

    class WidgetButton
    extends JButton {
        WidgetButton(Action action, ImageIcon icon) {
            this.setAction(action);
            this.setIcon(icon);
            this.setText(null);
            this.setMargin(NO_MARGIN);
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(true);
            Image pImage = TOOLKIT.createImage(new FilteredImageSource(icon.getImage().getSource(), new DarkFilter(33)));
            ImageIcon pIcon = new ImageIcon(pImage);
            this.setSelectedIcon(pIcon);
            this.setPressedIcon(pIcon);
            Dimension d = new Dimension(pIcon.getIconWidth(), pIcon.getIconHeight());
            this.setPreferredSize(d);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
        }
    }
}

