/*
 * Decompiled with CFR 0.152.
 */
package net.schmunk.gui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.event.EventListenerList;
import net.schmunk.gui.PositiveDoubleVerifier;

public class JMeasurementField
extends JPanel
implements ActionListener,
FocusListener,
ItemListener,
SwingConstants {
    private EventListenerList listenerList_ = new EventListenerList();
    private JTextField valueTF_;
    private JComboBox unitsCB_;
    private int hAlignment_ = 2;
    private int vAlignment_ = 1;

    public JMeasurementField() {
        this(new JTextField(), new JComboBox());
    }

    public JMeasurementField(String value, String[] unitsArray) {
        this(new JTextField(value), new JComboBox<String>(unitsArray));
    }

    public JMeasurementField(String value, int columns, String[] unitsArray) {
        this(new JTextField(value, columns), new JComboBox<String>(unitsArray));
    }

    public JMeasurementField(JTextField tf, JComboBox cb) {
        this.setLayout(new BoxLayout(this, 0));
        this.valueTF_ = tf;
        this.unitsCB_ = cb;
        this.valueTF_.setInputVerifier(new PositiveDoubleVerifier());
        this.valueTF_.addActionListener(this);
        this.valueTF_.addFocusListener(this);
        this.unitsCB_.addItemListener(this);
        this.valueTF_.setMinimumSize(this.valueTF_.getPreferredSize());
        this.valueTF_.setMaximumSize(this.valueTF_.getPreferredSize());
        this.valueTF_.setAlignmentY(0.5f);
        this.unitsCB_.setAlignmentY(0.5f);
        this.add(this.valueTF_);
        this.add(Box.createHorizontalStrut(2));
        this.add(this.unitsCB_);
        this.add(Box.createHorizontalGlue());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.valueTF_.setEnabled(enabled);
        this.unitsCB_.setEnabled(enabled);
    }

    public String getValue() {
        return this.valueTF_.getText();
    }

    public void setValue(String value) {
        this.valueTF_.setText(value);
    }

    public Font getValueFont() {
        return this.valueTF_.getFont();
    }

    public void setValueFont(Font font) {
        this.valueTF_.setFont(font);
    }

    public int getUnitsCount() {
        return this.unitsCB_.getItemCount();
    }

    public int getUnitsIndex() {
        return this.unitsCB_.getSelectedIndex();
    }

    public String getUnits() {
        return (String)this.unitsCB_.getSelectedItem();
    }

    public void setUnits(String units) {
        this.unitsCB_.setSelectedItem(units);
    }

    public void addUnits(String units) {
        this.unitsCB_.addItem(units);
    }

    public void insertUnitsAt(String units, int index) {
        this.unitsCB_.insertItemAt(units, index);
    }

    public Font getUnitsFont() {
        return this.unitsCB_.getFont();
    }

    public void setUnitsFont(Font font) {
        this.unitsCB_.setFont(font);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    public void fireAction() {
        ActionEvent e = new ActionEvent(this, 0, null);
        EventListener[] listeners = this.listenerList.getListeners(ActionListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((ActionListener)listeners[i]).actionPerformed(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.fireAction();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.fireAction();
    }

    public void itemStateChanged(ItemEvent e) {
        this.fireAction();
    }
}

