/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.xml;

import gov.nasa.giss.xml.EasyParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class GissPropertyList {
    private static Hashtable bundles_ = new Hashtable();
    private Class tclass_;
    private Hashtable phash_;
    private Hashtable pahash_;

    public static GissPropertyList getBundle(String bname) {
        if (bundles_.containsKey(bname)) {
            return (GissPropertyList)bundles_.get(bname);
        }
        GissPropertyList bundle = new GissPropertyList(bname);
        bundles_.put(bname, bundle);
        return bundle;
    }

    public GissPropertyList(String bname) {
        this(bname, Locale.getDefault());
    }

    public GissPropertyList(String bname, Locale locale) {
        if (bname == null) {
            throw new IllegalArgumentException("Bundle name must be specified");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale must be specified");
        }
        String s2 = "/" + bname.replace('.', '/');
        this.tclass_ = this.getClass();
        String country = locale.getCountry();
        String language = locale.getLanguage();
        String variant = locale.getVariant();
        String s = s2 + "_" + language + "_" + country + "_" + variant + ".properties";
        InputStream is = this.tclass_.getResourceAsStream(s);
        if (is == null) {
            s = s2 + "_" + language + "_" + country + ".properties";
            is = this.tclass_.getResourceAsStream(s);
        }
        if (is == null) {
            s = s2 + "_" + language + ".properties";
            is = this.tclass_.getResourceAsStream(s);
        }
        if (is == null) {
            s = s2 + ".properties";
            is = this.tclass_.getResourceAsStream(s);
        }
        if (is == null) {
            System.out.println("WARNING: No match for property bundle " + s2);
        } else {
            try {
                this.parse(is);
            }
            catch (Exception exc) {
                System.out.println("ERROR: Could not parse property bundle");
                exc.printStackTrace();
            }
        }
    }

    public GissPropertyList(URL url) throws FileNotFoundException, IOException, JDOMException {
        this(url.openStream());
    }

    public GissPropertyList(InputStream is) throws FileNotFoundException, IOException, JDOMException {
        this.parse(is);
    }

    private synchronized void parse(InputStream is) throws FileNotFoundException, IOException, JDOMException {
        Document document = EasyParser.parseDocument(is);
        Element root = document.getRootElement();
        if (this.phash_ == null) {
            this.phash_ = new Hashtable(root.getChildren().size());
        }
        for (Element node : root.getChildren()) {
            String nodeName = node.getName();
            if (nodeName.equals("property")) {
                this.parseProperty(node);
                continue;
            }
            System.err.println("WARNING: Unrecognized element '" + nodeName + "'");
        }
    }

    private synchronized void parseProperty(Element node) {
        if (node.getAttribute("name") == null) {
            System.err.println("WARNING: A property element is missing 'name' attribute'");
            return;
        }
        Iterator<Attribute> iter = node.getAttributes().iterator();
        Hashtable<String, String> ahash = new Hashtable<String, String>(node.getAttributes().size());
        while (iter.hasNext()) {
            Attribute a = iter.next();
            if (a == null) continue;
            ahash.put(a.getName().toLowerCase(), a.getValue());
        }
        this.phash_.put(node.getAttribute("name").getValue().toLowerCase(), new Object[]{node.getText(), ahash});
    }

    private synchronized void parsePropertyArray(Element node) {
        if (node.getAttribute("name") == null) {
            System.err.println("WARNING: A propertyArray element is missing 'name' attribute'");
            return;
        }
        if (this.pahash_ == null) {
            this.pahash_ = new Hashtable(10);
        }
    }

    public String getString(String pname) {
        if (this.phash_ == null) {
            return null;
        }
        Object[] prop = (Object[])this.phash_.get(pname.toLowerCase());
        if (prop == null || prop[0] == null) {
            return null;
        }
        return (String)prop[0];
    }

    public String getPropertyArray(String aname) {
        return null;
    }

    public String getAttribute(String pname, String aname) {
        if (this.phash_ == null) {
            return null;
        }
        Object[] prop = (Object[])this.phash_.get(pname.toLowerCase());
        if (prop == null || prop[1] == null) {
            return null;
        }
        Hashtable ahash = (Hashtable)prop[1];
        Object o = ahash.get(aname.toLowerCase());
        if (o != null) {
            return (String)o;
        }
        return null;
    }
}

