/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class EasyParser {
    private static SAXBuilder parser_;
    private static final boolean DEBUG = false;

    private EasyParser() {
    }

    public static void setParser(String s) {
        try {
            parser_ = s == null ? new SAXBuilder() : new SAXBuilder(s);
        }
        catch (Exception exc) {
            System.out.println("Couldn't make SAXBuilder for " + s);
            exc.printStackTrace();
        }
    }

    public static synchronized Document parseDocument(File f) throws FileNotFoundException, IOException, JDOMException {
        if (f == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!f.exists()) {
            throw new IllegalArgumentException("File does not exist");
        }
        if (!f.isFile()) {
            throw new IllegalArgumentException("File is not a file");
        }
        if (parser_ == null) {
            EasyParser.setParser(null);
        }
        return parser_.build(f);
    }

    public static synchronized Document parseDocument(InputStream is) throws FileNotFoundException, IOException, JDOMException {
        if (is == null) {
            throw new IllegalArgumentException("Input stream is null");
        }
        if (parser_ == null) {
            EasyParser.setParser(null);
        }
        return parser_.build(is);
    }
}

