/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util;

import java.awt.GraphicsEnvironment;

public final class PlatformUtilities {
    private static boolean initted_;
    private static boolean isJava5_;
    private static boolean isJava6_;
    private static boolean isJava7_;
    private static boolean isJava8_;
    private static boolean isMac_;
    private static boolean isMacLeopard_;
    private static boolean isMacLeopardPlus_;
    private static boolean isMacSnowLeopard_;
    private static boolean isMacLion_;
    private static boolean isMacMountainLion_;
    private static boolean isWindows_;

    private PlatformUtilities() {
    }

    private static void init() {
        try {
            String jVersion = System.getProperty("java.version");
            String osName = System.getProperty("os.name");
            String osVersion = System.getProperty("os.version");
            isJava5_ = jVersion.startsWith("1.5");
            isJava6_ = jVersion.startsWith("1.6");
            isJava7_ = jVersion.startsWith("1.7");
            isJava8_ = jVersion.startsWith("1.8");
            isMac_ = osName.contains("Mac");
            isWindows_ = osName.contains("Windows");
            if (isMac_) {
                isMacLeopard_ = osVersion.startsWith("10.5");
                isMacLeopardPlus_ = osVersion.compareTo("10.5") >= 0;
                isMacSnowLeopard_ = osVersion.startsWith("10.6");
                isMacLion_ = osVersion.startsWith("10.7");
                isMacMountainLion_ = osVersion.startsWith("10.8");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        initted_ = true;
    }

    public static boolean isHeadless() {
        GraphicsEnvironment.getLocalGraphicsEnvironment();
        return GraphicsEnvironment.isHeadless();
    }

    public static boolean isMacintosh() {
        if (!initted_) {
            PlatformUtilities.init();
        }
        return isMac_;
    }

    public static boolean isMacLeopard() {
        if (!initted_) {
            PlatformUtilities.init();
        }
        return isMacLeopard_;
    }

    public static boolean isMacLeopardPlus() {
        if (!initted_) {
            PlatformUtilities.init();
        }
        return isMacLeopardPlus_;
    }

    public static boolean isMacSnowLeopard() {
        if (!initted_) {
            PlatformUtilities.init();
        }
        return isMacSnowLeopard_;
    }

    public static boolean isWindows() {
        if (!initted_) {
            PlatformUtilities.init();
        }
        return isWindows_;
    }

    public static boolean isJava5() {
        if (!initted_) {
            PlatformUtilities.init();
        }
        return isJava5_;
    }

    public static boolean isJava6() {
        if (!initted_) {
            PlatformUtilities.init();
        }
        return isJava6_;
    }

    public static boolean isJava7() {
        if (!initted_) {
            PlatformUtilities.init();
        }
        return isJava7_;
    }
}

