/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util;

import gov.nasa.giss.util.PlatformUtilities;
import java.io.File;
import java.io.FileNotFoundException;

public final class FileUtilities {
    private static File cacheDir_;
    private static File libraryDir_;

    private FileUtilities() {
    }

    public static boolean deleteRecursive(File path) throws FileNotFoundException {
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean success = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                success = success && FileUtilities.deleteRecursive(f);
            }
        }
        return success && path.delete();
    }

    public static boolean deleteContents(File path) throws FileNotFoundException {
        if (path == null || !path.isDirectory()) {
            throw new IllegalArgumentException("Not a directory");
        }
        if (!path.exists()) {
            throw new FileNotFoundException(path.getAbsolutePath());
        }
        boolean success = true;
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                success = success && FileUtilities.deleteRecursive(f);
            }
        }
        return success;
    }

    public static File getCachesDir() {
        if (cacheDir_ == null) {
            String sep = System.getProperty("file.separator");
            String homePath = System.getProperty("user.home");
            String cachePath = null;
            if (PlatformUtilities.isMacintosh()) {
                cachePath = homePath + sep + "Library" + sep + "Caches";
            } else if (PlatformUtilities.isWindows()) {
                try {
                    cachePath = System.getenv("APPDATA");
                }
                catch (Exception ignore) {}
            } else {
                try {
                    cachePath = System.getenv("XDG_CACHE_HOME");
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if (cachePath == null) {
                cachePath = homePath + sep + ".cache";
            }
            try {
                cacheDir_ = new File(cachePath);
            }
            catch (Exception exc) {
                System.err.println("Could not create File object for cache dir at " + cachePath);
            }
        }
        return cacheDir_;
    }

    public static File getApplicationCacheDir(String appName, String qualifiedName) {
        try {
            String dirName = PlatformUtilities.isMacintosh() ? qualifiedName : appName;
            return new File(FileUtilities.getCachesDir(), dirName);
        }
        catch (Exception exc) {
            System.err.println("Could not create File object for app cache directory.");
            return null;
        }
    }

    public static File getLibraryDir(String macName, String otherName) {
        if (libraryDir_ == null) {
            try {
                String sep = System.getProperty("file.separator");
                String homePath = System.getProperty("user.home");
                String libPath = PlatformUtilities.isMacintosh() ? "Library" + sep + "Application Support" + sep + "GISS" : ".gissjava";
                libraryDir_ = new File(homePath + sep + libPath);
            }
            catch (Exception exc) {
                System.err.println("Could not create File object for home library directory");
            }
        }
        return libraryDir_;
    }

    public static File getApplicationSupportDir(String topMacName, String topOtherName, String dirName) {
        try {
            String sep = System.getProperty("file.separator");
            return new File(FileUtilities.getLibraryDir(topMacName, topOtherName), dirName);
        }
        catch (Exception exc) {
            System.err.println("Could not create File object for " + dirName + " library directory");
            return null;
        }
    }
}

