/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.mission;

import gov.nasa.giss.time.JDCalendar;
import gov.nasa.giss.time.MarsTime;
import gov.nasa.giss.time.UTParser;
import gov.nasa.giss.time.mission.MarsMissionTime;
import gov.nasa.giss.time.mission.MissionStatus;
import java.util.Date;

public class MarsPathfinder
extends MarsMissionTime {
    private static final String LAUNCH_STRING = "1996-12-04 06:58:07";
    private static final String SOL1_STRING = "1997-07-04 14:24:40";
    private static final String LANDING_STRING = "1997-07-04 16:56:55";
    private static final double SOL_PER_SEC = 1.1574074074074073E-5;
    private static long launchMillis_;
    private static long sol1Millis_;
    private static long landingMillis_;

    public MarsPathfinder() {
        super("Mars Pathfinder");
        if (launchMillis_ == 0L) {
            this.initialize();
        }
    }

    public MarsPathfinder(MarsTime marsTime) {
        this();
        this.setPlanetTime(marsTime);
    }

    private void initialize() {
        Date launchDate = UTParser.parse(LAUNCH_STRING);
        Date sol1Date = UTParser.parse(SOL1_STRING);
        Date landingDate = UTParser.parse(LANDING_STRING);
        JDCalendar jdc = new JDCalendar();
        jdc.setTime(launchDate);
        launchMillis_ = jdc.getTimeInMillis();
        jdc.setTime(sol1Date);
        sol1Millis_ = jdc.getTimeInMillis();
        jdc.setTime(landingDate);
        landingMillis_ = jdc.getTimeInMillis();
    }

    protected void update() {
        long millis = this.mTime_.getMillis();
        if (millis < launchMillis_) {
            this.status_ = MissionStatus.NOT_LAUNCHED;
            this.sol_ = -1L;
            this.fraction_ = 0.0;
            return;
        }
        double lltSec = (double)(millis - sol1Millis_) * 0.001 * 0.9732442963747456;
        double llt = lltSec * 1.1574074074074073E-5;
        this.sol_ = (long)Math.floor(llt);
        this.fraction_ = llt - (double)this.sol_;
        if (millis < landingMillis_) {
            this.status_ = MissionStatus.IN_FLIGHT;
            return;
        }
        ++this.sol_;
        this.status_ = MissionStatus.ACTIVE;
        this.needsUpdate_ = false;
    }
}

