/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.mission;

import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.time.MarsTime;
import gov.nasa.giss.time.mission.MissionTime;

public abstract class MarsMissionTime
extends MissionTime {
    private boolean externalTime_;
    protected MarsTime mTime_;

    public MarsMissionTime(String name) {
        super(name);
        this.setPlanetTime(null);
    }

    public MarsMissionTime(String name, MarsTime marsTime) {
        super(name);
        this.setPlanetTime(marsTime);
    }

    public void setMillis(long millis) {
        if (this.externalTime_) {
            throw new IllegalArgumentException("Cannot set millis for externally set MarsTime object");
        }
        this.mTime_.setMillis(millis);
    }

    public void setPlanetTime(AbstractPlanetTime ptime) {
        if (ptime == null) {
            if (this.mTime_ != null) {
                this.mTime_.removeTimeListener(this);
            }
            this.mTime_ = new MarsTime();
            this.externalTime_ = false;
        } else if (ptime instanceof MarsTime) {
            this.mTime_ = (MarsTime)ptime;
            this.externalTime_ = true;
            this.mTime_.addTimeListener(this);
        } else {
            throw new IllegalArgumentException("Must specify a MarsTime object");
        }
        this.needsUpdate_ = true;
    }
}

