/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.mission;

import gov.nasa.giss.time.MarsTime;
import gov.nasa.giss.time.mission.MarsMissionTime;
import gov.nasa.giss.time.mission.MissionStatus;

public class MarsExplorationRover
extends MarsMissionTime {
    private static final double SOL_PER_SEC = 1.1574074074074073E-5;
    private static final String MERA_LAUNCH_STRING = "2003-06-10 17:58:46";
    private static final long MERA_LAUNCH_MILLIS = 1055267927000L;
    private static final String MERA_LANDING_STRING = "2004-01-04 04:26";
    private static final long MERA_LANDING_MILLIS = 1073190900000L;
    private static final double MERA_T0 = 1.264096557E8;
    private static final double MERA_OFFSET = 600.0;
    private static final long MERB_LAUNCH_MILLIS = 1057634295000L;
    private static final String MERB_LAUNCH_STRING = "2003-07-07 03:18:15";
    private static final String MERB_LANDING_STRING = "2004-01-25 04:55:00";
    private static final long MERB_LANDING_MILLIS = 1075007100000L;
    private static final double MERB_T0 = 1.282298048E8;
    private static final double MERB_OFFSET = 780.0;
    private boolean isMERA_ = true;
    private long launchMillis_;
    private long landingMillis_;
    private long descentMillis_;
    private double t0_;
    private double offset_;

    private MarsExplorationRover() {
        super("MER-A Spirit");
    }

    public MarsExplorationRover(boolean isMERA, MarsTime marsTime) {
        super(isMERA ? "MER-A Spirit" : "MER-B Opportunity", marsTime);
        this.isMERA_ = isMERA;
        this.launchMillis_ = this.isMERA_ ? 1055267927000L : 1057634295000L;
        this.landingMillis_ = this.isMERA_ ? 1073190900000L : 1075007100000L;
        this.descentMillis_ = this.landingMillis_ - 300000L;
        this.t0_ = this.isMERA_ ? 1.264096557E8 : 1.282298048E8;
        this.offset_ = this.isMERA_ ? 600.0 : 780.0;
    }

    protected void update() {
        long millis = this.mTime_.getMillis();
        if (millis < this.launchMillis_) {
            this.status_ = MissionStatus.NOT_LAUNCHED;
            this.sol_ = Long.MIN_VALUE;
            this.fraction_ = 0.0;
            return;
        }
        double lltSec = (this.mTime_.getJ2000Seconds() - this.t0_) * 0.9732442963747456 + this.offset_;
        double llt = lltSec * 1.1574074074074073E-5;
        this.sol_ = (long)Math.floor(llt);
        this.fraction_ = llt - (double)this.sol_;
        if (llt >= 0.0) {
            ++this.sol_;
        }
        this.status_ = millis < this.descentMillis_ ? MissionStatus.IN_FLIGHT : (millis < this.landingMillis_ ? MissionStatus.DESCENDING : MissionStatus.ACTIVE);
        this.needsUpdate_ = false;
    }
}

