/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class UTParser {
    private static final DateFormat[] DATE_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"), new SimpleDateFormat("yyyy/MM/dd HH:mm"), new SimpleDateFormat("yyyy-DDD HH:mm:ss"), new SimpleDateFormat("yyyy-DDD HH:mm"), new SimpleDateFormat("dd MMM yyyy HH:mm:ss"), new SimpleDateFormat("dd MMM yyyy HH:mm"), new SimpleDateFormat("dd MMM yyyy hh:mm:ss aa"), new SimpleDateFormat("dd MMM yyyy hh:mm aa"), new SimpleDateFormat("MMM dd, yyyy HH:mm:ss"), new SimpleDateFormat("MMM dd, yyyy HH:mm"), new SimpleDateFormat("MMMMM dd, yyyy HH:mm:ss"), new SimpleDateFormat("MMMMM dd, yyyy HH:mm"), new SimpleDateFormat("MMMMM dd, yyyy hh:mm:ss aa"), new SimpleDateFormat("MMMMM dd, yyyy hh:mm aa"), new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aa"), new SimpleDateFormat("MMM dd, yyyy hh:mm aa")};
    private static boolean initialized_;

    private UTParser() {
        UTParser.initialize();
    }

    private static void initialize() {
        for (DateFormat df : DATE_FORMATS) {
            df.setTimeZone(new SimpleTimeZone(0, "GMT+0:00"));
        }
        initialized_ = true;
    }

    public static Date parse(String dateTimeStr) {
        if (!initialized_) {
            UTParser.initialize();
        }
        Date date = null;
        for (DateFormat df : DATE_FORMATS) {
            try {
                date = df.parse(dateTimeStr);
                break;
            }
            catch (Exception ignore) {
            }
        }
        return date;
    }

    public static Date parse(String dateStr, String timeStr) {
        return UTParser.parse(dateStr + " " + timeStr);
    }
}

