/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.TimeUnits;
import java.text.DecimalFormat;

public class TimeFormat {
    protected static final DecimalFormat FORMAT_10 = new DecimalFormat("0");
    protected static final DecimalFormat FORMAT_20 = new DecimalFormat("00");

    private TimeFormat() {
    }

    public static String format24Hours(double hours, TimeUnits smallest) {
        return TimeFormat.format24Hours(hours, smallest, null, null);
    }

    public static String format24Hours(double hours, TimeUnits smallest, String prefix, String suffix) {
        double mins = (hours - Math.floor(hours)) * 60.0;
        double secs = (mins - Math.floor(mins)) * 60.0;
        double millis = (secs - Math.floor(secs)) * 1000.0;
        return TimeFormat.format24Hours((int)hours, (int)mins, (int)secs, (int)millis, smallest, prefix, suffix);
    }

    public static String format24Hours(int hours, int minutes, int seconds, int millis, TimeUnits smallest, String prefix, String suffix) {
        StringBuffer result = new StringBuffer().append(FORMAT_20.format(hours));
        if (smallest != TimeUnits.HOURS) {
            result.append(":").append(FORMAT_20.format(minutes));
            if (smallest != TimeUnits.MINUTES) {
                result.append(":").append(FORMAT_20.format(seconds));
                if (smallest == TimeUnits.TENTHS) {
                    int t = millis / 100;
                    result.append(".").append(FORMAT_10.format(t));
                } else if (smallest == TimeUnits.HUNDREDTHS) {
                    int t = millis / 10;
                    result.append(".").append(FORMAT_20.format(t));
                } else if (smallest == TimeUnits.THOUSANDTHS) {
                    result.append(".").append(FORMAT_20.format(millis));
                }
            }
        }
        if (prefix != null) {
            result.insert(0, " ").insert(0, prefix);
        }
        if (suffix != null) {
            result.append(" ").append(suffix);
        }
        return result.toString();
    }
}

