/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.time.MarsLanderID;
import gov.nasa.giss.time.mission.MarsExplorationRover;
import gov.nasa.giss.time.mission.MarsMissionTime;
import gov.nasa.giss.time.mission.MarsPathfinder;
import gov.nasa.giss.time.mission.MarsPhoenix;
import gov.nasa.giss.time.mission.MarsScienceLaboratory;
import gov.nasa.giss.time.mission.MissionTime;

public class MarsTime
extends AbstractPlanetTime {
    public static final double SOLS_PER_DAY = 1.0274912514;
    public static final double DAYS_PER_SOL = 0.9732442963747456;
    private static final double[] PBS_A = new double[]{0.0, 0.0071, 0.0057, 0.0039, 0.0037, 0.0021, 0.002, 0.0018, 0.0};
    private static final double[] PBS_PHI = new double[]{0.0, 49.409, 168.173, 191.837, 21.736, 15.704, 95.528, 49.095, 0.0};
    private static final double DEG_DAY = 0.9856262833675564;
    private static final double[] PBS_TAU_INV = new double[]{0.9856262833675564, 0.4409369137778179, 0.3578500102993706, 0.8818343771741581, 0.062434361000313965, 0.4615651790613264, 0.399135937218578, 0.03000448360749107};
    private static final double KTERM = 9.655E-4;
    private MarsMissionTime meraTime_;
    private MarsMissionTime merbTime_;
    private MarsMissionTime mpfTime_;
    private MarsMissionTime phxTime_;
    private MarsMissionTime mslTime_;

    public MarsTime() {
        this(System.currentTimeMillis());
    }

    public MarsTime(long millis) {
        super(millis);
        this.semimajorAxisAU_ = 1.523679;
        this.calculate();
        this.pmTimeSuffix_ = "AMT";
    }

    protected void calculate() {
        this.pgFactor_ = 0.0064763;
        this.obliquity_ = 25.1919 + 0.0126 * this.jcent_;
        double sinObliquity = Math.sin(this.obliquity_ * (Math.PI / 180));
        this.eccentricity_ = 0.0934 + 9.0E-5 * this.jcent_;
        this.meanAnomaly_ = 19.387 + 0.52402075 * this.delta2000_;
        this.meanAnomalyRad_ = this.meanAnomaly_ * (Math.PI / 180);
        double sin1MeanAnom = Math.sin(this.meanAnomalyRad_);
        double sin2MeanAnom = Math.sin(2.0 * this.meanAnomalyRad_);
        double sin3MeanAnom = Math.sin(3.0 * this.meanAnomalyRad_);
        double sin4MeanAnom = Math.sin(4.0 * this.meanAnomalyRad_);
        double sin5MeanAnom = Math.sin(5.0 * this.meanAnomalyRad_);
        this.alphaFMS_ = 270.3863 + 0.5240384 * this.delta2000_;
        double pbs = 0.0;
        for (int k = 1; k < 8; ++k) {
            pbs += PBS_A[k] * Math.cos((PBS_TAU_INV[k] * this.delta2000_ + PBS_PHI[k]) * (Math.PI / 180));
        }
        double equationOfCenter = (10.691 + 3.0E-7 * this.delta2000_) * sin1MeanAnom + 0.623 * sin2MeanAnom + 0.05 * sin3MeanAnom + 0.005 * sin4MeanAnom + 5.0E-4 * sin5MeanAnom + pbs;
        this.trueAnomaly_ = equationOfCenter + this.meanAnomaly_;
        this.ellS_ = this.alphaFMS_ + equationOfCenter;
        this.ellSRad_ = this.ellS_ * (Math.PI / 180);
        this.cosEllS_ = Math.cos(this.ellSRad_);
        this.sinEllS_ = Math.sin(this.ellSRad_);
        this.ellSP_ = this.ellS_ - this.trueAnomaly_;
        this.eotDegrees_ = 2.861 * Math.sin(2.0 * this.ellSRad_) - 0.071 * Math.sin(4.0 * this.ellSRad_) + 0.002 * Math.sin(6.0 * this.ellSRad_) - equationOfCenter;
        this.eotHours_ = this.eotDegrees_ * 0.06666666666666667;
        double mst0x_ = this.mst0_ = 24.0 * ((this.jdTT_ - 2451549.5) * 0.9732442963747456 + 44796.0 - 9.655E-4);
        this.mst0_ = MarsTime.normalize24(this.mst0_);
        this.tst0_ = MarsTime.normalize24(this.mst0_ + this.eotHours_);
        double declinSPC = 57.29577951308232 * Math.asin(sinObliquity * this.sinEllS_);
        this.declinSPG_ = declinSPC + 0.25 * this.sinEllS_;
        this.subsolarLonPG_ = MarsTime.normalize360(15.0 * this.tst0_ + 180.0);
        this.gotOrbitParams_ = false;
        this.gotEarthParams_ = false;
    }

    protected void calculateOrbitParams() {
        this.rHeliocentricAU_ = this.semimajorAxisAU_ * (1.00436 - 0.09309 * Math.cos(this.meanAnomalyRad_) - 0.004336 * Math.cos(2.0 * this.meanAnomalyRad_) - 3.1E-4 * Math.cos(3.0 * this.meanAnomalyRad_) - 3.0E-5 * Math.cos(4.0 * this.meanAnomalyRad_));
        this.lonEcliptic_ = this.ellS_ + 85.061 - 5.5E-6 * this.delta2000_ - 0.015 * Math.sin((2.0 * this.ellS_ + 71.0) * (Math.PI / 180));
        this.lonEcliptic_ = MarsTime.normalize360(this.lonEcliptic_);
        this.latEcliptic_ = -(1.8497 - 2.23E-5 * this.delta2000_) * Math.sin((this.ellS_ - 144.5 + 2.57E-6 * this.delta2000_) * (Math.PI / 180));
        double jdmil = this.delta2000_ / 365250.0;
        double jdmil2 = jdmil * jdmil;
        double jdmil3 = jdmil2 * jdmil;
        this.lambdaRot_ = 352.9076 - 1.9631 * jdmil - 0.0054 * jdmil2 + 1.0E-4 * jdmil3;
        this.betaRot_ = 63.282 - 0.0418 * jdmil - 0.004 * jdmil2 - 8.0E-5 * jdmil3;
        this.gotOrbitParams_ = true;
    }

    public double getVernalEquinox() {
        return this.getHeliocentricLongitude() + 180.0 - this.getSolarLongitude();
    }

    public double getHeliocentricLongitudeAtPerihelion(boolean b) {
        if (b) {
            return 250.999 + this.delta2000_ * 1.765E-5 + this.getVernalEquinox();
        }
        return 250.999 + this.delta2000_ * 1.765E-5;
    }

    public double getSolDate() {
        return (this.jdTT_ - 2400000.5 - 51549.0) * 0.9732442963747456 + 44796.0 - 9.655E-4;
    }

    public MissionTime getMissionTime(MarsLanderID landerID) {
        switch (landerID) {
            case MPF: {
                if (this.mpfTime_ == null) {
                    this.mpfTime_ = new MarsPathfinder(this);
                }
                return this.mpfTime_;
            }
            case MERA: {
                if (this.meraTime_ == null) {
                    this.meraTime_ = new MarsExplorationRover(true, this);
                }
                return this.meraTime_;
            }
            case MERB: {
                if (this.merbTime_ == null) {
                    this.merbTime_ = new MarsExplorationRover(false, this);
                }
                return this.merbTime_;
            }
            case PHX: {
                if (this.phxTime_ == null) {
                    this.phxTime_ = new MarsPhoenix(this);
                }
                return this.phxTime_;
            }
            case MSL: {
                if (this.mslTime_ == null) {
                    this.mslTime_ = new MarsScienceLaboratory(this);
                }
                return this.mslTime_;
            }
        }
        throw new IllegalArgumentException("Unknown lander ID " + (Object)((Object)landerID));
    }
}

