/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MarsLanderID {
    MSL("MSL", "MSL Curiosity"),
    PHX("PHX", "Mars Phoenix"),
    MERA("MERA", "MER-A Spirit"),
    MERB("MERB", "MER-B Opportunity"),
    MPF("MPF", "Mars Pathfinder");

    private String id_;
    private String text_;

    private MarsLanderID(String id, String text) {
        this.id_ = id;
        this.text_ = text;
    }

    public String getID() {
        return this.id_;
    }

    public String toString() {
        return this.text_;
    }

    public boolean matches(String text) {
        boolean result = this.idMatches(text) | this.nameMatches(text);
        return this.idMatches(text) | this.nameMatches(text);
    }

    public boolean idMatches(String text) {
        return this.id_.equalsIgnoreCase(text);
    }

    public boolean nameMatches(String text) {
        return this.text_.equalsIgnoreCase(text);
    }

    public static MarsLanderID matching(String s) {
        for (MarsLanderID id : MarsLanderID.values()) {
            if (!id.matches(s)) continue;
            return id;
        }
        return null;
    }
}

