/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import gov.nasa.giss.text.TextConstants;
import java.text.NumberFormat;
import java.text.ParseException;

public final class TextUtilities {
    private static final boolean DEBUG = false;
    public static final NumberFormat NFI = NumberFormat.getNumberInstance();

    public static String convertUnicode(String s) throws ParseException {
        if (s.indexOf("\\u") < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int sint = 0;
        int slength = s.length();
        while (sint < slength) {
            int uint = s.indexOf("\\u", sint);
            if (uint < 0) {
                sb.append(s.substring(sint));
                break;
            }
            int xint = uint + 2;
            int zint = xint + 4;
            if (zint > slength) {
                sb.append(s.substring(sint));
                break;
            }
            try {
                String s1 = s.substring(sint, uint);
                String s2 = s.substring(xint, zint);
                String s3 = s.substring(zint, s.length());
                char uu = (char)Integer.parseInt(s2, 16);
                sb.append(s1).append(uu);
                sint = zint;
            }
            catch (Exception exc) {
                throw new ParseException(s, uint);
            }
        }
        return sb.toString();
    }

    public static double parseDouble(String d) throws NumberFormatException {
        String dd = d.replaceAll("\\s", "");
        String ddd = dd.replaceAll("\\" + TextConstants.GROUP_SEP, "");
        if (ddd.length() == 0) {
            throw new NumberFormatException("String does not look like a numeric text value");
        }
        int eindex = ddd.toLowerCase().indexOf("e");
        if (eindex > -1) {
            int eindex0 = eindex++;
            if (eindex == 1 || eindex == ddd.length()) {
                throw new NumberFormatException("E notation in unexpected place.");
            }
            if (ddd.substring(eindex, eindex + 1).equals("+")) {
                ++eindex;
            }
            if (eindex == ddd.length()) {
                throw new NumberFormatException("E notation in unexpected place.");
            }
            double exponent = 0.0;
            try {
                exponent = Integer.parseInt(ddd.substring(eindex));
            }
            catch (Exception exc) {
                throw new NumberFormatException("Could not parse apparent exponent " + d + " : " + ddd);
            }
            double base = TextUtilities.parseDouble(ddd.substring(0, eindex0));
            double result = base * Math.pow(10.0, exponent);
            return result;
        }
        try {
            double result = NFI.parse(ddd).doubleValue();
            return result;
        }
        catch (Exception exc) {
            System.err.println(exc.toString());
            System.err.println("WARNING: NumberFormat failed to parse " + d + " : " + ddd);
            try {
                double result = Double.parseDouble(ddd);
                return result;
            }
            catch (Exception exc2) {
                System.err.println(exc2.toString());
                System.err.println("WARNING: Double failed to parse " + d + " : " + ddd);
                throw new NumberFormatException("String does not look like a numeric text value");
            }
        }
    }

    private TextUtilities() {
    }
}

