/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import gov.nasa.giss.text.TextConstants;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerDocument
extends PlainDocument {
    private boolean nonNegative_;

    public IntegerDocument() {
        this(false);
    }

    public IntegerDocument(boolean nonNegative) {
        this.nonNegative_ = nonNegative;
    }

    public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
        String newValue;
        if (string == null) {
            return;
        }
        int length = this.getLength();
        if (length == 0) {
            newValue = string;
        } else {
            String currentContent = this.getText(0, length);
            StringBuilder currentBuffer = new StringBuilder(currentContent);
            currentBuffer.insert(offset, string);
            newValue = currentBuffer.toString();
        }
        try {
            if (string.equals(TextConstants.MINUS_SIGN) && this.nonNegative_) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (newValue.equals(TextConstants.MINUS_SIGN)) {
                return;
            }
            Integer.parseInt(newValue);
            super.insertString(offset, string, attributes);
        }
        catch (NumberFormatException exc) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Exception exc) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public int getValue() {
        try {
            String content = this.getText(0, this.getLength());
            if (content == null || content.length() == 0 || content.equals(TextConstants.MINUS_SIGN)) {
                return 0;
            }
            return Integer.parseInt(content);
        }
        catch (Exception exc) {
            return 0;
        }
    }
}

