/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.text;

import gov.nasa.giss.text.TextConstants;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class DoubleDocument
extends PlainDocument {
    private boolean nonNegative_;

    public DoubleDocument() {
        this(false);
    }

    public DoubleDocument(boolean nonNegative) {
        this.nonNegative_ = nonNegative;
    }

    public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
        String newValue;
        if (string == null) {
            return;
        }
        int length = this.getLength();
        if (length == 0) {
            newValue = string;
        } else {
            String currentContent = this.getText(0, length);
            StringBuilder currentBuffer = new StringBuilder(currentContent);
            currentBuffer.insert(offset, string);
            newValue = currentBuffer.toString();
        }
        try {
            if (string.equals(TextConstants.MINUS_SIGN) && this.nonNegative_) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (!newValue.equals(TextConstants.MINUS_SIGN) && !newValue.equals(TextConstants.DECIMAL_SEP)) {
                TextUtilities.parseDouble(newValue);
            }
            super.insertString(offset, string, attributes);
        }
        catch (NumberFormatException exc) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Exception exc) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public double getValue() {
        try {
            String content = this.getText(0, this.getLength());
            if (content == null || content.length() == 0 || content.equals(TextConstants.MINUS_SIGN) || content.equals(TextConstants.DECIMAL_SEP)) {
                return 0.0;
            }
            return TextUtilities.parseDouble(content);
        }
        catch (Exception exc) {
            return 0.0;
        }
    }
}

