/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.prefs;

import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesHash;
import gov.nasa.giss.prefs.PreferencesListener;
import gov.nasa.giss.util.PlatformUtilities;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import org.jdom2.JDOMException;

public abstract class AbstractPreferences
extends PreferencesHash {
    private File prefsFile_;
    private File settingsFile_;
    private String domain_;
    private String appName_;
    private boolean isApplicationContext_;
    private boolean showErrorDialogs_;
    private EventListenerList listenerList_ = new EventListenerList();

    protected AbstractPreferences() {
        this(true, null, null, false);
    }

    protected AbstractPreferences(String domain, String fnameRoot) {
        this(true, domain, fnameRoot, true);
    }

    protected AbstractPreferences(String domain, String fnameRoot, boolean showErrors) {
        this(true, domain, fnameRoot, showErrors);
    }

    protected AbstractPreferences(boolean isApp, String domain, String fnameRoot, boolean showErrors) {
        this.isApplicationContext_ = isApp;
        this.domain_ = domain;
        this.appName_ = fnameRoot;
        this.showErrorDialogs_ = showErrors;
        this.setName(this.appName_);
        this.restoreDefaults();
        boolean headless = Boolean.valueOf(System.getProperty("java.awt.headless"));
        if (this.isApplicationContext_ && fnameRoot != null) {
            this.prefsFile_ = this.findPrefs(this.domain_, fnameRoot);
            if (!headless) {
                this.read();
            }
        }
    }

    public String getAppName() {
        return this.appName_;
    }

    private File findPrefs(String domain, String fnameRoot) {
        String homeDir = System.getProperty("user.home");
        String pathSep = System.getProperty("file.separator");
        String prefsDname = null;
        String prefsFname = null;
        if (PlatformUtilities.isMacintosh()) {
            prefsDname = homeDir + pathSep + "Library" + pathSep + "Preferences";
            prefsFname = domain + "." + fnameRoot + ".prefs.xml";
        } else if (domain.equals("gov.nasa.giss")) {
            prefsDname = homeDir + pathSep + ".gissjava";
            prefsFname = fnameRoot.toLowerCase() + ".xml";
        } else {
            String xd = domain;
            xd.replace('.', '_');
            prefsDname = homeDir + pathSep + "." + xd;
            prefsFname = fnameRoot.toLowerCase() + ".xml";
        }
        File prefsDir = null;
        File prefsFile = null;
        try {
            prefsDir = new File(prefsDname);
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (prefsDir == null) {
            System.err.println("WARNING: Unable to create prefs directory object.");
            return null;
        }
        try {
            prefsFile = new File(prefsDir, prefsFname);
        }
        catch (Exception exc) {
            System.err.println("WARNING: Unable to find preferences directory (0).");
        }
        if (prefsFile == null) {
            System.err.println("WARNING: Unable to create prefs file object.");
            return null;
        }
        boolean dirExists = false;
        dirExists = prefsDir.exists() ? true : prefsDir.mkdirs();
        if (!prefsDir.exists()) {
            System.err.println("WARNING: Unable to find preferences directory (2).");
        }
        return prefsFile;
    }

    public synchronized void read() {
        if (this.prefsFile_ == null) {
            System.err.println("Null prefs file");
            return;
        }
        if (this.prefsFile_.exists()) {
            this.read(this.prefsFile_);
        } else if (this.prefsFile_ != null) {
            try {
                this.save(this.prefsFile_);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                System.err.println("WARNING: Unable to create preferences file.");
                this.prefsFile_ = null;
            }
        }
    }

    public synchronized void read(File f) {
        this.settingsFile_ = f;
        try {
            FileInputStream is = new FileInputStream(this.settingsFile_);
            this.readStream(is);
            is.close();
        }
        catch (Exception exc) {
            System.err.println("WARNING: Error reading prefs. Ignoring past settings");
            exc.printStackTrace();
        }
    }

    protected abstract void readStream(InputStream var1) throws IOException, JDOMException;

    public void set(String key, Object value) {
        super.set(key, value);
        this.fireSettingChanged(key);
    }

    public void revert() {
        System.err.println("AbstractPreferences revert calls read");
        if (this.settingsFile_ != null) {
            this.read(this.settingsFile_);
        } else if (this.prefsFile_ != null) {
            this.read(this.prefsFile_);
        } else {
            this.restoreDefaults();
        }
    }

    public abstract void restoreDefaults();

    public void save() {
        if (!this.isApplicationContext_) {
            return;
        }
        if (this.prefsFile_ == null) {
            System.err.println("WARNING: No prefs file has been identified.");
            return;
        }
        try {
            this.save(this.prefsFile_);
        }
        catch (Exception exc) {
            System.err.println("WARNING: Error trying to save preferences.");
            exc.printStackTrace();
        }
    }

    public void save(File f) {
        if (!this.isApplicationContext_) {
            return;
        }
        try {
            FileOutputStream os = new FileOutputStream(f);
            this.saveStream(os);
            os.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.showError(null, "File Error", "I encountered an error while savings preferences.", exc.toString());
        }
    }

    protected abstract void saveStream(OutputStream var1) throws IOException;

    protected void showError(final Component parent, final String title, final String message1, final String message2) {
        if (!this.showErrorDialogs_ || Boolean.valueOf(System.getProperty("java.awt.headless")).booleanValue()) {
            if (title != null) {
                System.err.println(title);
            }
            if (message1 != null) {
                System.err.println(message1);
            }
            if (message2 != null) {
                System.err.println(message2);
            }
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (message2 == null) {
                    JOptionPane.showMessageDialog(parent, message1, title, 0);
                } else {
                    int colon = message2.indexOf(": ");
                    String messageX = colon > -1 ? message2.substring(colon + 2) : message2;
                    JOptionPane.showMessageDialog(parent, message1 + "\n" + messageX, title, 0);
                }
            }
        });
    }

    public synchronized void addSettingsListener(PreferencesListener l) {
        this.listenerList_.add(PreferencesListener.class, l);
    }

    public synchronized void removeSettingsListener(PreferencesListener l) {
        this.listenerList_.remove(PreferencesListener.class, l);
    }

    protected void fireSettingChanged(String pname) {
        Object o = this.get(pname);
        PreferencesEvent e = new PreferencesEvent(pname, o);
        Object[] list = this.listenerList_.getListenerList();
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof PreferencesListener)) continue;
            ((PreferencesListener)list[i]).settingChanged(e);
        }
    }
}

