/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.plot;

import gov.nasa.giss.graphics.ColorUtilities;
import gov.nasa.giss.plot.PlotPropertyEvent;
import gov.nasa.giss.plot.PlotPropertyListener;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.text.ParseException;
import java.util.TreeMap;
import javax.swing.event.EventListenerList;

public class PlotPropertyMap
extends TreeMap<String, Object> {
    private EventListenerList listenerList_ = new EventListenerList();

    public synchronized Object get(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        return super.get(key);
    }

    public synchronized boolean getBoolean(String key) {
        Object o = this.get(key);
        if (!(o instanceof Boolean)) {
            throw new IllegalArgumentException("Not a boolean property.");
        }
        try {
            return (Boolean)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not a boolean property.");
        }
    }

    public synchronized Color getColor(String key) {
        Object o = this.get(key);
        if (!(o instanceof Color)) {
            throw new IllegalArgumentException("Not a color property.");
        }
        return (Color)o;
    }

    public synchronized double getDouble(String key) {
        Object o = this.get(key);
        if (!(o instanceof Double)) {
            throw new IllegalArgumentException("Not a double property.");
        }
        try {
            return (Double)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not a double property.");
        }
    }

    public synchronized float getFloat(String key) {
        Object o = this.get(key);
        if (!(o instanceof Float)) {
            throw new IllegalArgumentException("Not a float property.");
        }
        try {
            return ((Float)o).floatValue();
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not a float property.");
        }
    }

    public synchronized int getInt(String key) {
        Object o = this.get(key);
        if (!(o instanceof Integer)) {
            throw new IllegalArgumentException("Not an integer property");
        }
        try {
            return (Integer)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not an integer property");
        }
    }

    public synchronized Dimension getDimension(String key) {
        Object o = this.get(key);
        if (!(o instanceof Dimension)) {
            throw new IllegalArgumentException("Not a dimenzion property.");
        }
        return (Dimension)o;
    }

    public synchronized Rectangle getRect(String key) {
        Object o = this.get(key);
        if (!(o instanceof Rectangle)) {
            throw new IllegalArgumentException("Not a rectangle property.");
        }
        return (Rectangle)o;
    }

    public synchronized String getString(String key) {
        Object o = this.get(key);
        try {
            return (String)o;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Not a string property.");
        }
    }

    @Override
    public Object put(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("Property name is null");
        }
        super.put(key, value);
        this.firePropertyChanged(key);
        return value;
    }

    public Object setGroup(String[] keys, Object[] values) {
        int i;
        if (keys == null) {
            throw new IllegalArgumentException("Name array is null");
        }
        if (values == null) {
            throw new IllegalArgumentException("Value array is null");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Keys, values length mismatch.");
        }
        for (i = 0; i < keys.length; ++i) {
            if (keys[i] != null) continue;
            throw new IllegalArgumentException("Property name is null");
        }
        for (i = 0; i < keys.length; ++i) {
            super.put(keys[i], values[i]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < keys.length; ++i2) {
            if (i2 > 0) {
                sb.append(",");
            }
            sb.append(keys[i2]);
        }
        this.firePropertyChanged(sb.toString());
        return null;
    }

    public synchronized void set(String key, Object value) {
        this.put(key, value);
    }

    public synchronized void setBoolean(String key, boolean value) {
        this.put(key, (Object)value);
    }

    public synchronized Boolean setBoolean(String key, String svalue) {
        if (svalue == null || svalue.length() == 0) {
            this.setBoolean(key, false);
            return Boolean.FALSE;
        }
        Boolean bb = new Boolean(svalue);
        this.setBoolean(key, bb);
        return bb;
    }

    public synchronized void setColor(String key, Color value) {
        this.put(key, (Object)value);
    }

    public synchronized Color setColor(String key, String svalue) throws ParseException {
        if (svalue == null) {
            this.setColor(key, Color.BLACK);
            return Color.BLACK;
        }
        Color cc = ColorUtilities.parseColor(svalue);
        this.setColor(key, cc);
        return cc;
    }

    public synchronized void setDimension(String key, Dimension value) {
        this.put(key, (Object)value);
    }

    public synchronized void setDouble(String key, double value) {
        this.put(key, (Object)new Double(value));
    }

    public synchronized Double setDouble(String key, String svalue) throws NumberFormatException {
        if (svalue == null || svalue.length() == 0) {
            this.setDouble(key, new Double(0.0));
            return 0.0;
        }
        double dd = TextUtilities.parseDouble(svalue);
        this.setDouble(key, dd);
        return dd;
    }

    public synchronized void setFloat(String key, float value) {
        this.put(key, (Object)new Float(value));
    }

    public synchronized void setInt(String key, int value) {
        this.put(key, (Object)new Integer(value));
    }

    public synchronized Integer setInt(String key, String svalue) throws NumberFormatException {
        if (svalue.length() == 0) {
            this.setInt(key, 0);
            return 0;
        }
        int ii = new Integer(svalue);
        this.setInt(key, ii);
        return ii;
    }

    public synchronized void setRect(String key, Rectangle value) {
        this.put(key, (Object)value);
    }

    public synchronized void setString(String key, String value) {
        this.put(key, (Object)value);
    }

    public synchronized void addPlotPropertyListener(PlotPropertyListener l) {
        this.listenerList_.add(PlotPropertyListener.class, l);
    }

    public synchronized void removePlotPropertyListener(PlotPropertyListener l) {
        this.listenerList_.remove(PlotPropertyListener.class, l);
    }

    public synchronized void removePlotPropertyListeners() {
        for (PlotPropertyListener listener : (PlotPropertyListener[])this.listenerList_.getListeners(PlotPropertyListener.class)) {
            this.removePlotPropertyListener(listener);
        }
    }

    protected synchronized void firePropertyChanged(String key) {
        PlotPropertyEvent e = new PlotPropertyEvent(this, key);
        for (PlotPropertyListener listener : (PlotPropertyListener[])this.listenerList_.getListeners(PlotPropertyListener.class)) {
            listener.plotPropertyChanged(e);
        }
    }
}

