/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.plot;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.plot.PlotHolder;
import gov.nasa.giss.plot.PlotPieceMargins;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.util.ArrayList;

public class PlotPiece
implements ImageObserver {
    private Object parent_;
    private ArrayList<PlotPiece> children_;
    private PlotPieceMargins margins_ = new PlotPieceMargins();
    private Color background_ = Color.WHITE;
    private Color foreground_ = Color.BLACK;
    private int x_;
    private int y_;
    private int width_;
    private int height_;
    private boolean visible_ = true;
    private boolean opaque_ = true;
    private Font font_;

    public boolean isVisible() {
        return this.visible_;
    }

    public void setVisible(boolean visible) {
        this.visible_ = visible;
    }

    public boolean isOpaque() {
        return this.opaque_;
    }

    public void setOpaque(boolean opaque) {
        this.opaque_ = opaque;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x_, this.y_, this.width_, this.height_);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setLocation(x, y);
        this.setSize(width, height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public Point getLocation() {
        return new Point(this.x_, this.y_);
    }

    public void setLocation(int x, int y) {
        this.x_ = x;
        this.y_ = y;
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public Dimension getSize() {
        return new Dimension(this.width_, this.height_);
    }

    public void setSize(int width, int height) {
        this.width_ = width;
        this.height_ = height;
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setMargins(int margin) {
        this.setMargins(margin, margin, margin, margin);
    }

    public void setMargins(int left, int top, int right, int bottom) {
        this.margins_.setMargins(left, top, right, bottom);
    }

    public PlotPieceMargins getMargins() {
        return new PlotPieceMargins(this.margins_.left, this.margins_.top, this.margins_.right, this.margins_.bottom);
    }

    public Color getForeground() {
        return this.foreground_;
    }

    protected void setForeground(Color c) {
        this.foreground_ = c;
        this.repaintXXX();
    }

    public Color getBackground() {
        return this.background_;
    }

    public void setBackground(Color c) {
        this.background_ = c;
        this.foreground_ = new Color(this.background_.getRGB() ^ 0xFFFFFF);
        this.repaintXXX();
    }

    public Font getFont() {
        return this.font_;
    }

    public void setFont(Font font) {
        this.font_ = font;
    }

    public Object getParent() {
        return this.parent_;
    }

    protected ArrayList<PlotPiece> getChildren() {
        return this.children_;
    }

    public void setParent(Object parent) {
        if (!(parent instanceof PlotPiece) && !(parent instanceof PlotHolder)) {
            throw new IllegalArgumentException("Parent must be another PlotPiece or a PlotHolder");
        }
        this.parent_ = parent;
    }

    public void attach(PlotPiece piece) {
        if (piece == null) {
            throw new IllegalArgumentException("Cannot attach null PlotPiece");
        }
        Object oldParent = piece.getParent();
        if (oldParent != null) {
            if (oldParent instanceof PlotPiece) {
                ((PlotPiece)oldParent).detach(piece);
            } else if (oldParent instanceof PlotHolder) {
                ((PlotHolder)oldParent).detach(piece);
            }
        }
        if (this.children_ == null) {
            this.children_ = new ArrayList(10);
        }
        this.children_.add(piece);
        piece.setParent(this);
    }

    public boolean detach(PlotPiece piece) {
        Object oldParent = piece.getParent();
        if (oldParent == null || oldParent != this) {
            return false;
        }
        if (this.children_.indexOf(piece) > -1) {
            this.children_.remove(piece);
            piece.setParent(null);
            return true;
        }
        return false;
    }

    public boolean isPlotRoot() {
        if (this.parent_ == null) {
            return true;
        }
        return this.parent_ instanceof PlotHolder;
    }

    public PlotPiece getPlotRoot() {
        if (this.parent_ == null) {
            return this;
        }
        if (this.parent_ instanceof PlotHolder) {
            return this;
        }
        return ((PlotPiece)this.parent_).getPlotRoot();
    }

    public PlotHolder getPlotHolder() {
        if (this.parent_ == null) {
            return null;
        }
        if (this.parent_ instanceof PlotHolder) {
            return (PlotHolder)this.parent_;
        }
        return ((PlotPiece)this.parent_).getPlotHolder();
    }

    public void repaintXXX() {
        PlotHolder holder;
        if (this.width_ == 0 || this.height_ == 0) {
            return;
        }
        if (this.isPlotRoot()) {
            holder = this.getPlotHolder();
            if (holder == null) {
                return;
            }
        } else {
            this.getPlotRoot().repaintXXX();
            return;
        }
        holder.repaint();
    }

    public void paint(Graphics2D g2d) {
        if (!this.visible_) {
            return;
        }
        this.paint(g2d, false);
    }

    public void print(Graphics2D g2d) {
        if (!this.visible_) {
            return;
        }
        this.paint(g2d, true);
    }

    protected void paint(Graphics2D g2d, boolean printing) {
        if (this.opaque_) {
            int w = this.width_ - this.margins_.left - this.margins_.right;
            int h = this.height_ - this.margins_.top - this.margins_.bottom;
            g2d.setColor(this.background_);
            GraphicUtilities.fillRect(g2d, this.margins_.left, this.margins_.top, w, h);
        }
        if (printing) {
            this.printPiece(g2d);
            this.printChildren(g2d);
        } else {
            this.paintPiece(g2d);
            this.paintChildren(g2d);
        }
    }

    protected void paintPiece(Graphics2D g2d) {
    }

    protected void printPiece(Graphics2D g2d) {
        this.paintPiece(g2d);
    }

    protected void paintChildren(Graphics2D g2d) {
        if (this.children_ == null) {
            return;
        }
        Shape oldClip = g2d.getClip();
        for (PlotPiece child : this.children_) {
            if (!child.isVisible()) continue;
            Rectangle r = child.getBounds();
            if (r.width == 0 || r.height == 0) continue;
            g2d.setClip(r);
            g2d.translate(r.x, r.y);
            child.paint(g2d);
            g2d.translate(-r.x, -r.y);
        }
        g2d.setClip(oldClip);
    }

    protected void printChildren(Graphics2D g2d) {
        if (this.children_ == null) {
            return;
        }
        Shape oldClip = g2d.getClip();
        for (PlotPiece child : this.children_) {
            if (!child.isVisible()) continue;
            Point p = child.getLocation();
            g2d.translate(p.x, p.y);
            child.print(g2d);
            g2d.translate(-p.x, -p.y);
        }
        g2d.setClip(oldClip);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }
}

