/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.plot;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.plot.PlotPiece;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class PlotHolder
extends JComponent {
    private PlotPiece plot_;
    private BufferedImage bimg_;

    public PlotHolder(PlotPiece plot) {
        this.setOpaque(false);
        this.attach(plot);
    }

    public PlotPiece getPlot() {
        return this.plot_;
    }

    @Override
    public void setBorder(Border b) {
        super.setBorder(b);
        if (this.plot_ != null) {
            Insets insets = this.getInsets();
        }
    }

    public void attach(PlotPiece piece) {
        if (this.plot_ != null) {
            this.detach(this.plot_);
        }
        if (piece == null) {
            return;
        }
        Object oldParent = piece.getParent();
        if (oldParent != null) {
            if (oldParent instanceof PlotPiece) {
                ((PlotPiece)oldParent).detach(piece);
            } else if (oldParent instanceof PlotHolder) {
                ((PlotHolder)oldParent).detach(piece);
            }
        }
        this.plot_ = piece;
        this.plot_.setParent(this);
        Insets ins = this.getInsets();
        this.plot_.setLocation(ins.left, ins.top);
    }

    public boolean detach(PlotPiece piece) {
        if (piece != this.plot_) {
            return false;
        }
        this.plot_.setParent(null);
        this.plot_ = null;
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        Dimension pd = this.plot_.getSize();
        return new Dimension(ins.left + pd.width + ins.right, ins.top + pd.height + ins.bottom);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintComponent(g, false);
    }

    @Override
    public void printComponent(Graphics g) {
        this.paintComponent(g, true);
    }

    private void paintComponent(Graphics g, boolean printing) {
        super.paintComponent(g);
        Dimension d = this.plot_.getSize();
        if (d.width == 0 || d.height == 0) {
            return;
        }
        Point p = this.plot_.getLocation();
        Graphics2D g2d = (Graphics2D)g.create();
        GraphicUtilities.antialias(g2d);
        g2d.translate(p.x, p.y);
        g2d.setClip(0, 0, d.width, d.height);
        if (printing) {
            this.plot_.print(g2d);
        } else {
            this.plot_.paint(g2d);
        }
        g2d.dispose();
    }

    private void paintComponentImg(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        if (w == 0 || h == 0) {
            return;
        }
        if (this.bimg_ == null || this.bimg_.getWidth() != w || this.bimg_.getHeight() != h) {
            this.bimg_ = new BufferedImage(w, h, 1);
        }
        Graphics2D g2d = this.bimg_.createGraphics();
        GraphicUtilities.antialias(g2d);
        this.paintComponent(g2d, false);
        g2d.dispose();
    }
}

