/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.tasks;

import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.task.Task;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcDatasetException;
import gov.nasa.giss.panoply.PanColorTableList;
import gov.nasa.giss.panoply.PanSourcesFrame;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanOpenDatasetTask
extends Task {
    private static Logger logger_ = LoggerFactory.getLogger(PanOpenDatasetTask.class);
    final Object address_;
    private String errorMsg_;
    private boolean datasetOpened_;
    private boolean tryAgainOnEDT_;
    private NcDataset dataset_;

    public PanOpenDatasetTask(Object address) {
        super("Opening dataset");
        if (address == null) {
            throw new IllegalArgumentException("Address object is null.");
        }
        if (!(address instanceof File || address instanceof URI || address instanceof URL)) {
            throw new IllegalArgumentException("Address object must be File, URI, URL.");
        }
        this.address_ = address;
    }

    @Override
    public Object beginTask() {
        this.openDataset();
        return null;
    }

    @Override
    protected void finishTask() {
        if (this.dataset_ == null && this.tryAgainOnEDT_) {
            this.openDataset();
        }
        if (this.errorMsg_ != null) {
            GuiUtilities.showSlowMessage(null, "File Error", "There was an error opening the dataset:\n" + this.errorMsg_);
            return;
        }
        PanSourcesFrame.findFrame(true).reveal();
    }

    private void openDataset() {
        try {
            AbstractColorTable[] acts;
            URL url = null;
            if (this.address_ instanceof File) {
                url = ((File)this.address_).toURI().toURL();
            } else if (this.address_ instanceof URL) {
                url = (URL)this.address_;
            } else if (this.address_ instanceof URI) {
                url = ((URI)this.address_).toURL();
            }
            NcDataset ncd = new NcDataset(url);
            this.dataset_ = PanSourcesFrame.findFrame(true).addDataset(ncd);
            if (ncd != null && (acts = ncd.getColorTables()) != null && acts.length > 0) {
                for (AbstractColorTable act : acts) {
                    PanColorTableList.getList().add(act);
                }
            }
        }
        catch (ConnectException exc) {
            exc.printStackTrace();
            this.errorMsg_ = exc.toString().replaceFirst(".*Exception: ", "");
        }
        catch (NcDatasetException exc) {
            this.errorMsg_ = exc.toString().replaceFirst(".*Exception: ", "");
        }
        catch (MalformedURLException exc) {
            this.errorMsg_ = exc.toString();
        }
        catch (IOException exc) {
            this.errorMsg_ = exc.toString().replaceFirst(".*Exception: ", "");
            String lc = this.errorMsg_.toLowerCase();
            if (lc.indexOf("unauthorized to open dataset") > -1 || lc.indexOf("authorization required") > -1) {
                if (!EventQueue.isDispatchThread()) {
                    this.tryAgainOnEDT_ = true;
                    this.errorMsg_ = null;
                } else {
                    this.errorMsg_ = "Authorization required.";
                }
            } else if (this.errorMsg_.indexOf("not a valid CDM file") > -1) {
                this.errorMsg_ = "Does not seem to be a valid CDM file.";
            } else if (lc.matches(".*status.*403.*")) {
                this.errorMsg_ = "Access forbidden (403).";
            } else if (lc.matches(".*status.*404.*")) {
                this.errorMsg_ = "Dataset not found (404).";
            } else if (lc.matches(".*status.*408.*")) {
                this.errorMsg_ = "Request timeout (408).";
            } else if (lc.matches(".*response.*503.*")) {
                this.errorMsg_ = "Service unavailable (503); please try again later.";
            } else if (lc.matches(".*could not find a table for grib file.*")) {
                this.errorMsg_ = this.errorMsg_ + "\n" + "You must first either open an appropriate local GRIB table or else turn off\n" + "GRIB-1 \"strict mode\" in Preferences before opening this dataset.";
            } else {
                exc.printStackTrace();
            }
        }
        catch (Exception exc) {
            this.errorMsg_ = exc.toString().replaceFirst(".*Exception: ", "");
            String lc = this.errorMsg_.toLowerCase();
            this.errorMsg_ = lc.indexOf("connection refused") > -1 ? "Connection refused." : (lc.indexOf("parseexception") > -1 || this.errorMsg_.indexOf("parser") > -1 ? "Unable to parse dataset info." : (lc.indexOf("filenotfound") > -1 ? "Dataset not found." : exc.toString().replaceFirst(".*HTTP", "HTTP")));
            exc.printStackTrace();
        }
        if (this.dataset_ == null && this.errorMsg_ == null && !this.tryAgainOnEDT_) {
            this.errorMsg_ = "Uncaught/unknown exception.";
        }
    }
}

