/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.tasks;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.task.Task;
import gov.nasa.giss.panoply.PanSourcesFrame;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanOpenCatalogTask
extends Task {
    private static Logger logger_ = LoggerFactory.getLogger(PanOpenCatalogTask.class);
    final Object address_;
    private String errorMsg_;

    public PanOpenCatalogTask(Object address) {
        super("Opening remote catalog");
        if (address == null) {
            throw new IllegalArgumentException("Address object is null.");
        }
        if (!(address instanceof URI) && !(address instanceof URL)) {
            throw new IllegalArgumentException("Address object must be URI or URL.");
        }
        this.address_ = address;
    }

    @Override
    public Object beginTask() {
        try {
            PanSourcesFrame sourcesFrame = PanSourcesFrame.findFrame(true);
            URL url = null;
            if (this.address_ instanceof URL) {
                url = (URL)this.address_;
            } else if (this.address_ instanceof URI) {
                url = ((URI)this.address_).toURL();
            }
            sourcesFrame.addCatalog(url);
        }
        catch (Exception exc) {
            this.errorMsg_ = exc.toString().replaceFirst(".*HTTP", "HTTP");
            if (this.errorMsg_.indexOf("Connection refused") > -1) {
                this.errorMsg_ = "Connection was refused.";
            }
            if (this.errorMsg_.indexOf("FileNotFound") > -1 || this.errorMsg_.indexOf("404") > -1) {
                this.errorMsg_ = "No catalog at that address (404).";
            }
            if (this.errorMsg_.indexOf("401") > -1) {
                this.errorMsg_ = "User authentication required (401).";
            }
            if (this.errorMsg_.indexOf("502") > -1) {
                this.errorMsg_ = "Unable to fulfill request, possibly due to an\nupstream server error (502).";
            }
            if (this.errorMsg_.indexOf("503") > -1) {
                this.errorMsg_ = "Server seems to be refusing connection (503).";
            }
            if (this.errorMsg_.indexOf("ParseException") > -1 || this.errorMsg_.indexOf("parser") > -1) {
                this.errorMsg_ = "Unable to parse catalog XML.";
            }
            if (this.errorMsg_.indexOf("NcException") > -1) {
                this.errorMsg_ = exc.toString().replaceFirst(".*NcException: ", "");
            }
            logger_.warn("Unknown addCatalog response -\n{}", (Object)exc.toString());
            exc.printStackTrace();
        }
        return null;
    }

    @Override
    public void finishTask() {
        if (this.errorMsg_ != null) {
            GuiUtilities.showSlowMessage(null, "File Error", "There was an error opening the remote address:\n" + this.errorMsg_);
            return;
        }
        PanSourcesFrame sourcesFrame = PanSourcesFrame.findFrame(true);
        sourcesFrame.reveal();
        sourcesFrame.refresh();
    }
}

