/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.tasks;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.task.Task;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanSourcesFrame;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportCsvTask
extends Task {
    private static Logger logger_ = LoggerFactory.getLogger(PanExportCsvTask.class);
    private PanSourcesFrame parent_;
    private NcVariable node_;
    private File file_;
    private String errorMsg_;

    public PanExportCsvTask(PanSourcesFrame parent, NcVariable node, File file) {
        super("Writing CSV text file");
        if (node == null) {
            throw new IllegalArgumentException("Cannot print null node.");
        }
        this.parent_ = parent;
        this.node_ = node;
        this.file_ = file;
    }

    @Override
    public Object beginTask() {
        try {
            this.node_.printCsv(this.file_);
        }
        catch (Exception exc) {
            logger_.error("Could not write CSV text data to a file.");
            exc.printStackTrace();
            this.errorMsg_ = exc.toString();
        }
        return null;
    }

    @Override
    public void finishTask() {
        if (this.errorMsg_ != null) {
            GuiUtilities.showSlowMessage(this.parent_, "Output Error", "There was an error writing the CSV text file:\n" + this.errorMsg_);
        }
    }
}

