/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.tasks;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.task.Task;
import gov.nasa.giss.netcdf.NcDataset;
import gov.nasa.giss.netcdf.NcNode;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanSourcesFrame;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportCdlTask
extends Task {
    private static Logger logger_ = LoggerFactory.getLogger(PanExportCdlTask.class);
    private PanSourcesFrame parent_;
    private NcNode node_;
    private File file_;
    private String errorMsg_;

    public PanExportCdlTask(PanSourcesFrame parent, NcNode node, File file) {
        super("Writing CDL text file");
        if (node == null) {
            throw new IllegalArgumentException("Cannot print null node.");
        }
        if (!(node instanceof NcDataset) && !(node instanceof NcVariable)) {
            throw new IllegalArgumentException("Node must be dataset or variable.");
        }
        this.parent_ = parent;
        this.node_ = node;
        this.file_ = file;
    }

    @Override
    public Object beginTask() {
        try {
            if (this.node_ instanceof NcDataset) {
                ((NcDataset)this.node_).printCdl(this.file_);
            } else if (this.node_ instanceof NcVariable) {
                ((NcVariable)this.node_).printCdl(this.file_);
            }
        }
        catch (Exception exc) {
            logger_.error("Could not write data to a CDL text file.");
            exc.printStackTrace();
            this.errorMsg_ = exc.toString();
        }
        return null;
    }

    @Override
    public void finishTask() {
        if (this.errorMsg_ != null) {
            GuiUtilities.showSlowMessage(this.parent_, "Output Error", "There was an error writing the CDL text file:\n" + this.errorMsg_);
        }
    }
}

