/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.tasks;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.task.Task;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.PanAnimationFormat;
import gov.nasa.giss.panoply.PanImageUtilities;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.monte.media.Buffer;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.MovieWriter;
import org.monte.media.Registry;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportAnimationTask
extends Task {
    private static Logger logger_ = LoggerFactory.getLogger(PanExportAnimationTask.class);
    private static final PrintfFormat PFORMAT_5D = new PrintfFormat("%05d");
    private PanAnimationFormat format_;
    private File file_;
    private PanPlotFrame pframe_;
    private PanPlotMeta pmeta_;
    private PanAbstractData pdata_;
    private Dimension psize_;
    private int quality_;
    private float qualityF_;
    private int frameCount_;
    private int frameRate_;
    private NcDimension[] dimensions_;
    private int[] sliceDims_;
    private int[] sliceIndices_;
    private int[] dimlengths_;
    private boolean showSubtitle_;
    private String oldSubtitle_;
    private File oldFile_;
    private boolean successful_;
    private BufferedImage bimage_;

    public PanExportAnimationTask(PanAnimationFormat format, File file, PanPlotFrame pframe, int quality, int frameRate, NcDimension[] dimensions, boolean showSubtitle) {
        super("Creating plot animation");
        this.format_ = format;
        this.file_ = file;
        this.pframe_ = pframe;
        this.quality_ = quality;
        this.frameRate_ = frameRate;
        this.dimensions_ = dimensions;
        this.showSubtitle_ = showSubtitle;
    }

    @Override
    public Object beginTask() {
        if (this.isCancelled()) {
            return null;
        }
        this.oldSubtitle_ = this.pframe_.getMeta().getString("plot:caption.subtitle");
        this.successful_ = false;
        try {
            if (this.file_.exists()) {
                this.oldFile_ = new File(this.file_.getParent(), this.file_.getName() + "_old");
                this.file_.renameTo(this.oldFile_);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            GuiUtilities.showSlowMessage(this.pframe_, "Animation Error", "Could not save animation to a file.\n" + exc.toString());
        }
        try {
            this.successful_ = this.writeAnimation();
        }
        catch (NullPointerException exc) {
            exc.printStackTrace();
            GuiUtilities.showSlowMessage(this.pframe_, "Animation Error", "Animation terminated by plot window closing.");
        }
        catch (Exception exc) {
            exc.printStackTrace();
            GuiUtilities.showSlowMessage(this.pframe_, "Animation Error", "Could not save animation to a file.\n" + exc.toString());
        }
        if (this.successful_) {
            if (this.oldFile_ != null && this.oldFile_.exists()) {
                this.oldFile_.delete();
            }
        } else {
            if (this.file_.exists()) {
                this.file_.delete();
            }
            if (this.oldFile_ != null && this.oldFile_.exists()) {
                this.oldFile_.renameTo(this.file_);
            }
        }
        this.pframe_.getMeta().setString("plot:caption.subtitle", this.oldSubtitle_);
        return null;
    }

    @Override
    protected void finishTask() {
        this.pframe_.setAnimationInProgress(false);
        this.pframe_.repaint();
    }

    private boolean writeAnimation() throws InterruptedException, IOException {
        if (this.isCancelled()) {
            return false;
        }
        if (this.format_ == null) {
            throw new IllegalArgumentException("Null format");
        }
        this.pdata_ = this.pframe_.getData();
        this.pmeta_ = this.pframe_.getPlot().getMeta();
        this.psize_ = this.pmeta_.getDimension("plot:size.pixels");
        this.frameCount_ = 1;
        this.sliceDims_ = new int[]{-9999, -9999};
        this.sliceIndices_ = new int[]{-9999, -9999};
        this.dimlengths_ = new int[]{-1, -1};
        for (int i = 0; i < 2; ++i) {
            if (this.dimensions_[i] == null) continue;
            NcArray array = this.pframe_.getArrays()[i];
            this.sliceDims_[i] = array.getDimensionId(this.dimensions_[i]);
            this.sliceIndices_[i] = this.pdata_.getSlice(i, this.sliceDims_[i]);
            this.dimlengths_[i] = this.dimensions_[i].getLength();
            this.frameCount_ = Math.max(this.frameCount_, this.dimlengths_[i]);
        }
        logger_.debug("0 {} {}", (Object)this.sliceDims_[0], (Object)this.sliceIndices_[0]);
        logger_.debug("1 {} {}", (Object)this.sliceDims_[1], (Object)this.sliceIndices_[1]);
        this.bimage_ = new BufferedImage(this.psize_.width, this.psize_.height, 1);
        this.qualityF_ = this.quality_ < 95 ? 0.01f * (float)this.quality_ : 1.0f;
        boolean success = true;
        if (this.format_ == PanAnimationFormat.QUICKTIME || this.format_ == PanAnimationFormat.AVI) {
            success = this.writeVideo();
        } else if (this.format_ == PanAnimationFormat.PNG || this.format_ == PanAnimationFormat.JPEG || this.format_ == PanAnimationFormat.TIFF) {
            success = this.writeStills();
        } else {
            throw new IllegalArgumentException("Unknown animation format.");
        }
        this.cleanup();
        return success;
    }

    private boolean writeVideo() throws IOException {
        if (this.quality_ < 10) {
            this.quality_ = 10;
        }
        if (this.quality_ > 100) {
            this.quality_ = 100;
        }
        Format format = new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO});
        if (this.format_ == PanAnimationFormat.QUICKTIME) {
            format = format.append(new Object[]{VideoFormatKeys.MimeTypeKey, "video/quicktime"});
            format = this.quality_ < 100 ? format.append(new Object[]{VideoFormatKeys.EncodingKey, "jpeg", VideoFormatKeys.CompressorNameKey, "Photo - JPEG", VideoFormatKeys.QualityKey, new Float(0.01f * (float)this.quality_)}) : format.append(new Object[]{VideoFormatKeys.EncodingKey, "png "});
        } else if (this.format_ == PanAnimationFormat.AVI) {
            format = format.append(new Object[]{VideoFormatKeys.MimeTypeKey, "video/avi"});
            format = this.quality_ < 100 ? format.append(new Object[]{VideoFormatKeys.EncodingKey, "MJPG", VideoFormatKeys.CompressorNameKey, "Photo - JPEG", VideoFormatKeys.QualityKey, new Float(0.01f * (float)this.quality_)}) : format.append(new Object[]{VideoFormatKeys.EncodingKey, "png "});
        } else {
            throw new IllegalArgumentException("Not a video format.");
        }
        format = format.append(new Object[]{VideoFormatKeys.FrameRateKey, new Rational((long)this.frameRate_), VideoFormatKeys.KeyFrameIntervalKey, 900, VideoFormatKeys.WidthKey, this.psize_.width, VideoFormatKeys.HeightKey, this.psize_.height, VideoFormatKeys.DepthKey, 24});
        MovieWriter movie = Registry.getInstance().getWriter(format, this.file_);
        int track = movie.addTrack(format);
        Buffer buf = new Buffer();
        buf.format = new Format(new Object[]{VideoFormatKeys.DataClassKey, BufferedImage.class});
        buf.sampleDuration = ((Rational)format.get(VideoFormatKeys.FrameRateKey)).inverse();
        for (int i = 0; i < this.frameCount_; ++i) {
            if (this.isCancelled()) {
                this.cleanup();
                return false;
            }
            if (!this.writeFrame(this.bimage_, i)) continue;
            buf.data = this.bimage_;
            movie.write(track, buf);
        }
        movie.close();
        return true;
    }

    private boolean writeStills() throws IOException {
        String fname = this.file_.getName();
        int lastDot = fname.lastIndexOf(".");
        String froot = fname.substring(0, lastDot);
        String fext = fname.substring(lastDot);
        for (int i = 0; i < this.frameCount_; ++i) {
            if (this.isCancelled()) {
                this.cleanup();
                return false;
            }
            boolean good = this.writeFrame(this.bimage_, i);
            if (this.format_ != PanAnimationFormat.PNG && this.format_ != PanAnimationFormat.JPEG && this.format_ != PanAnimationFormat.TIFF) continue;
            fname = froot + "_" + PFORMAT_5D.sprintf(i + 1) + fext;
            File f = new File(this.file_.getParent(), fname);
            if (this.format_ == PanAnimationFormat.PNG) {
                PanImageUtilities.saveAsPng(f, this.bimage_);
                continue;
            }
            if (this.format_ == PanAnimationFormat.JPEG) {
                PanImageUtilities.saveAsJpeg(f, this.bimage_, this.qualityF_);
                continue;
            }
            if (this.format_ != PanAnimationFormat.TIFF) continue;
            PanImageUtilities.saveAsTiff(f, this.bimage_);
        }
        return true;
    }

    private boolean writeFrame(BufferedImage bimage, int findex) {
        String s0 = null;
        String s1 = null;
        if (this.dimlengths_[0] > findex) {
            this.pdata_.setSlice(0, this.sliceDims_[0], findex);
            logger_.debug("0 {} {}", (Object)this.sliceDims_[0], (Object)findex);
            s0 = this.dimensions_[0].getLongName() + ": " + (this.dimensions_[0].hasBounds() ? this.dimensions_[0].getFormattedBounds()[findex] : this.dimensions_[0].getFormattedValues()[findex]);
        }
        if (this.dimlengths_[1] > findex) {
            this.pdata_.setSlice(1, this.sliceDims_[1], findex);
            logger_.debug("1 {} {}", (Object)this.sliceDims_[1], (Object)findex);
            s1 = this.dimensions_[1].getLongName() + ": " + (this.dimensions_[1].hasBounds() ? this.dimensions_[1].getFormattedBounds()[findex] : this.dimensions_[1].getFormattedValues()[findex]);
        }
        if (this.showSubtitle_) {
            if (s0 != null && s1 != null) {
                this.pmeta_.setString("plot:caption.subtitle", s0 + " : " + s1);
            } else if (s0 != null) {
                this.pmeta_.setString("plot:caption.subtitle", s0);
            } else if (s1 != null) {
                this.pmeta_.setString("plot:caption.subtitle", s1);
            } else {
                this.pmeta_.setString("plot:caption.subtitle", "");
            }
        }
        this.pframe_.paintImage(bimage);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanExportAnimationTask.this.pframe_.getPlotHolder().repaint();
            }
        });
        return true;
    }

    private void cleanup() {
        if (this.sliceDims_[0] > -9999) {
            logger_.debug("0 {} {}", (Object)this.sliceDims_[0], (Object)this.sliceIndices_[0]);
            this.pdata_.setSlice(0, this.sliceDims_[0], this.sliceIndices_[0]);
        }
        if (this.sliceDims_[1] > -9999) {
            logger_.debug("1 {} {}", (Object)this.sliceDims_[1], (Object)this.sliceIndices_[1]);
            this.pdata_.setSlice(1, this.sliceDims_[1], this.sliceIndices_[1]);
        }
        this.pframe_.paintImage(this.bimage_);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanExportAnimationTask.this.pframe_.getPlotHolder().repaint();
            }
        });
    }
}

