/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.tasks;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.task.Task;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPlotSize;
import gov.nasa.giss.panoply.PanPlotType;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCreatePlotTask
extends Task {
    private static Logger logger_ = LoggerFactory.getLogger(PanCreatePlotTask.class);
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private PanPlotType plotType_;
    private NcVariable ncvar_;
    private int sizeFactor_;
    private String errorMsg_;
    private PanPlotMeta pmeta_;
    private long start_;

    public PanCreatePlotTask(PanPlotType pt, NcVariable ncvar, PanPlotSize size) {
        super("Creating plot window");
        this.plotType_ = pt;
        this.ncvar_ = ncvar;
        int ii = this.sizeFactor_ = size == null ? PREFS.getInt("plot:size.factor") : size.getSizeFactor();
        while (this.sizeFactor_ > 80 && !PanPlotSize.fitsDisplay(this.sizeFactor_)) {
            this.sizeFactor_ -= 10;
        }
    }

    @Override
    public Object beginTask() {
        PanAbstractData data;
        this.start_ = System.currentTimeMillis();
        try {
            this.pmeta_ = new PanPlotMeta(this.plotType_, this.sizeFactor_);
        }
        catch (Exception exc) {
            this.errorMsg_ = "Error creating plot meta handler.";
            exc.printStackTrace();
            return null;
        }
        try {
            data = this.pmeta_.createData(this.ncvar_);
        }
        catch (Exception exc) {
            this.errorMsg_ = exc.toString().replaceAll(".*: ", "");
            exc.printStackTrace();
            return null;
        }
        if (data == null) {
            this.errorMsg_ = "Data array object came up null.";
            return null;
        }
        try {
            data.getMinimumValue();
        }
        catch (Exception exc) {
            logger_.error("There was an error preparing the data, {}", exc);
            exc.printStackTrace();
            this.errorMsg_ = exc.toString();
            if (this.errorMsg_.indexOf("EOF") > -1) {
                this.errorMsg_ = "End of file exception (2).";
            }
            return null;
        }
        try {
            this.pmeta_.createPlot();
        }
        catch (Exception exc) {
            logger_.error("There was an error preparing the plot, {}", exc);
            exc.printStackTrace();
            this.errorMsg_ = exc.toString();
            return null;
        }
        try {
            double d = data.valueAt(0);
        }
        catch (Exception exc) {
            logger_.error("There was an error preparing the plot, {}", exc);
            exc.printStackTrace();
            this.errorMsg_ = exc.toString();
        }
        return null;
    }

    @Override
    public void finishTask() {
        long fstart = System.currentTimeMillis();
        if (this.errorMsg_ != null) {
            GuiUtilities.showSlowMessage(null, "Data Error", "There was an error preparing the data:\n" + this.errorMsg_);
            return;
        }
        try {
            new PanPlotFrame(this.pmeta_).reveal();
        }
        catch (Exception exc) {
            logger_.error("There was an error creating the plot window, {}", exc);
            exc.printStackTrace();
            GuiUtilities.showSlowMessage(null, "Data Error", "There was an error creating the plot frame:\n" + exc.toString());
        }
    }
}

