/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.tasks;

import gov.nasa.giss.gui.GuiUtilities;
import gov.nasa.giss.gui.task.Task;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanNetcdfUtilities;
import gov.nasa.giss.panoply.PanPlotFrame;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanCombinePlotTask
extends Task {
    private static Logger logger_ = LoggerFactory.getLogger(PanCombinePlotTask.class);
    private PanPlotFrame frame_;
    private NcVariable ncvar_;
    private NcArray ncarray_;
    private String errorMsg_;

    public PanCombinePlotTask(PanPlotFrame frame, NcVariable ncvar) {
        super("Adding variable to plot");
        if (frame == null) {
            new IllegalArgumentException("Frame canot be null");
        }
        if (ncvar == null) {
            new IllegalArgumentException("Variable canot be null");
        }
        this.frame_ = frame;
        this.ncvar_ = ncvar;
    }

    @Override
    public Object beginTask() {
        try {
            this.ncarray_ = PanNetcdfUtilities.createArray(this.frame_.getPlotType(), this.ncvar_, (JFrame)this.frame_);
            if (this.ncarray_ == null) {
                logger_.error("Null array returned");
                this.errorMsg_ = "Null array obtained";
                return null;
            }
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            this.errorMsg_ = iae.toString().replaceAll(".*IllegalArgumentException: ", "");
            this.ncarray_ = null;
        }
        catch (Exception exc) {
            logger_.error("There was an error preparing the data (C): {}", (Object)exc.toString());
            exc.printStackTrace();
            this.errorMsg_ = exc.toString();
            this.ncarray_ = null;
        }
        return null;
    }

    @Override
    protected void finishTask() {
        if (this.ncarray_ == null) {
            if (this.errorMsg_ != null) {
                GuiUtilities.showSlowMessage(this.frame_, "Data Error", "There was an error preparing the data:\n" + this.errorMsg_);
            }
            return;
        }
        this.frame_.addVariable(this.ncarray_);
        this.frame_.toFront();
    }
}

