/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanVertUnit;
import gov.nasa.giss.panoply.PanXVertData;
import gov.nasa.giss.panoply.plot.PanAbstractPlot2D;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public abstract class PanXVertPlot
extends PanAbstractPlot2D {
    protected PrintfFormat xAxisFormatter_ = new PrintfFormat("%.0f");
    protected PrintfFormat yAxisFormatter_ = new PrintfFormat("%G");
    protected double lBound_ = -90.0;
    protected double rBound_ = 90.0;
    protected boolean useDefaultYLabel_;
    protected String userYLabel_;

    public PanXVertPlot(PanPlotMeta pmeta, PanXVertData data) {
        super(pmeta, data);
        this.localParameterChanged("all");
    }

    @Override
    protected void drawGrid(Graphics2D g2d) {
        int left = this.gridXMargin_;
        int right = left + this.gridWidth_;
        int top = this.gridYMargin_;
        int bottom = top + this.gridHeight_;
        this.drawGridXAxis(g2d, left, top, right, bottom);
        this.drawGridYAxis(g2d, left, top, right, bottom);
        g2d.setColor(this.getForeground());
        g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
        GraphicUtilities.drawRect(g2d, left, top, this.gridWidth_, this.gridHeight_);
    }

    protected abstract void drawGridXAxis(Graphics2D var1, int var2, int var3, int var4, int var5);

    protected void drawGridYAxis(Graphics2D g2d, int left, int top, int right, int bottom) {
        PanVertUnit scheme = ((PanXVertData)this.data_).getVertAxisScheme();
        if (scheme == null) {
            return;
        }
        int lwidth = 0;
        switch (scheme) {
            case SCALAR: {
                lwidth = this.drawGridYScalarTicks(g2d, left, top, right, bottom);
                break;
            }
            case LOG10: {
                lwidth = this.drawGridYLogTicks(g2d, left, top, right, bottom);
                break;
            }
            case INDEX: {
                lwidth = this.drawGridYIndexTicks(g2d, left, top, right, bottom);
            }
        }
        String ylabel = null;
        ylabel = this.useDefaultYLabel_ ? (scheme == PanVertUnit.INDEX ? "Vertical Grid Index" : this.data_.getYAxisLabel()) : this.userYLabel_;
        if (ylabel != null && ylabel.length() > 0) {
            g2d.setFont(this.axisNameFont_);
            FontMetrics fm = g2d.getFontMetrics();
            g2d.setColor(this.getForeground());
            g2d.translate(left - 2 - lwidth - 10, bottom - (this.gridHeight_ - fm.stringWidth(ylabel)) / 2);
            g2d.rotate(-1.5707963267948966);
            GraphicUtilities.drawString(g2d, ylabel, 0, 0);
            g2d.rotate(1.5707963267948966);
            g2d.translate(-(left - 2 - lwidth - 10), -(bottom - (this.gridHeight_ - fm.stringWidth(ylabel)) / 2));
        }
    }

    protected int drawGridYScalarTicks(Graphics2D g2d, int left, int top, int right, int bottom) {
        float afhgt = this.pmeta_.getFloat("plot:font.height.axes");
        g2d.setFont(this.axisTickFont_);
        FontMetrics fm = g2d.getFontMetrics();
        double ytop = ((PanXVertData)this.data_).getTopBound();
        double ybottom = ((PanXVertData)this.data_).getBottomBound();
        int vSteps = 10;
        int vMajor = 2;
        double delta = (ybottom - ytop) / (double)vSteps;
        if (this.flipImageTB_) {
            ytop = ybottom;
            delta = -delta;
        }
        int lwidth = 0;
        for (int i = 0; i <= vSteps; ++i) {
            int tick = (int)((double)this.gridHeight_ / (double)vSteps * (double)i);
            if (i == 0) {
                --tick;
            }
            int y = top + tick;
            if (i % vMajor == 0) {
                double axisValue = ytop + (double)i * delta;
                String label = this.yAxisFormatter_.sprintf(axisValue);
                g2d.setColor(this.getForeground());
                GraphicUtilities.drawString(g2d, label, (float)(left - 2 - fm.stringWidth(label)), (float)y + afhgt / 2.0f);
                lwidth = Math.max(lwidth, fm.stringWidth(label));
                if (i > 0 && i < vSteps && this.gridWeight_ > 0) {
                    g2d.setColor(this.gridColor_);
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtilities.drawLine(g2d, left, y, left + this.gridWidth_, y);
                }
            }
            if (i <= 0 || i >= vSteps) continue;
            int tt = i % vMajor == 0 ? (int)((double)afhgt * 2.0 / 3.0) : (int)((double)afhgt / 3.0);
            g2d.setColor(this.getForeground());
            g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
            GraphicUtilities.drawLine(g2d, left, y, left + tt, y);
            GraphicUtilities.drawLine(g2d, right, y, right - tt, y);
        }
        return lwidth;
    }

    protected int drawGridYLogTicks(Graphics2D g2d, int left, int top, int right, int bottom) {
        int lwidth = 0;
        float afhgt = this.pmeta_.getFloat("plot:font.height.axes");
        g2d.setFont(this.axisTickFont_);
        FontMetrics fm = g2d.getFontMetrics();
        double logtop = Math.log10(((PanXVertData)this.data_).getTopBound());
        double logbottom = Math.log10(((PanXVertData)this.data_).getBottomBound());
        if (this.flipImageTB_) {
            double logtemp = logtop;
            logtop = logbottom;
            logbottom = logtemp;
        }
        double logrange = logbottom - logtop;
        double logmin = Math.min(logtop, logbottom);
        double logmax = Math.max(logtop, logbottom);
        int iMin = (int)Math.floor(logmin) - 1;
        int iMax = (int)Math.floor(logmax) + 1;
        int intDiv = iMax - iMin;
        int intStep = (intDiv - 2) / 10 + 1;
        block0: for (int j = iMin; j <= iMax; ++j) {
            double value0 = Math.pow(10.0, j);
            for (int k = 0; k < 9; ++k) {
                double value = value0 * (1.0 + (double)k);
                double logval = Math.log10(value);
                if (logval < logmin) continue;
                if (logval > logmax) continue block0;
                double pct = (logval - logtop) / logrange;
                int y = (int)((double)top + pct * (double)this.gridHeight_);
                if (k == 0) {
                    if (j % intStep == 0) {
                        String label = this.yAxisFormatter_.sprintf(Math.pow(10.0, j));
                        g2d.setColor(this.getForeground());
                        GraphicUtilities.drawString(g2d, label, (float)(left - 2 - fm.stringWidth(label)), (float)y + afhgt / 2.0f - 1.0f);
                        lwidth = Math.max(lwidth, fm.stringWidth(label));
                        g2d.setColor(this.gridColor_);
                        g2d.setStroke(this.gridStroke_);
                        GraphicUtilities.drawLine(g2d, left, y, left + this.gridWidth_, y);
                    }
                } else if (intDiv > 6) continue;
                int tt = k == 0 ? (int)((double)afhgt * 2.0 / 3.0) : (int)((double)afhgt / 3.0);
                g2d.setColor(this.getForeground());
                g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
                GraphicUtilities.drawLine(g2d, left, y, left + tt, y);
                GraphicUtilities.drawLine(g2d, right, y, right - tt, y);
            }
        }
        return lwidth;
    }

    protected int drawGridYIndexTicks(Graphics2D g2d, int left, int top, int right, int bottom) {
        float afhgt = this.pmeta_.getFloat("plot:font.height.axes");
        g2d.setFont(this.axisTickFont_);
        FontMetrics fm = g2d.getFontMetrics();
        double ytop = ((PanXVertData)this.data_).getTopBound();
        double ybottom = ((PanXVertData)this.data_).getBottomBound();
        int vSteps = (int)Math.max(ybottom, ytop);
        int vMajor = (vSteps + 4) / 5;
        double delta = 1.0;
        if (this.flipImageTB_) {
            ytop = ybottom;
            delta = -delta;
        }
        int lwidth = 0;
        for (int i = 0; i <= vSteps; ++i) {
            int tick = (int)((double)this.gridHeight_ / (double)vSteps * (double)i);
            if (i == 0) {
                --tick;
            }
            int y = top + tick;
            if (i % vMajor == 0) {
                double axisValue = ytop + (double)i * delta;
                String label = PanConstants.PFORMAT_4G.sprintf(Math.rint(axisValue));
                g2d.setColor(this.getForeground());
                GraphicUtilities.drawString(g2d, label, (float)(left - 2 - fm.stringWidth(label)), (float)y + afhgt / 2.0f);
                lwidth = Math.max(lwidth, fm.stringWidth(label));
                if (i > 0 && i < vSteps && this.gridWeight_ > 0) {
                    g2d.setColor(this.gridColor_);
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtilities.drawLine(g2d, left, y, left + this.gridWidth_, y);
                }
            }
            if (i <= 0 || i >= vSteps) continue;
            int tt = i % vMajor == 0 ? (int)((double)afhgt * 2.0 / 3.0) : (int)((double)afhgt / 3.0);
            g2d.setColor(this.getForeground());
            g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
            GraphicUtilities.drawLine(g2d, left, y, left + tt, y);
            GraphicUtilities.drawLine(g2d, right, y, right - tt, y);
        }
        return lwidth;
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.localParameterChanged(pname);
    }

    private void localParameterChanged(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || pname.equals("all");
        if (changeAll || pname.contains("plot:yaxis.pattern")) {
            String s = this.pmeta_.getString("plot:yaxis.pattern");
            if (s == null) {
                throw new IllegalArgumentException("Null format string");
            }
            this.yAxisFormatter_ = new PrintfFormat(s);
        }
        if (changeAll || pname.contains("plot:yaxis.max") || pname.contains("plot:yaxis.min")) {
            double minY = this.pmeta_.getDouble("plot:yaxis.min");
            double maxY = this.pmeta_.getDouble("plot:yaxis.max");
            ((PanXVertData)this.data_).setVertRange(minY, maxY);
            this.needsDataRedraw_ = true;
            this.needsRecontour_ = true;
        }
        if (changeAll || pname.contains("plot:yaxis.inverted")) {
            this.flipImageTB_ = this.pmeta_.getBoolean("plot:yaxis.inverted");
        }
        if (changeAll || pname.contains("plot:yaxis.label.default")) {
            this.useDefaultYLabel_ = this.pmeta_.getBoolean("plot:yaxis.label.default");
        }
        if (changeAll || pname.contains("plot:yaxis.label.usertext")) {
            this.userYLabel_ = this.pmeta_.getString("plot:yaxis.label.usertext");
        }
    }
}

