/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.netcdf.NcAxis;
import gov.nasa.giss.netcdf.NcTimeAxis;
import gov.nasa.giss.netcdf.time.NcDataTime;
import gov.nasa.giss.netcdf.time.NcJulianTime;
import gov.nasa.giss.netcdf.time.NcRelativeTime;
import gov.nasa.giss.panoply.PanGraphicUtilities;
import gov.nasa.giss.panoply.PanTimeLatData;
import gov.nasa.giss.panoply.plot.PanAbstractPlot2D;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.plot.PlotPieceMargins;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class PanTimeLatPlot
extends PanAbstractPlot2D {
    private PrintfFormat latFormatter_ = new PrintfFormat("%.0f");
    private boolean useDefaultXLabel_;
    private String timeAxisPattern_;
    private String userXLabel_;
    private double minLat_ = -90.0;
    private double maxLat_ = 90.0;

    public PanTimeLatPlot(PanPlotMeta pmeta, PanTimeLatData data) {
        super(pmeta, data);
        NcTimeAxis tAxis = (NcTimeAxis)data.getXAxis();
        if (tAxis.isFormattedTime()) {
            NcDataTime formatter = tAxis.getFormatter();
            this.timeAxisPattern_ = null;
            if (formatter instanceof NcRelativeTime) {
                this.timeAxisPattern_ = ((NcRelativeTime)formatter).getPattern();
            } else if (formatter instanceof NcJulianTime) {
                this.timeAxisPattern_ = ((NcJulianTime)formatter).getPattern();
            }
            if (this.timeAxisPattern_ != null) {
                this.pmeta_.setString("plot:xaxis.pattern", this.timeAxisPattern_);
            }
        }
        this.localParameterChanged("all");
    }

    @Override
    protected void drawGrid(Graphics2D g2d) {
        int left = this.gridXMargin_;
        int right = left + this.gridWidth_;
        int top = this.gridYMargin_;
        int bottom = top + this.gridHeight_;
        float afhgt = this.pmeta_.getFloat("plot:font.height.axes");
        g2d.setColor(this.getForeground());
        Color gcolor = this.gridColor_;
        BasicStroke gstroke = this.gridStroke_;
        g2d.setStroke(gstroke);
        g2d.setFont(this.axisTickFont_);
        FontMetrics fm = g2d.getFontMetrics();
        NcAxis xAxis = ((PanTimeLatData)this.data_).getXAxis();
        NcTimeAxis timeAxis = (NcTimeAxis)xAxis;
        int xlength = timeAxis.getSize();
        int totalDiv = Math.min(this.xMajorDiv_ * this.xMinorDiv_, xlength);
        for (int i = 0; i <= totalDiv; ++i) {
            float tick;
            String axisVal = null;
            if (i == 0) {
                if (this.timeAxisPattern_ != null) {
                    axisVal = timeAxis.formattedBoundsAt(0, 0);
                }
                if (axisVal == null) {
                    axisVal = timeAxis.boundsAt(0, 0) + "";
                }
                tick = 0.0f;
            } else if (i == totalDiv) {
                if (this.timeAxisPattern_ != null) {
                    axisVal = timeAxis.formattedBoundsAt(xlength - 1, 1);
                }
                if (axisVal == null) {
                    axisVal = timeAxis.boundsAt(xlength - 1, 1) + "";
                }
                tick = this.gridWidth_;
            } else {
                int nearest = Math.round((float)(i * xlength) / (float)totalDiv);
                if (this.timeAxisPattern_ != null) {
                    axisVal = timeAxis.formattedBoundsAt(nearest, 0);
                }
                if (axisVal == null) {
                    axisVal = timeAxis.boundsAt(nearest, 0) + "";
                }
                tick = (float)(nearest * this.gridWidth_) / (float)xlength;
            }
            if (i % this.xMinorDiv_ == 0) {
                g2d.setColor(this.getForeground());
                String label = axisVal + "";
                GraphicUtilities.drawString(g2d, label, (float)left + tick - (float)(fm.stringWidth(label) / 2), (float)(bottom + 2) + afhgt);
                if (i > 0 && i < totalDiv && this.gridWeight_ > 0) {
                    g2d.setColor(gcolor);
                    GraphicUtilities.drawLine(g2d, (float)left + tick, top, (float)left + tick, bottom);
                }
            }
            if (i <= 0 || i >= totalDiv) continue;
            g2d.setColor(this.getForeground());
            GraphicUtilities.drawLine(g2d, (float)left + tick, top, (float)left + tick, top + 5);
            GraphicUtilities.drawLine(g2d, (float)left + tick, bottom, (float)left + tick, bottom - 5);
        }
        g2d.setFont(this.axisTickFont_);
        fm = g2d.getFontMetrics();
        double latRange = Math.abs(this.maxLat_ - this.minLat_);
        int latBig = 30;
        if (latRange < 7.0) {
            latBig = 1;
        } else if (latRange < 14.0) {
            latBig = 2;
        } else if (latRange < 35.0) {
            latBig = 5;
        } else if (latRange < 70.0) {
            latBig = 10;
        } else if (latRange < 105.0) {
            latBig = 15;
        }
        int latMajor = 180 / latBig;
        int latMinor = 2;
        int latSteps = latMajor * 2;
        double latDelta = -180.0 / (double)latSteps;
        int lwidth = 0;
        for (int i = 0; i <= latSteps; ++i) {
            double axisVal = this.maxLat_ + (double)i * latDelta;
            if (axisVal > this.maxLat_ || axisVal < this.minLat_) continue;
            int tick = (int)((double)this.gridHeight_ * (axisVal - this.maxLat_) / (this.minLat_ - this.maxLat_));
            if (i == 0) {
                --tick;
            }
            if (i % 2 == 0) {
                String label = this.latFormatter_.sprintf(axisVal);
                g2d.setColor(this.getForeground());
                GraphicUtilities.drawString(g2d, label, (float)(left - 2 - fm.stringWidth(label)), (float)(top + tick) + afhgt / 2.0f);
                lwidth = Math.max(lwidth, fm.stringWidth(label));
                if (i > 0 && i < latSteps && this.gridWeight_ > 0) {
                    g2d.setColor(gcolor);
                    GraphicUtilities.drawLine(g2d, left, top + tick, left + this.gridWidth_, top + tick);
                }
            }
            if (i <= 0 || i >= latSteps) continue;
            g2d.setColor(this.getForeground());
            GraphicUtilities.drawLine(g2d, left, top + tick, left + 5, top + tick);
            GraphicUtilities.drawLine(g2d, right, top + tick, right - 5, top + tick);
        }
        g2d.setColor(this.getForeground());
        g2d.setStroke(PanGraphicUtilities.squareMiterStroke(100));
        GraphicUtilities.drawRect(g2d, left, top, this.gridWidth_, this.gridHeight_);
        String xLabel = null;
        if (this.useDefaultXLabel_) {
            String xUnits = xAxis.getUnits();
            xLabel = ((NcTimeAxis)xAxis).isFormattedTime() ? xUnits : (xUnits != null ? "Time (" + xUnits + ")" : "Time");
        } else {
            xLabel = this.userXLabel_;
        }
        if (xLabel != null && xLabel.length() > 0) {
            g2d.setFont(this.axisNameFont_);
            fm = g2d.getFontMetrics();
            g2d.setColor(this.getForeground());
            GraphicUtilities.drawString(g2d, xLabel, (float)(left + (this.gridWidth_ - fm.stringWidth(xLabel)) / 2), (float)(bottom + 2) + afhgt + 6.0f + afhgt);
        }
        g2d.setFont(this.axisNameFont_);
        fm = g2d.getFontMetrics();
        String ylabel = "Latitude (\u00b0N)";
        g2d.setColor(this.getForeground());
        g2d.translate(left - 2 - lwidth - 10, bottom - (this.gridHeight_ - fm.stringWidth(ylabel)) / 2);
        g2d.rotate(-1.5707963267948966);
        GraphicUtilities.drawString(g2d, ylabel, 0, 0);
        g2d.rotate(1.5707963267948966);
        g2d.translate(-(left - 2 - lwidth - 10), -(bottom - (this.gridHeight_ - fm.stringWidth(ylabel)) / 2));
    }

    @Override
    protected void drawVectors(Graphics2D g2d) {
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        PlotPieceMargins margins = this.getMargins();
        y -= (double)(margins.top + this.gridYMargin_);
        if ((x -= (double)(margins.left + this.gridXMargin_)) < 0.0 || y < 0.0 || x > (double)this.gridWidth_ || y > (double)this.gridHeight_) {
            return null;
        }
        return ((PanTimeLatData)this.data_).transformXY2GridCoords(x, y);
    }

    @Override
    public String describePoint(int x, int y) {
        Rectangle gbounds = this.pmeta_.getRect("plot:bounds.graphic");
        if ((x -= gbounds.x + this.gridXMargin_) < 0 || (y -= gbounds.y + this.gridYMargin_) < 0 || x > this.gridWidth_ || y > this.gridHeight_) {
            return null;
        }
        StringBuilder sb = new StringBuilder("");
        ((PanTimeLatData)this.data_).describeData(sb, x, y);
        return sb.toString();
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.localParameterChanged(pname);
    }

    private void localParameterChanged(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || pname.equals("all");
        if (changeAll || pname.contains("plot:xaxis.pattern")) {
            this.timeAxisPattern_ = this.pmeta_.getString("plot:xaxis.pattern");
            if (this.timeAxisPattern_.length() > 0) {
                ((PanTimeLatData)this.data_).setTimePattern(this.timeAxisPattern_);
            } else {
                this.timeAxisPattern_ = null;
            }
        }
        if (changeAll || pname.contains("plot:xaxis.label.default")) {
            this.useDefaultXLabel_ = this.pmeta_.getBoolean("plot:xaxis.label.default");
        }
        if (changeAll || pname.contains("plot:xaxis.label.usertext")) {
            this.userXLabel_ = this.pmeta_.getString("plot:xaxis.label.usertext");
        }
        if (changeAll || pname.contains("plot:yaxis.max") || pname.contains("plot:yaxis.min")) {
            this.minLat_ = this.pmeta_.getDouble("plot:yaxis.min");
            this.maxLat_ = this.pmeta_.getDouble("plot:yaxis.max");
            ((PanTimeLatData)this.data_).setLatRange(this.minLat_, this.maxLat_);
            this.needsDataRedraw_ = true;
            this.needsRecontour_ = true;
        }
    }
}

