/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanScaleTick;
import java.util.ArrayList;

public class PanScaleMeta {
    protected PanAbstractData data_;
    private PanPlotMeta pmeta_;

    public PanScaleMeta(PanPlotMeta pmeta, PanAbstractData data) {
        this.pmeta_ = pmeta;
        this.data_ = data;
    }

    public double getMinimum() {
        double min;
        double d = min = this.pmeta_.getBoolean("plot:scale.autofit") ? this.data_.getMinimumValue() : this.pmeta_.getDouble("plot:scale.minimum");
        if (Double.isNaN(min)) {
            min = -0.1;
        }
        if (this.pmeta_.getBoolean("plot:scale.log10") && min <= 0.0) {
            min = 1.0E-50;
        }
        return min;
    }

    public double getMaximum() {
        double max;
        double d = max = this.pmeta_.getBoolean("plot:scale.autofit") ? this.data_.getMaximumValue() : this.pmeta_.getDouble("plot:scale.maximum");
        if (Double.isNaN(max)) {
            max = 0.1;
        }
        if (this.pmeta_.getBoolean("plot:scale.log10") && max <= 1.0E-50) {
            max = 1.0E-25;
        }
        return max;
    }

    public PanScaleTick[] getTicks() {
        if (this.pmeta_.getBoolean("plot:scale.log10")) {
            return this.getLogarithmicTicks();
        }
        return this.getStandardTicks();
    }

    public PanScaleTick[] getStandardTicks() {
        double scaleMin = this.getMinimum();
        double scaleMax = this.getMaximum();
        int majorDiv = Math.max(1, this.pmeta_.getInt("plot:scale.majordiv"));
        majorDiv = Math.min(20, majorDiv);
        int minorDiv = Math.max(1, this.pmeta_.getInt("plot:scale.minordiv"));
        minorDiv = Math.min(20, minorDiv);
        int totalDivs = minorDiv * majorDiv;
        double divSize = scaleMax - scaleMin == 0.0 ? 1.0E-25 : (scaleMax - scaleMin) / (double)totalDivs;
        PanScaleTick[] ticks = new PanScaleTick[totalDivs + 1];
        for (int i = 0; i <= totalDivs; ++i) {
            double value = scaleMin + (double)i * divSize;
            ticks[i] = i == 0 || i == totalDivs ? new PanScaleTick(value, PanScaleTick.TickType.ENDPOINT) : (i % minorDiv == 0 ? new PanScaleTick(value, PanScaleTick.TickType.MAJOR) : new PanScaleTick(value, PanScaleTick.TickType.MINOR));
        }
        return ticks;
    }

    public PanScaleTick[] getLogarithmicTicks() {
        double scaleMin = this.getMinimum();
        double scaleMax = this.getMaximum();
        double logScaleMin = Math.log10(scaleMin);
        double logScaleMax = Math.log10(scaleMax);
        ArrayList<PanScaleTick> ticks = new ArrayList<PanScaleTick>();
        int iMin = (int)Math.floor(logScaleMin) - 1;
        int iMax = (int)Math.floor(logScaleMax) + 1;
        int intDiv = iMax - iMin;
        int intStep = (intDiv - 2) / 10 + 1;
        block0: for (int j = iMin; j <= iMax; ++j) {
            double value0 = Math.pow(10.0, j);
            for (int k = 0; k < 9; ++k) {
                double value = value0 * (1.0 + (double)k);
                if (value < scaleMin) continue;
                if (value > scaleMax) continue block0;
                double logValue = Math.log10(value);
                if (k == 0) {
                    if (j % intStep == 0) {
                        ticks.add(new PanScaleTick(value, PanScaleTick.TickType.MAJOR));
                        continue;
                    }
                    ticks.add(new PanScaleTick(value, PanScaleTick.TickType.MINOR));
                    continue;
                }
                if (intDiv > 15) continue;
                ticks.add(new PanScaleTick(value, PanScaleTick.TickType.LEAST));
            }
        }
        return ticks.toArray(new PanScaleTick[0]);
    }

    public double[] getContourTickValues() {
        boolean includeMinor = this.pmeta_.getString("plot:contour.location").equalsIgnoreCase("minor");
        ArrayList<Double> al = new ArrayList<Double>();
        for (PanScaleTick tick : this.getTicks()) {
            if (tick.getType() != PanScaleTick.TickType.MAJOR && (!includeMinor || tick.getType() != PanScaleTick.TickType.MINOR)) continue;
            al.add(tick.getValue());
        }
        Double[] dd = al.toArray(new Double[0]);
        double[] values = new double[dd.length];
        for (int i = 0; i < dd.length; ++i) {
            values[i] = dd[i];
        }
        return values;
    }

    public double[] getMajorTickValues() {
        ArrayList<Double> al = new ArrayList<Double>();
        for (PanScaleTick tick : this.getTicks()) {
            if (tick.getType() != PanScaleTick.TickType.MAJOR) continue;
            al.add(tick.getValue());
        }
        Double[] dd = al.toArray(new Double[0]);
        double[] values = new double[dd.length];
        for (int i = 0; i < dd.length; ++i) {
            values[i] = dd[i];
        }
        return values;
    }
}

