/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.DoubleParameter;
import gov.nasa.giss.map.proj.Equirectangular;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.map.proj.ExtraParameter;
import gov.nasa.giss.map.proj.VerticalPerspective;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanProjectionPrefs;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.text.TextUtilities;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanProjectionMeta {
    private static Logger logger_ = LoggerFactory.getLogger(PanProjectionMeta.class);
    private PanPlotMeta pmeta_;
    private AbstractProjection projection_;
    private Hashtable<String, String> paramHash_ = new Hashtable(25);
    private int width_ = 2;
    private int height_ = 2;
    private int hmargin_ = 0;
    private int vmargin_ = 0;
    private double llLeft_ = -180.0;
    private double llTop_ = 90.0;
    private double llRight_ = 180.0;
    private double llBottom_ = -90.0;

    public PanProjectionMeta(PanPlotMeta pmeta) {
        this.pmeta_ = pmeta;
    }

    public AbstractProjection getProjection() {
        return this.projection_;
    }

    public void setProjection(String name) {
        AbstractProjection old = this.projection_;
        int w = Math.max(2, this.width_);
        int h = Math.max(2, this.height_);
        if (name.equals("Equirectangular (Regional)")) {
            this.projection_ = new EquirectangularRegional(w, h, this.hmargin_, this.vmargin_);
        } else {
            try {
                this.projection_ = ProjectionFactory.create(name, w, h, this.hmargin_, this.vmargin_);
            }
            catch (Exception exc) {
                this.projection_ = new Equirectangular(w, h, this.hmargin_, this.vmargin_);
            }
        }
        this.projection_.setZoom(1.0);
        if (old == null) {
            this.projection_.setCenter(0.0, 0.0);
        } else {
            this.projection_.setCenter(old.getCenter());
            this.projection_.setBorderStroke(old.getBorderStroke());
            this.projection_.setLonGridSpacing(old.getLonGridSpacing());
            this.projection_.setLatGridSpacing(old.getLatGridSpacing());
            this.projection_.setGridColor(old.getGridColor());
            this.projection_.setGridStroke(old.getGridStroke());
            this.projection_.setGridLabeled(old.isGridLabeled());
            this.projection_.setPathPoints(old.getPathPoints());
            this.projection_.setPathColor(old.getPathColor());
            this.projection_.setPathStroke(old.getPathStroke());
        }
        int pcount = this.projection_.getParameterCount();
        for (int i = 0; i < pcount; ++i) {
            ExtraParameter ep = this.projection_.getParameter(i);
            String key = name + "-" + i;
            String value = this.paramHash_.get(key);
            if (value == null || value.length() == 0) {
                value = PanProjectionPrefs.getParam(name, i);
            }
            if (value == null || value.length() == 0) continue;
            this.setExtraParameter(i, value);
        }
        this.updateGridEdges();
    }

    public void setSize(int width, int height) {
        this.width_ = width;
        this.height_ = height;
        this.projection_.setSize(this.width_, this.height_, this.hmargin_, this.vmargin_);
        this.updateGridEdges();
    }

    public void setMargins(int hmargin, int vmargin) {
        this.hmargin_ = hmargin;
        this.vmargin_ = vmargin;
        this.projection_.setSize(this.width_, this.height_, this.hmargin_, this.vmargin_);
        this.updateGridEdges();
    }

    public void setCenterLon(double lon) {
        PointLL c = this.projection_.getCenter();
        this.projection_.setCenter(lon, c.getLat());
        this.updateGridEdges();
    }

    public void setCenterLat(double lat) {
        PointLL c = this.projection_.getCenter();
        this.projection_.setCenter(c.getLon(), lat);
        this.updateGridEdges();
    }

    public boolean isEquirectangular() {
        return this.projection_ instanceof EquirectangularRegional || this.projection_ instanceof Equirectangular;
    }

    public boolean isAzimuthal() {
        return this.projection_.isAzimuthal();
    }

    public boolean isConic() {
        return this.projection_.isConic();
    }

    public synchronized double[] getGridEdges() {
        this.updateGridEdges();
        return new double[]{this.llLeft_, this.llTop_, this.llRight_, this.llBottom_};
    }

    private void updateGridEdges() {
        this.llLeft_ = -180.0;
        this.llTop_ = 90.0;
        this.llRight_ = 180.0;
        this.llBottom_ = -90.0;
        if (this.projection_ instanceof EquirectangularRegional) {
            EquirectangularRegional er = (EquirectangularRegional)this.projection_;
            double lon = er.getCenter().getLon();
            double lat = er.getCenter().getLat();
            double w = er.getWidth();
            double h = er.getHeight();
            this.llLeft_ = lon - 0.5 * w;
            this.llTop_ = Math.min(90.0, lat + 0.5 * h);
            this.llRight_ = lon + 0.5 * w;
            this.llBottom_ = Math.max(-90.0, lat - 0.5 * h);
        } else if (this.projection_.isConic()) {
            this.updateConicProjectionEdges();
        } else if (this.projection_.isAzimuthal()) {
            this.updateAzimuthalProjectionEdges();
        }
    }

    private synchronized void updateAzimuthalProjectionEdges() {
        double dlon2;
        double dlon1;
        double lat;
        PointLL ll;
        double coplon = this.projection_.getCenter().getLon();
        double coplat = this.projection_.getCenter().getLat();
        int w = this.width_;
        int h = this.height_;
        double wOver2 = 0.5 * (double)w;
        double hOver2 = 0.5 * (double)h;
        double tLat = -9999.0;
        double bLat = 9999.0;
        if (this.projection_.transformLL2XY(0.0, 90.0) != null) {
            tLat = 90.0;
        }
        if (this.projection_.transformLL2XY(0.0, -90.0) != null) {
            bLat = -90.0;
        }
        int j1 = 0;
        int j2 = 0;
        int j = 0;
        while ((double)j < hOver2) {
            ll = this.projection_.transformXY2LL(wOver2, (double)j + 0.5);
            if (ll != null) {
                lat = ll.getLat();
                tLat = Math.max(tLat, lat);
                bLat = Math.min(bLat, lat);
                j1 = j;
                break;
            }
            ++j;
        }
        j = h - 1;
        while ((double)j > hOver2) {
            ll = this.projection_.transformXY2LL(wOver2, (double)j + 0.5);
            if (ll != null) {
                lat = ll.getLat();
                tLat = Math.max(tLat, lat);
                bLat = Math.min(bLat, lat);
                j2 = j;
                break;
            }
            --j;
        }
        double dlon = 0.0;
        if (tLat < 90.0 && bLat > -90.0) {
            double r = Math.abs((double)j1 - hOver2);
            for (int i = 5; i < 90; i += 5) {
                double rCos = r * Math.cos(Math.toRadians(i));
                double rSin = r * Math.sin(Math.toRadians(i));
                PointLL ll1 = this.projection_.transformXY2LL(wOver2 + rCos - 1.0, hOver2 + rSin - 1.0);
                PointLL ll2 = this.projection_.transformXY2LL(wOver2 - rCos + 1.0, hOver2 - rSin + 1.0);
                dlon1 = ll1 == null ? 0.0 : (coplon > ll1.getLon() ? 1.1 * Math.abs(coplon - (ll1.getLon() + 360.0)) : 1.1 * Math.abs(coplon - ll1.getLon()));
                dlon2 = ll2 == null ? 0.0 : (coplon < ll2.getLon() ? 1.1 * Math.abs(coplon - (ll2.getLon() - 360.0)) : 1.1 * Math.abs(coplon - ll2.getLon()));
                dlon = Math.max(Math.max(dlon, dlon1), dlon2);
            }
        }
        int i = 0;
        while ((double)i < wOver2) {
            double lat2;
            PointLL ll1 = this.projection_.transformXY2LL(wOver2 + (double)i, (double)j1 + 0.5);
            PointLL ll2 = this.projection_.transformXY2LL(wOver2 + (double)i, (double)j2 + 0.5);
            if (ll1 == null && ll2 == null) break;
            if (ll1 == null) {
                dlon1 = 0.0;
            } else {
                lat2 = ll1.getLat();
                tLat = Math.max(tLat, lat2);
                bLat = Math.min(bLat, lat2);
                dlon1 = coplon > ll1.getLon() ? 1.01 * Math.abs(coplon - (ll1.getLon() + 360.0)) : 1.01 * Math.abs(coplon - ll1.getLon());
            }
            if (ll2 == null) {
                dlon2 = 0.0;
            } else {
                lat2 = ll2.getLat();
                tLat = Math.max(tLat, lat2);
                bLat = Math.min(bLat, lat2);
                dlon2 = coplon > ll2.getLon() ? 1.01 * Math.abs(coplon - (ll2.getLon() + 360.0)) : 1.01 * Math.abs(coplon - ll2.getLon());
            }
            dlon = Math.max(Math.max(dlon, dlon1), dlon2);
            ++i;
        }
        double dlat = Math.max(Math.abs(coplat - tLat), Math.abs(coplat - bLat));
        this.llTop_ = Math.min(90.0, tLat);
        this.llBottom_ = Math.max(-90.0, bLat);
        if (tLat > 89.5 || bLat < -89.5 || dlon > 180.0) {
            dlon = 180.0;
        } else {
            PointLL ll1;
            dlon = Math.max(dlon, dlat);
            int i1 = 0;
            int i2 = 0;
            while ((double)i2 < wOver2) {
                ll1 = this.projection_.transformXY2LL((double)i2, hOver2);
                if (ll1 != null) {
                    dlon1 = coplon < ll1.getLon() ? 1.1 * Math.abs(coplon - (ll1.getLon() - 360.0)) : 1.1 * Math.abs(coplon - ll1.getLon());
                    dlon = Math.max(dlon, dlon1);
                    i1 = i2;
                    break;
                }
                ++i2;
            }
            int j3 = 0;
            while ((double)j3 < hOver2) {
                ll1 = this.projection_.transformXY2LL((double)i1, hOver2 - (double)j3 + 0.5);
                PointLL ll2 = this.projection_.transformXY2LL((double)i1, hOver2 + (double)j3 + 0.5);
                if (ll1 == null && ll2 == null) break;
                dlon1 = ll1 == null ? 0.0 : (coplon < ll1.getLon() ? 1.1 * Math.abs(coplon - (ll1.getLon() - 360.0)) : 1.1 * Math.abs(coplon - ll1.getLon()));
                dlon2 = ll2 == null ? 0.0 : (coplon < ll2.getLon() ? 1.1 * Math.abs(coplon - (ll2.getLon() - 360.0)) : 1.1 * Math.abs(coplon - ll2.getLon()));
                dlon = Math.max(Math.max(dlon, dlon1), dlon2);
                ++j3;
            }
        }
        this.llLeft_ = coplon - dlon;
        this.llRight_ = coplon + dlon;
        if (this.llRight_ - this.llLeft_ > 300.0) {
            this.llLeft_ = -180.0;
            this.llRight_ = 180.0;
        } else if (this.llLeft_ < -180.0) {
            this.llLeft_ += 360.0;
            this.llRight_ += 360.0;
        }
    }

    private synchronized void updateConicProjectionEdges() {
        int ix;
        PointLL ll;
        double coplon = this.projection_.getCenter().getLon();
        double coplat = this.projection_.getCenter().getLat();
        int w = this.width_;
        int h = this.height_;
        int wOver2 = w / 2;
        int hOver2 = h / 2;
        try {
            ll = this.projection_.transformXY2LL((double)wOver2, (double)hOver2);
            if (ll == null) {
                return;
            }
        }
        catch (Exception exc) {
            return;
        }
        double xright = Math.min(w, w - this.hmargin_ + 1);
        double ytop = Math.max(0, this.vmargin_ - 1);
        double ybottom = Math.min(h, h - this.vmargin_ + 1);
        double tLat = Double.NaN;
        double bLat = Double.NaN;
        Point2D.Double xy = this.projection_.transformLL2XY(coplon, 90.0);
        if (xy != null && xy.y > 0.0 && xy.y < (double)h) {
            tLat = 90.0;
        }
        if (Double.isNaN(tLat)) {
            ix = wOver2;
            while ((double)ix < xright) {
                ll = this.projection_.transformXY2LL((double)ix, ytop + 1.0);
                if (ll == null) {
                    if (ix == wOver2) {
                        break;
                    }
                } else {
                    double lat = ll.getLat();
                    if (Double.isNaN(tLat) || lat > tLat) {
                        tLat = lat;
                    }
                }
                ++ix;
            }
            if (Double.isNaN(tLat)) {
                tLat = 90.0;
            }
        }
        if ((xy = this.projection_.transformLL2XY(coplon, -90.0)) != null && xy.y > 0.0 && xy.y < (double)h) {
            bLat = -90.0;
        }
        if (Double.isNaN(bLat)) {
            ix = wOver2;
            while ((double)ix < xright) {
                ll = this.projection_.transformXY2LL((double)ix, ybottom - 1.0);
                if (ll == null) {
                    if (ix == wOver2) {
                        break;
                    }
                } else {
                    double lat = ll.getLat();
                    if (Double.isNaN(bLat) || lat < bLat) {
                        bLat = lat;
                    }
                }
                ++ix;
            }
            if (Double.isNaN(bLat)) {
                bLat = -90.0;
            }
        }
        if (tLat > 89.0 || bLat < -89.0) {
            this.llLeft_ = -180.0;
            this.llTop_ = 90.0;
            this.llRight_ = 180.0;
            this.llBottom_ = -90.0;
            return;
        }
        this.llTop_ = tLat + 1.0;
        this.llBottom_ = bLat - 1.0;
        double dlon = -9999.0;
        int jy = (int)ytop + 1;
        while ((double)jy < ybottom - 1.0) {
            ll = this.projection_.transformXY2LL(xright - 1.0, (double)jy);
            if (ll == null) {
                dlon = 180.0;
                break;
            }
            double xlon = ll.getLon();
            if (xlon < coplon) {
                xlon += 360.0;
            }
            dlon = Math.max(dlon, xlon - coplon);
            ++jy;
        }
        if (2.0 * (dlon += 1.0) > 300.0) {
            this.llLeft_ = -180.0;
            this.llRight_ = 180.0;
        } else {
            this.llLeft_ = coplon - dlon;
            this.llRight_ = coplon + dlon;
        }
    }

    public String getDescription() {
        if (this.projection_ == null) {
            return "";
        }
        StringBuilder desc = new StringBuilder();
        desc.append(this.projection_.getName()).append(" projection centered on ").append(PanConstants.PFORMAT_D2.sprintf(this.projection_.getCenter().getLon())).append("E");
        if (this.projection_.isOblique()) {
            desc.append(" ").append(PanConstants.PFORMAT_D2.sprintf(this.projection_.getCenter().getLat())).append("N");
        }
        return desc.toString();
    }

    public String getExtraParameter(int index) {
        if (index >= this.projection_.getParameterCount()) {
            return null;
        }
        String name = this.projection_.getName();
        String key = name + "-" + index;
        String value = this.paramHash_.get(key);
        if (value != null && value.length() > 0) {
            return value;
        }
        value = PanProjectionPrefs.getParam(name, index);
        if (value != null && value.length() > 0) {
            return value;
        }
        Object oo = this.projection_.getParameter(index).getDefaultObject();
        if (oo != null) {
            return oo.toString();
        }
        return null;
    }

    public boolean setExtraParameter(int pid, String svalue) {
        AbstractProjection proj = this.getProjection();
        Object oo = null;
        try {
            oo = proj.getParameter(pid).getDefaultObject();
        }
        catch (Exception exc) {
            return false;
        }
        if (svalue == null && oo != null) {
            svalue = oo.toString();
        }
        String pname = this.projection_.getName();
        String key = pname + "-" + pid;
        this.paramHash_.put(key, svalue);
        if (oo == null) {
            logger_.warn("Current value for index {} is null", (Object)pid);
        } else {
            if (oo instanceof Boolean) {
                try {
                    Boolean b = new Boolean(svalue);
                    proj.getParameter(pid).setValue(b);
                    return true;
                }
                catch (Exception exc) {
                    logger_.warn("Cannot convert '{}' to a boolean value", (Object)svalue);
                    return false;
                }
            }
            if (oo instanceof Double) {
                try {
                    Double dd = TextUtilities.parseDouble(svalue);
                    proj.getParameter(pid).setValue(dd);
                    return true;
                }
                catch (Exception exc) {
                    logger_.warn("Cannot convert '{}' to a double value", (Object)svalue);
                    return false;
                }
            }
        }
        return false;
    }

    public boolean isZoomable() {
        if (this.projection_ instanceof EquirectangularRegional || this.projection_ instanceof Equirectangular) {
            return true;
        }
        if (this.projection_.isAzimuthal()) {
            return !(this.projection_ instanceof VerticalPerspective);
        }
        return false;
    }

    public boolean canZoomIn() {
        if (!this.isZoomable()) {
            return false;
        }
        if (this.projection_ instanceof Equirectangular) {
            return true;
        }
        if (this.projection_ instanceof EquirectangularRegional) {
            try {
                DoubleParameter wp = (DoubleParameter)this.projection_.getParameter(0);
                DoubleParameter hp = (DoubleParameter)this.projection_.getParameter(1);
                double w = wp.getValue();
                double h = hp.getValue();
                return w > wp.getMinimum() || h > hp.getMinimum();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        } else if (this.projection_.isAzimuthal()) {
            try {
                DoubleParameter rp = (DoubleParameter)this.projection_.getParameter(0);
                double r = rp.getValue();
                return r > rp.getMinimum();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return false;
    }

    public boolean canZoomOut() {
        if (!this.isZoomable()) {
            return false;
        }
        if (this.projection_ instanceof Equirectangular) {
            return false;
        }
        if (this.projection_ instanceof EquirectangularRegional) {
            try {
                DoubleParameter wp = (DoubleParameter)this.projection_.getParameter(0);
                DoubleParameter hp = (DoubleParameter)this.projection_.getParameter(1);
                double w = wp.getValue();
                double h = hp.getValue();
                return w < 360.0 || h < 180.0;
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        } else if (this.projection_.isAzimuthal()) {
            try {
                DoubleParameter rp = (DoubleParameter)this.projection_.getParameter(0);
                double r = rp.getValue();
                return r < rp.getMaximum();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return false;
    }
}

