/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanGraphicUtilities;
import gov.nasa.giss.panoply.PanScaleCaptionLocation;
import gov.nasa.giss.panoply.PanScaleOutlier;
import gov.nasa.giss.panoply.PanUtilities;
import gov.nasa.giss.panoply.PanVectorStyle;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.plot.PanScaleMeta;
import gov.nasa.giss.panoply.plot.PanScaleTick;
import gov.nasa.giss.plot.PlotPieceMargins;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;

public class PanPlotScale
extends PanPlotPiece {
    private static final double COS45 = Math.cos(Math.toRadians(45.0));
    private PanAbstractData data_;
    private PanScaleMeta smeta_;
    private AbstractColorTable colortable_;
    private boolean inverted_;
    private boolean useDefaultCaption_ = true;
    private String userCaption_ = "";
    private boolean captionAbove_ = true;
    private String formatString_ = "%.0f";
    private PrintfFormat formatter_;
    private Font titleFont_;
    private int barHeight_;
    private Font ticksFont_;
    private int outlierGap_;
    private int outlierWidth_;
    private int titleY_;
    private int barTopY_;
    private int barBottomY_;
    private int ticksY_;
    private float barWidth_;
    private float barLeft_;
    private float barRight_;
    private PanVectorStyle vectorStyle_;
    private int vectorWeight_;
    private Color vectorColor_;
    private BasicStroke vectorStroke_;
    private boolean needsResize_ = true;

    public PanPlotScale(PanPlotMeta pmeta, PanAbstractData data, PanScaleMeta scaleDescription) {
        super(pmeta);
        this.data_ = data;
        this.smeta_ = scaleDescription;
        this.setMargins(4, 0, 4, 2);
        this.setOpaque(true);
        this.formatter_ = new PrintfFormat(this.formatString_);
        this.localParameterChanged("all");
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.needsResize_ = true;
    }

    private void updateSizing() {
        float tickFactor;
        float barFactor;
        float titleFactor;
        String fn = this.pmeta_.getString("plot:font.master");
        switch (this.pmeta_.getInt("plot:scale.tick.size")) {
            case 9: {
                titleFactor = 16.0f;
                barFactor = 15.0f;
                tickFactor = 9.0f;
                break;
            }
            case 11: {
                titleFactor = 15.5f;
                barFactor = 14.5f;
                tickFactor = 11.0f;
                break;
            }
            case 12: {
                titleFactor = 15.0f;
                barFactor = 14.0f;
                tickFactor = 12.0f;
                break;
            }
            case 13: {
                titleFactor = 14.75f;
                barFactor = 13.25f;
                tickFactor = 13.0f;
                break;
            }
            case 14: {
                titleFactor = 14.5f;
                barFactor = 12.5f;
                tickFactor = 14.0f;
                break;
            }
            default: {
                titleFactor = 16.0f;
                barFactor = 15.0f;
                tickFactor = 10.0f;
            }
        }
        int width = this.getWidth();
        int height = this.getHeight();
        PlotPieceMargins margins = this.getMargins();
        float hh = height - margins.top - margins.bottom;
        this.barHeight_ = (int)(hh * (barFactor / 49.0f) + 0.25f);
        int titleFHeight = (int)(hh * (titleFactor / 49.0f) + 0.25f);
        int ticksFHeight = (int)(hh * (tickFactor / 49.0f) + 0.25f);
        int gap1 = Math.max((int)(hh * 0.08163265f + 0.25f), 4);
        int gap2 = Math.max((int)(hh * 0.040816326f + 0.25f), 2);
        try {
            this.titleFont_ = new Font(fn, 0, titleFHeight);
        }
        catch (Exception exc) {
            this.titleFont_ = new Font("SansSerif", 0, titleFHeight);
        }
        try {
            this.ticksFont_ = new Font(fn, 0, ticksFHeight);
        }
        catch (Exception exc) {
            this.ticksFont_ = new Font("SansSerif", 0, ticksFHeight);
        }
        this.outlierGap_ = this.barHeight_ / 2;
        this.outlierWidth_ = this.barHeight_ / 2;
        if (this.captionAbove_) {
            this.titleY_ = margins.top + titleFHeight;
            this.barTopY_ = this.titleY_ + gap1;
            this.barBottomY_ = this.barTopY_ + this.barHeight_;
            this.ticksY_ = this.barBottomY_ + gap2 + ticksFHeight;
        } else {
            this.barTopY_ = margins.top;
            this.barBottomY_ = this.barTopY_ + this.barHeight_;
            this.ticksY_ = this.barBottomY_ + gap2 + ticksFHeight;
            this.titleY_ = this.ticksY_ + gap1 + titleFHeight;
        }
        this.barWidth_ = 0.6f * (float)width - (float)margins.left - (float)margins.right - 2.0f * (float)(this.outlierGap_ + this.outlierWidth_ + 2);
        this.barLeft_ = 0.5f * ((float)width - this.barWidth_);
        this.barRight_ = this.barLeft_ + this.barWidth_;
        this.needsResize_ = false;
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        if (this.colortable_ == null) {
            return;
        }
        if (this.needsResize_) {
            this.updateSizing();
        }
        this.drawCaption(gx);
        this.drawColorBar(gx);
        if (this.pmeta_.getBoolean("plot:scale.log10")) {
            this.drawLogarithmicTicks(gx);
        } else {
            this.drawStandardTicks(gx);
        }
        this.drawOutliers(gx);
        this.drawScaleVector(gx);
    }

    private void drawCaption(Graphics2D g2d) {
        g2d.setColor(this.getForeground());
        g2d.setFont(this.titleFont_);
        FontMetrics fm = g2d.getFontMetrics();
        String caption = this.getCaption();
        GraphicUtilities.drawString(g2d, caption, (int)(0.5 * (double)(this.getWidth() - fm.stringWidth(caption))), this.titleY_);
    }

    private void drawColorBar(Graphics2D g2d) {
        int colorCount = this.colortable_.getColorCount();
        float binWidth = this.barWidth_ / (float)colorCount;
        g2d.setStroke(PanConstants.FINE_SQUARE_STROKE);
        for (int i = 0; i < colorCount; ++i) {
            Color c2;
            float bleft = this.barLeft_ + binWidth * (float)i;
            Color c1 = this.colortable_.getColorAt(i, this.inverted_);
            int iwidth = 1;
            for (int j = i + 1; j < colorCount && (c2 = this.colortable_.getColorAt(j, this.inverted_)).equals(c1); ++j) {
                ++iwidth;
            }
            float bwidth = binWidth * (float)iwidth;
            i += iwidth - 1;
            if (bleft + bwidth < this.barRight_) {
                bwidth += Math.min(1.0f, this.barRight_ - bleft + bwidth);
            }
            g2d.setColor(this.colortable_.getColorAt(i, this.inverted_));
            GraphicUtilities.fillDrawnRect(g2d, bleft, this.barTopY_, bwidth, this.barHeight_);
        }
        g2d.setColor(this.getForeground());
        g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
        GraphicUtilities.drawRect(g2d, this.barLeft_, this.barTopY_, this.barWidth_, this.barHeight_);
    }

    private void drawStandardTicks(Graphics2D g2d) {
        double scaleMin = this.smeta_.getMinimum();
        double scaleMax = this.smeta_.getMaximum();
        double scaleRange = scaleMax - scaleMin;
        if (scaleRange <= 0.0) {
            scaleRange = 1.0E-25;
        }
        double mstep = (double)this.barWidth_ / scaleRange;
        g2d.setColor(this.getForeground());
        g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
        g2d.setFont(this.ticksFont_);
        FontMetrics fm = g2d.getFontMetrics();
        String tickLabel = "";
        for (PanScaleTick tick : this.smeta_.getStandardTicks()) {
            float tbot;
            float ttop;
            double value = tick.getValue();
            float tickX = (float)((double)this.barLeft_ + (value - scaleMin) * mstep);
            PanScaleTick.TickType tt = tick.getType();
            if (tt == PanScaleTick.TickType.MAJOR || tt == PanScaleTick.TickType.ENDPOINT) {
                tickLabel = this.formatter_.sprintf(value);
                if (tt == PanScaleTick.TickType.ENDPOINT) {
                    ttop = this.barBottomY_;
                    tbot = this.barBottomY_ + 3;
                } else {
                    ttop = this.barBottomY_ - 3;
                    tbot = this.barBottomY_ + 3;
                }
                GraphicUtilities.drawString(g2d, tickLabel, tickX - (float)((int)(0.5 * (double)fm.stringWidth(tickLabel))), (float)this.ticksY_);
            } else {
                ttop = this.barBottomY_ - 3;
                tbot = this.barBottomY_;
            }
            GraphicUtilities.drawLine(g2d, tickX, ttop, tickX, tbot);
        }
    }

    private void drawLogarithmicTicks(Graphics2D g2d) {
        double scaleMin = this.smeta_.getMinimum();
        double scaleMax = this.smeta_.getMaximum();
        double logScaleMin = Math.log10(scaleMin);
        double logScaleMax = Math.log10(scaleMax);
        double scaleRange = logScaleMax - logScaleMin;
        if (scaleRange <= 0.0) {
            scaleRange = 1.0E-25;
        }
        double mstep = (double)this.barWidth_ / scaleRange;
        g2d.setColor(this.getForeground());
        g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
        g2d.setFont(this.ticksFont_);
        FontMetrics fm = g2d.getFontMetrics();
        String tickLabel = "";
        for (PanScaleTick tick : this.smeta_.getLogarithmicTicks()) {
            double value = tick.getValue();
            double logValue = Math.log10(value);
            float tickX = (float)((double)this.barLeft_ + (logValue - logScaleMin) * mstep);
            if (tick.getType() == PanScaleTick.TickType.MAJOR) {
                GraphicUtilities.drawLine(g2d, tickX, this.barBottomY_ - 3, tickX, this.barBottomY_ + 3);
                tickLabel = this.formatter_.sprintf(value);
                GraphicUtilities.drawString(g2d, tickLabel, tickX - (float)((int)(0.5 * (double)fm.stringWidth(tickLabel))), (float)this.ticksY_);
                continue;
            }
            if (tick.getType() == PanScaleTick.TickType.MINOR) {
                GraphicUtilities.drawLine(g2d, tickX, this.barBottomY_ - 3, tickX, this.barBottomY_ + 3);
                continue;
            }
            GraphicUtilities.drawLine(g2d, tickX, this.barBottomY_ - 3, tickX, this.barBottomY_);
        }
    }

    private void drawOutliers(Graphics2D g2d) {
        g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
        if (PanScaleOutlier.RECTANGLE.matches(this.pmeta_.getString("plot:scale.outlier"))) {
            g2d.setColor(this.colortable_.getMinOutlierColor(this.inverted_));
            GraphicUtilities.fillRect(g2d, this.barLeft_ - (float)this.outlierGap_ - (float)this.outlierWidth_, this.barTopY_, this.outlierWidth_, this.barHeight_);
            g2d.setColor(this.getForeground());
            GraphicUtilities.drawRect(g2d, this.barLeft_ - (float)this.outlierGap_ - (float)this.outlierWidth_, this.barTopY_, this.outlierWidth_, this.barHeight_);
            g2d.setColor(this.colortable_.getMaxOutlierColor(this.inverted_));
            GraphicUtilities.fillRect(g2d, this.barRight_ + (float)this.outlierGap_, this.barTopY_, this.outlierWidth_, this.barHeight_);
            g2d.setColor(this.getForeground());
            GraphicUtilities.drawRect(g2d, this.barRight_ + (float)this.outlierGap_, this.barTopY_, this.outlierWidth_, this.barHeight_);
        } else if (PanScaleOutlier.TRIANGLE.matches(this.pmeta_.getString("plot:scale.outlier"))) {
            GeneralPath p1 = new GeneralPath();
            p1.moveTo(this.barLeft_ - (float)this.outlierGap_, this.barTopY_);
            p1.lineTo(this.barLeft_ - (float)this.outlierGap_, this.barTopY_ + this.barHeight_);
            p1.lineTo(this.barLeft_ - (float)this.outlierGap_ - (float)(2 * this.outlierWidth_), this.barTopY_ + this.barHeight_ / 2);
            p1.lineTo(this.barLeft_ - (float)this.outlierGap_, this.barTopY_);
            p1.closePath();
            g2d.setColor(this.colortable_.getMinOutlierColor(this.inverted_));
            g2d.fill(p1);
            g2d.setColor(this.getForeground());
            g2d.draw(p1);
            GeneralPath p2 = new GeneralPath();
            p2.moveTo(this.barRight_ + (float)this.outlierGap_, this.barTopY_);
            p2.lineTo(this.barRight_ + (float)this.outlierGap_, this.barTopY_ + this.barHeight_);
            p2.lineTo(this.barRight_ + (float)this.outlierGap_ + (float)(2 * this.outlierWidth_), this.barTopY_ + this.barHeight_ / 2);
            p2.lineTo(this.barRight_ + (float)this.outlierGap_, this.barTopY_);
            p2.closePath();
            g2d.setColor(this.colortable_.getMaxOutlierColor(this.inverted_));
            g2d.fill(p2);
            g2d.setColor(this.getForeground());
            g2d.draw(p2);
        }
    }

    private void drawScaleVector(Graphics2D g2d) {
        if (this.vectorWeight_ == 0 || this.vectorStyle_ == PanVectorStyle.NONE) {
            return;
        }
        double maxMag = this.pmeta_.getDouble("plot:vector.value");
        if (!(maxMag > 0.0)) {
            return;
        }
        g2d.setColor(this.getForeground());
        float vx = this.barRight_ + (float)this.outlierGap_ + 2.0f * (float)this.outlierWidth_ + 3.0f * (float)this.outlierGap_;
        int vy = this.barBottomY_ - 4;
        int vlength = this.pmeta_.getInt("plot:vector.length");
        String vtext = this.formatter_.sprintf(maxMag);
        FontMetrics fm = g2d.getFontMetrics();
        int twidth = fm.stringWidth(vtext);
        int dt = Math.max(0, (vlength - twidth) / 2);
        GraphicUtilities.drawString(g2d, vtext, vx + (float)dt, (float)this.ticksY_);
        vx += (float)Math.max(0, (twidth - vlength) / 2);
        g2d.setStroke(this.vectorStroke_);
        if (this.vectorStyle_ == PanVectorStyle.UPDOT) {
            double radius = 2.0;
            Ellipse2D.Double dot = new Ellipse2D.Double((double)vx - 2.0, (double)vy - 2.0, 4.0, 4.0);
            g2d.fill(dot);
            GeneralPath line = new GeneralPath();
            line.moveTo(vx, vy);
            line.lineTo(vx + (float)vlength, vy);
            g2d.draw(line);
        } else {
            int hlength = vlength / 4;
            float hlengthX = (float)((double)hlength * COS45);
            GeneralPath arrow = new GeneralPath();
            arrow.moveTo(vx, vy);
            arrow.lineTo(vx + (float)vlength, vy);
            arrow.moveTo(vx + (float)vlength - hlengthX, (float)vy - hlengthX);
            arrow.lineTo(vx + (float)vlength, vy);
            arrow.lineTo(vx + (float)vlength - hlengthX, (float)vy + hlengthX);
            g2d.draw(arrow);
        }
    }

    public String getCaption() {
        if (this.useDefaultCaption_) {
            return this.data_.getDescription();
        }
        return this.userCaption_;
    }

    public PrintfFormat getFormatter() {
        return this.formatter_;
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.localParameterChanged(pname);
    }

    private void localParameterChanged(String pname) {
        Object o;
        String s;
        boolean changeAll;
        boolean bl = changeAll = pname == null || pname.equals("all");
        if (changeAll || pname.contains("plot:colors.background")) {
            this.setBackground(this.pmeta_.getColor("plot:colors.background"));
        }
        if (changeAll || pname.contains("plot:scale.caption.default")) {
            this.useDefaultCaption_ = this.pmeta_.getBoolean("plot:scale.caption.default");
        }
        if (changeAll || pname.contains("plot:scale.caption.usertext")) {
            this.userCaption_ = this.pmeta_.getString("plot:scale.caption.usertext");
        }
        if (changeAll || pname.contains("plot:scale.caption.location")) {
            s = this.pmeta_.getString("plot:scale.caption.location");
            this.captionAbove_ = PanScaleCaptionLocation.ABOVE.matches(s);
            this.needsResize_ = true;
        }
        if ((changeAll || pname.contains("plot:colorbar.name")) && (o = this.pmeta_.get("plot:colorbar.name")) != null && o instanceof AbstractColorTable) {
            this.colortable_ = (AbstractColorTable)o;
        }
        if (changeAll || pname.contains("plot:colorbar.invert")) {
            this.inverted_ = this.pmeta_.getBoolean("plot:colorbar.invert");
        }
        if (changeAll || pname.contains("plot:scale.tick.format")) {
            s = this.pmeta_.getString("plot:scale.tick.format");
            if (s == null) {
                throw new IllegalArgumentException("Null format string");
            }
            this.formatString_ = s;
            this.formatter_ = new PrintfFormat(this.formatString_);
        }
        if (changeAll || pname.contains("plot:font.master") || pname.contains("plot:scale.tick.size")) {
            this.needsResize_ = true;
        }
        if (changeAll || pname.contains("plot:combination") || pname.contains("plot:vector.color") || pname.contains("plot:vector.weight") || pname.contains("plot:vector.style")) {
            boolean vectorsEnabled;
            PanCombinationType ctype = (PanCombinationType)this.pmeta_.get("plot:combination");
            boolean bl2 = vectorsEnabled = ctype != null && ctype == PanCombinationType.VECTOR_A1_A2;
            if (vectorsEnabled) {
                String vs = this.pmeta_.getString("plot:vector.style").toLowerCase();
                if (PanVectorStyle.ARROW.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.ARROW;
                    this.vectorWeight_ = PanUtilities.minmax100(this.pmeta_.getInt("plot:vector.weight"));
                } else if (PanVectorStyle.UPDOT.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.UPDOT;
                    this.vectorWeight_ = PanUtilities.minmax100(this.pmeta_.getInt("plot:vector.weight"));
                } else {
                    this.vectorStyle_ = PanVectorStyle.NONE;
                    this.vectorWeight_ = 0;
                }
            } else {
                this.vectorWeight_ = 0;
            }
            if (this.vectorWeight_ > 0) {
                this.vectorColor_ = this.pmeta_.getColor("plot:vector.color");
                this.vectorStroke_ = PanGraphicUtilities.buttMiterStroke(this.vectorWeight_);
            } else {
                this.vectorColor_ = null;
                this.vectorStroke_ = null;
            }
        }
    }
}

