/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.plot.PlotPieceMargins;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class PanPlotNote
extends PanPlotPiece {
    private String text_;
    private HAlignment hAlignment_ = HAlignment.LEFT;
    private VAlignment vAlignment_ = VAlignment.MIDDLE;

    public PanPlotNote(PanPlotMeta pmeta) {
        this(pmeta, "", HAlignment.CENTER);
    }

    public PanPlotNote(PanPlotMeta pmeta, String text) {
        this(pmeta, text, HAlignment.CENTER);
    }

    public PanPlotNote(PanPlotMeta pmeta, String text, HAlignment hAlignment) {
        super(pmeta);
        this.setText(text);
        this.setHorizontalAlignment(hAlignment);
        this.setVerticalAlignment(VAlignment.TOP);
        this.setOpaque(true);
        String fn = this.pmeta_.getString("plot:font.master");
        try {
            this.setFont(new Font(fn, 0, 12));
        }
        catch (Exception exc) {
            this.setFont(new Font("SansSerif", 0, 12));
        }
        this.localParameterChanged("all");
    }

    public String getText() {
        return this.text_;
    }

    public void setText(String text) {
        this.text_ = text;
    }

    public HAlignment getHorizontalAlignment() {
        return this.hAlignment_;
    }

    public void setHorizontalAlignment(HAlignment alignment) {
        this.hAlignment_ = alignment;
    }

    public VAlignment getVerticalAlignment() {
        return this.vAlignment_;
    }

    public void setVerticalAlignment(VAlignment alignment) {
        this.vAlignment_ = alignment;
    }

    public void setFontSize(float fh) {
        this.setFont(this.getFont().deriveFont(fh));
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        Graphics2D g2d = (Graphics2D)gx.create();
        GraphicUtilities.antialias(g2d);
        PlotPieceMargins margins = this.getMargins();
        int width = this.getWidth();
        int height = this.getHeight();
        g2d.setFont(this.getFont());
        g2d.setColor(this.getForeground());
        FontMetrics fm = g2d.getFontMetrics(this.getFont());
        int y = this.vAlignment_ == VAlignment.MIDDLE ? (height - fm.getHeight()) / 2 : (this.vAlignment_ == VAlignment.BOTTOM ? height - margins.bottom : margins.top + fm.getAscent());
        int twidth = fm.stringWidth(this.getText());
        int x = this.hAlignment_ == HAlignment.CENTER ? (width - twidth) / 2 : (this.hAlignment_ == HAlignment.RIGHT ? width - margins.right - twidth : margins.left);
        GraphicUtilities.drawString(g2d, this.getText(), x, y);
        g2d.dispose();
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.localParameterChanged(pname);
    }

    private void localParameterChanged(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || pname.equals("all");
        if (changeAll || pname.contains("plot:colors.background")) {
            this.setBackground(this.pmeta_.getColor("plot:colors.background"));
        }
        if (changeAll || pname.contains("plot:font.master")) {
            String fn = this.pmeta_.getString("plot:font.master");
            Font f = this.getFont();
            float fHeight = f.getSize2D();
            try {
                this.setFont(new Font(fn, 0, 8).deriveFont(fHeight));
            }
            catch (Exception exc) {
                this.setFont(new Font("SansSerif", 0, 8).deriveFont(fHeight));
            }
        }
    }

    public static enum VAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

    }

    public static enum HAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

