/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.ColorUtilities;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.map.overlay.AbstractOverlay;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcDimension;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanColorTableList;
import gov.nasa.giss.panoply.PanOverlayList;
import gov.nasa.giss.panoply.PanParameterNames;
import gov.nasa.giss.panoply.PanPlotType;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import java.awt.Color;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotMetaCL
extends PanPlotMeta
implements PanParameterNames {
    private static Logger logger_ = LoggerFactory.getLogger(PanPlotMetaCL.class);

    public PanPlotMetaCL(PanPlotType ptype) {
        super(ptype);
    }

    public PanPlotMetaCL(PanPlotType ptype, int sizeFactor) {
        super(ptype, sizeFactor);
    }

    public PanPlotMetaCL(PanPlotType ptype, int sizeFactor, NcVariable ncvar) {
        super(ptype, sizeFactor, ncvar);
    }

    public void writeDimsCL() {
        for (int i = 0; i < 2; ++i) {
            NcArray nca = this.data_.getArray(i);
            if (nca == null) continue;
            NcDimension[] freeDims = nca.getFreeDimensions();
            for (int j = 0; j < freeDims.length; ++j) {
                if (freeDims[j] == null) {
                    System.out.printf("Array %d : Dim %d : PLOT AXIS%n", i + 1, j + 1);
                    System.out.println();
                    continue;
                }
                System.out.printf("Array %d : Dim %d : Offset %d of %d : %s%n", i + 1, j + 1, nca.getSliceIndex(j) + 1, freeDims[j].getLength(), freeDims[j].getLongName());
            }
        }
    }

    public void writeSettingCL(String skey) {
        String pkey = "plot:" + skey;
        if (!this.containsKey(pkey)) {
            System.err.printf("ERROR: '%s' not a known key%n", skey);
        }
        Object pvalue = this.get(pkey);
        String svalue = null;
        svalue = pvalue == null ? "<null>" : (pvalue instanceof String ? "'" + pvalue + "'" : (pvalue instanceof Color ? ColorUtilities.colorToString((Color)pvalue) : pvalue.toString()));
        System.out.printf("key: %s, value: %s", skey, svalue);
        if (pvalue != null) {
            System.out.printf(", %s", pvalue.getClass());
        }
        System.out.println();
    }

    public void writeSettingsCL() {
        for (String pkey : this.keySet()) {
            String skey = pkey.substring(5);
            if (skey.startsWith("bounds.") || skey.equals("combination") || skey.equals("size.grid") || skey.equals("size.pixels") || pkey.startsWith("plot:font.height") || pkey.startsWith("plot:size.pixels") || pkey.startsWith("plot:type")) continue;
            this.writeSettingCL(skey);
        }
    }

    public boolean setCL(String key, String svalue) {
        if (key == null) {
            logger_.warn("Null key");
            return false;
        }
        String pkey = null;
        String skey = null;
        if (key.startsWith("plot:")) {
            pkey = key.replaceAll("\\-", ".");
            skey = pkey.replaceAll("plot:", "");
        } else {
            skey = key.replaceAll("\\-", ".");
            pkey = "plot:" + skey;
        }
        if (!this.containsKey(pkey)) {
            logger_.warn("{} is not a known key for this plot type", (Object)pkey);
            return false;
        }
        Object ovalue = this.get(pkey);
        if (pkey.equals("plot:lonlat.map.param.0") || pkey.equals("plot:lonlat.map.param.1") || pkey.equals("plot:lonlat.map.param.2") || pkey.equals("plot:lonlat.map.param.3") || pkey.equals("plot:lonlat.map.param.4")) {
            if (this.plot_ != null) {
                return this.handleProjectionParam(pkey, svalue);
            }
        } else if (ovalue != null) {
            if (ovalue instanceof String) {
                if ((svalue = StringUtils.strip(svalue)).startsWith("\"") && svalue.endsWith("\"") || svalue.startsWith("'") && svalue.endsWith("'")) {
                    svalue = StringUtils.stripStart(svalue, "\"'");
                    svalue = StringUtils.stripEnd(svalue, "\"'");
                }
                this.setString(pkey, svalue);
                return true;
            }
            if (ovalue instanceof Boolean) {
                try {
                    this.setBoolean(pkey, svalue);
                    return true;
                }
                catch (Exception exc) {
                    logger_.warn("Cannot convert '{}' to a boolean value", (Object)svalue);
                    return false;
                }
            }
            if (ovalue instanceof Color) {
                try {
                    this.setColor(pkey, svalue);
                    return true;
                }
                catch (Exception exc) {
                    logger_.warn("Cannot convert '{}' to a color value", (Object)svalue);
                    return false;
                }
            }
            if (ovalue instanceof Double) {
                try {
                    this.setDouble(pkey, svalue);
                    return true;
                }
                catch (Exception exc) {
                    logger_.warn("Cannot convert '{}' to a double value", (Object)svalue);
                    return false;
                }
            }
            if (ovalue instanceof Integer) {
                try {
                    this.setInt(pkey, svalue);
                    return true;
                }
                catch (Exception exc) {
                    logger_.warn("Cannot convert '{}' to an integer value", (Object)svalue);
                    return false;
                }
            }
            if (ovalue instanceof AbstractColorTable) {
                Object ct = PanColorTableList.getList().findByName(svalue);
                if (ct == null) {
                    logger_.warn("No color table matching '{}", (Object)svalue);
                    return false;
                }
                this.set(pkey, ct);
                return true;
            }
            if (ovalue instanceof AbstractOverlay) {
                Object olay = PanOverlayList.getList().findByName(svalue);
                if (olay == null) {
                    logger_.warn("No color table matching '{}", (Object)svalue);
                    return false;
                }
                this.set(pkey, olay);
                return true;
            }
            logger_.warn("Cannot convert setting for {} to a {}", (Object)skey, (Object)ovalue.getClass());
            return false;
        }
        return false;
    }
}

