/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.gui.task.Task;
import gov.nasa.giss.gui.task.TaskListener;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.netcdf.NcArray;
import gov.nasa.giss.netcdf.NcArray2D;
import gov.nasa.giss.netcdf.NcVariable;
import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.PanAbstractData2D;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanControlsTabbedPane;
import gov.nasa.giss.panoply.PanLatVertData;
import gov.nasa.giss.panoply.PanLonLatData;
import gov.nasa.giss.panoply.PanLonVertData;
import gov.nasa.giss.panoply.PanNetcdfUtilities;
import gov.nasa.giss.panoply.PanParameterNames;
import gov.nasa.giss.panoply.PanPlotFrame;
import gov.nasa.giss.panoply.PanPlotType;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanPreferencesFrame;
import gov.nasa.giss.panoply.PanProjectionPrefs;
import gov.nasa.giss.panoply.PanTimeLatData;
import gov.nasa.giss.panoply.PanXVertData;
import gov.nasa.giss.panoply.plot.PanAbstractPlot;
import gov.nasa.giss.panoply.plot.PanLatVertPlot;
import gov.nasa.giss.panoply.plot.PanLonLatPlot;
import gov.nasa.giss.panoply.plot.PanLonVertPlot;
import gov.nasa.giss.panoply.plot.PanPlotHolder;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.panoply.plot.PanTimeLatPlot;
import gov.nasa.giss.plot.PlotPropertyMap;
import gov.nasa.giss.text.TextUtilities;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotMeta
extends PlotPropertyMap
implements PanParameterNames {
    private static Logger logger_ = LoggerFactory.getLogger(PanPlotMeta.class);
    private static final boolean NO_TASKS = true;
    private static final int GWIDTH100 = 720;
    private static final int GHEIGHT100 = 360;
    private static final int MARGIN100 = 6;
    private static final int GAP100 = 6;
    protected static final PanPreferences PREFS = PanPreferences.getPrefs();
    protected PanPlotType plotType_;
    protected PanAbstractData data_;
    protected PanAbstractPlot plot_;
    protected PanPlotFrame pframe_;
    protected Rectangle titleBounds_;
    protected Rectangle subtitleBounds_;
    protected Rectangle graphicBounds_;
    protected Rectangle scaleBounds_;
    protected Rectangle noteBounds_;
    protected Rectangle noteBoundsLeft_;
    protected Rectangle noteBoundsCenter_;
    protected Rectangle noteBoundsRight_;
    protected int vgap_;
    private PanPlotMeta self_;
    private PanProjectionMeta projmeta_;

    public PanPlotMeta(PanPlotType ptype) {
        this(ptype, PREFS.getInt("plot:size.factor"));
    }

    public PanPlotMeta(PanPlotType ptype, int sizeFactor) {
        if (sizeFactor < 70) {
            logger_.warn("Size factor too small. Using default.");
            sizeFactor = 120;
        }
        this.plotType_ = ptype;
        this.initDescription(sizeFactor);
    }

    public PanPlotMeta(PanPlotType ptype, int sizeFactor, NcVariable ncvar) {
        this(ptype, sizeFactor);
        this.createData(ncvar);
    }

    public PanPlotType getType() {
        return this.plotType_;
    }

    public PanAbstractData getData() {
        return this.data_;
    }

    public PanAbstractPlot getPlot() {
        return this.plot_;
    }

    public PanProjectionMeta getProjectionMeta() {
        return this.projmeta_;
    }

    public PanPlotFrame getFrame() {
        return this.pframe_;
    }

    public void setFrame(PanPlotFrame pf) {
        this.pframe_ = pf;
    }

    protected void initDescription(int sizeFactor) {
        this.set("plot:type", (Object)this.plotType_);
        this.set("plot:combination", PanCombinationType.A1_ONLY);
        this.setColor("plot:colors.background", PREFS.getColor("plot:colors.background"));
        this.setColor("plot:colors.invalids", PREFS.getColor("plot:colors.invalids"));
        this.set("plot:colorbar.name", PREFS.get("plot:colorbar.name"));
        this.setBoolean("plot:colorbar.invert", PREFS.getBoolean("plot:colorbar.invert"));
        this.setBoolean("plot:scale.interpolate", PREFS.getBoolean("plot:scale.interpolate"));
        this.setBoolean("plot:scale.autofit", PREFS.getBoolean("plot:scale.autofit"));
        this.setString("plot:scale.units", "XXX");
        this.setBoolean("plot:scale.log10", PREFS.getBoolean("plot:scale.log10"));
        this.setString("plot:scale.tick.format", PREFS.getString("plot:scale.tick.format"));
        this.setInt("plot:scale.majordiv", PREFS.getInt("plot:scale.majordiv"));
        this.setInt("plot:scale.minordiv", PREFS.getInt("plot:scale.minordiv"));
        this.setInt("plot:scale.tick.size", PREFS.getInt("plot:scale.tick.size"));
        this.setString("plot:scale.outlier", PREFS.getString("plot:scale.outlier"));
        this.setString("plot:scale.caption.location", PREFS.getString("plot:scale.caption.location"));
        this.setBoolean("plot:scale.minmaxnote", PREFS.getBoolean("plot:scale.minmaxnote"));
        this.setString("plot:contour.style", PREFS.getString("plot:contour.style"));
        this.setColor("plot:contour.color", PREFS.getColor("plot:contour.color"));
        this.setInt("plot:contour.weight", PREFS.getInt("plot:contour.weight"));
        this.setBoolean("plot:contour.labels", PREFS.getBoolean("plot:contour.labels"));
        this.setString("plot:contour.location", PREFS.getString("plot:contour.location"));
        this.setString("plot:vector.style", PREFS.getString("plot:vector.style"));
        this.setColor("plot:vector.color", PREFS.getColor("plot:vector.color"));
        this.setInt("plot:vector.weight", PREFS.getInt("plot:vector.weight"));
        this.setInt("plot:vector.spacing", PREFS.getInt("plot:vector.spacing"));
        this.setString("plot:font.master", PREFS.getString("plot:font.master"));
        if (this.plotType_ == PanPlotType.LON_LAT) {
            String pname = PREFS.getString("plot:lonlat.map.projection");
            this.projmeta_ = new PanProjectionMeta(this);
            this.projmeta_.setProjection(pname);
            this.setString("plot:lonlat.type", PREFS.getString("plot:lonlat.type"));
            this.setString("plot:lonlat.map.projection", pname);
            this.setDouble("plot:lonlat.map.center.lon", PREFS.getDouble("plot:lonlat.map.center.lon"));
            this.setDouble("plot:lonlat.map.center.lat", PREFS.getDouble("plot:lonlat.map.center.lat"));
            for (int i = 0; i < 5; ++i) {
                String s = this.projmeta_.getExtraParameter(i);
                if (s == null) continue;
                String k = "plot:lonlat.map.param." + i;
                this.set(k, s);
            }
            this.setBoolean("plot:lonlat.map.projnote", PREFS.getBoolean("plot:lonlat.map.projnote"));
            this.setDouble("plot:lonlat.map.grid.spacing", PREFS.getDouble("plot:lonlat.map.grid.spacing"));
            this.setColor("plot:lonlat.map.grid.color", PREFS.getColor("plot:lonlat.map.grid.color"));
            this.setInt("plot:lonlat.map.grid.weight", PREFS.getInt("plot:lonlat.map.grid.weight"));
            this.setString("plot:lonlat.map.grid.style", PREFS.getString("plot:lonlat.map.grid.style"));
            this.setBoolean("plot:lonlat.map.grid.label", false);
            this.set("plot:lonlat.map.overlay", PREFS.get("plot:lonlat.map.overlay"));
            this.setColor("plot:lonlat.map.overlay.color", PREFS.getColor("plot:lonlat.map.overlay.color"));
            this.setBoolean("plot:lonlat.map.overlay.invert", PREFS.getBoolean("plot:lonlat.map.overlay.invert"));
            this.setInt("plot:lonlat.map.overlay.weight", PREFS.getInt("plot:lonlat.map.overlay.weight"));
            this.setBoolean("plot:lonlat.zonal.lataxis.flipped", PREFS.getBoolean("plot:lonlat.zonal.lataxis.flipped"));
            this.setColor("plot:lonlat.zonal.stroke.color", PREFS.getColor("plot:lonlat.zonal.stroke.color"));
            this.setColor("plot:lonlat.zonal.grid.color", PREFS.getColor("plot:lonlat.zonal.grid.color"));
            this.setInt("plot:lonlat.zonal.grid.weight", PREFS.getInt("plot:lonlat.zonal.grid.weight"));
            this.setDouble("plot:lonlat.zonal.lataxis.max", PREFS.getDouble("plot:lonlat.zonal.lataxis.max"));
            this.setDouble("plot:lonlat.zonal.lataxis.min", PREFS.getDouble("plot:lonlat.zonal.lataxis.min"));
            this.setString("plot:lonlat.map.vector.direction1", "East");
            this.setString("plot:lonlat.map.vector.direction2", "North");
        } else if (this.plotType_ == PanPlotType.LAT_VERT) {
            this.setColor("plot:grid.color", PREFS.getColor("plot:latvert.grid.color"));
            this.setInt("plot:grid.weight", PREFS.getInt("plot:latvert.grid.weight"));
            this.setInt("plot:xaxis.majordiv", 6);
            this.setInt("plot:xaxis.minordiv", 2);
            this.setString("plot:xaxis.label.usertext", "Latitude (\u00b0N)");
            this.setDouble("plot:xaxis.min", PREFS.getDouble("plot:latvert.lataxis.min"));
            this.setDouble("plot:xaxis.max", PREFS.getDouble("plot:latvert.lataxis.max"));
            this.setInt("plot:yaxis.majordiv", 1);
            this.setInt("plot:yaxis.minordiv", 1);
            this.setDouble("plot:yaxis.min", Double.NaN);
            this.setDouble("plot:yaxis.max", Double.NaN);
            this.setBoolean("plot:yaxis.label.default", true);
            this.setString("plot:yaxis.label.usertext", "VERTICAL AXIS CAPTION");
            this.setString("plot:yaxis.pattern", PREFS.getString("plot:latvert.vaxis.format"));
            this.setString("plot:yaxis.units", PREFS.getString("plot:latvert.vaxis.units"));
            this.setBoolean("plot:yaxis.inverted", PREFS.getBoolean("plot:latvert.vaxis.flipped"));
            this.setBoolean("plot:latvert.lataxis.flipped", PREFS.getBoolean("plot:latvert.lataxis.flipped"));
            this.setString("plot:latvert.vector.direction1", "North");
            this.setString("plot:latvert.vector.direction2", "Up");
        } else if (this.plotType_ == PanPlotType.LON_VERT) {
            this.setColor("plot:grid.color", PREFS.getColor("plot:lonvert.grid.color"));
            this.setInt("plot:grid.weight", PREFS.getInt("plot:lonvert.grid.weight"));
            this.setInt("plot:xaxis.majordiv", 6);
            this.setInt("plot:xaxis.minordiv", 2);
            this.setString("plot:xaxis.label.usertext", "Longitude (\u00b0E)");
            this.setDouble("plot:xaxis.min", PREFS.getDouble("plot:lonvert.lonaxis.min"));
            this.setDouble("plot:xaxis.max", PREFS.getDouble("plot:lonvert.lonaxis.max"));
            this.setInt("plot:yaxis.majordiv", 1);
            this.setInt("plot:yaxis.minordiv", 1);
            this.setDouble("plot:yaxis.min", Double.NaN);
            this.setDouble("plot:yaxis.max", Double.NaN);
            this.setBoolean("plot:yaxis.label.default", true);
            this.setString("plot:yaxis.label.usertext", "VERTICAL AXIS CAPTION");
            this.setString("plot:yaxis.pattern", PREFS.getString("plot:lonvert.vaxis.format"));
            this.setString("plot:yaxis.units", PREFS.getString("plot:lonvert.vaxis.units"));
            this.setBoolean("plot:yaxis.inverted", PREFS.getBoolean("plot:lonvert.vaxis.flipped"));
            this.setString("plot:lonvert.vector.direction1", "East");
            this.setString("plot:lonvert.vector.direction2", "Up");
        } else if (this.plotType_ == PanPlotType.TIME_LAT) {
            this.setColor("plot:grid.color", PREFS.getColor("plot:timelat.grid.color"));
            this.setInt("plot:grid.weight", PREFS.getInt("plot:timelat.grid.weight"));
            this.setInt("plot:xaxis.majordiv", PREFS.getInt("plot:timelat.taxis.majordiv"));
            this.setInt("plot:xaxis.minordiv", PREFS.getInt("plot:timelat.taxis.minordiv"));
            this.setString("plot:xaxis.pattern", "");
            this.setBoolean("plot:xaxis.label.default", true);
            this.setString("plot:xaxis.label.usertext", "TIME AXIS CAPTION");
            this.setInt("plot:yaxis.majordiv", 6);
            this.setInt("plot:yaxis.minordiv", 2);
            this.setDouble("plot:yaxis.min", PREFS.getDouble("plot:timelat.lataxis.min"));
            this.setDouble("plot:yaxis.max", PREFS.getDouble("plot:timelat.lataxis.max"));
            this.setString("plot:yaxis.label.usertext", "Latitude (\u00b0N)");
        }
        this.setString("plot:caption.title", "PLOT TITLE");
        this.setString("plot:caption.subtitle", "");
        this.setBoolean("plot:scale.caption.default", true);
        this.setString("plot:scale.caption.usertext", "SCALE CAPTION");
        this.setInt("plot:scale.scaling.exponent", 0);
        this.setDouble("plot:scale.minimum", 0.0);
        this.setDouble("plot:scale.maximum", 1.0);
        this.setDouble("plot:vector.value", 1.0);
        this.setInt("plot:size.factor", sizeFactor);
    }

    public int getSizeFactor() {
        return this.getInt("plot:size.factor");
    }

    public void setSizeFactor(int sf) {
        this.setInt("plot:size.factor", sf);
    }

    protected void updateLayout(int sizeFactor) {
        int hplot;
        int wplot;
        float scaling = 0.01f * (float)sizeFactor;
        float titleFHeight = 16.0f * scaling;
        float subtitleFHeight = 12.0f * scaling;
        float notesFHeight = 8.0f * scaling;
        float axesFHeight = 11.0f * scaling;
        float gridFHeight = 6.5f * scaling;
        float contourFHeight = 6.5f * scaling;
        int wcore = (int)(720.0f * scaling);
        int hcore = (int)(360.0f * scaling);
        if (this.plotType_ == PanPlotType.LON_LAT) {
            wplot = wcore;
            hplot = hcore;
        } else if (this.plotType_ == PanPlotType.TIME_LAT) {
            wplot = wcore * 9 / 10;
            hplot = (int)((float)(hcore - 12) - 2.0f * axesFHeight) - 6;
        } else if (this.plotType_ == PanPlotType.LAT_VERT || this.plotType_ == PanPlotType.LON_VERT) {
            wplot = wcore * 4 / 5;
            hplot = (int)((float)(hcore - 12) - 2.0f * axesFHeight) - 6;
        } else {
            wplot = wcore;
            hplot = hcore;
        }
        if (wplot % 2 > 0) {
            ++wplot;
        }
        if (hplot % 2 > 0) {
            ++hplot;
        }
        int mw = Math.max((int)(4.0 * (double)scaling), (wcore - wplot) / 2);
        int mh = Math.max((int)(4.0 * (double)scaling), (hcore - hplot) / 2);
        int wplotx = wplot + 2 * mw;
        int margin = (int)(6.0f * scaling);
        int wtotal = wplotx + margin;
        wtotal = wtotal / 16 * 16 + (wtotal % 16 > 0 ? 16 : 0);
        this.vgap_ = (int)(6.0f * scaling);
        this.titleBounds_ = new Rectangle();
        this.subtitleBounds_ = new Rectangle();
        this.graphicBounds_ = new Rectangle();
        this.scaleBounds_ = new Rectangle();
        this.noteBounds_ = new Rectangle();
        int y = margin;
        this.titleBounds_.x = (wtotal - wplotx) / 2;
        this.titleBounds_.y = y;
        this.titleBounds_.width = wplotx;
        this.titleBounds_.height = (int)(1.25 * (double)titleFHeight);
        y += this.titleBounds_.height;
        this.subtitleBounds_.x = (wtotal - wplotx) / 2;
        this.subtitleBounds_.y = y += this.vgap_;
        this.subtitleBounds_.width = wplotx;
        this.subtitleBounds_.height = (int)(1.25 * (double)subtitleFHeight);
        this.graphicBounds_.x = (wtotal - wplotx) / 2;
        this.graphicBounds_.y = y += this.subtitleBounds_.height;
        this.graphicBounds_.width = wplotx;
        this.graphicBounds_.height = hplot + 2 * mh;
        this.scaleBounds_.x = (wtotal - wplotx) / 2;
        this.scaleBounds_.y = y += this.graphicBounds_.height;
        this.scaleBounds_.width = wplotx;
        this.scaleBounds_.height = (int)Math.max(40.0, 48.0 * (double)scaling);
        y += this.scaleBounds_.height;
        this.noteBounds_.x = (wtotal - wplotx) / 2;
        this.noteBounds_.y = y += this.vgap_;
        this.noteBounds_.width = wplotx / 2;
        this.noteBounds_.height = (int)(1.25 * (double)notesFHeight);
        y += this.noteBounds_.height;
        y += margin;
        this.noteBoundsLeft_ = (Rectangle)this.noteBounds_.clone();
        this.noteBoundsCenter_ = (Rectangle)this.noteBounds_.clone();
        this.noteBoundsRight_ = (Rectangle)this.noteBounds_.clone();
        this.noteBoundsLeft_.width = wplotx / 2;
        this.noteBoundsCenter_.width = wplotx / 2;
        this.noteBoundsRight_.width = wplotx / 2;
        this.noteBoundsLeft_.x = margin;
        this.noteBoundsCenter_.x = margin + wplotx / 4;
        this.noteBoundsRight_.x = margin + wplotx / 2;
        int htotal = y / 16 * 16 + (y % 16 > 0 ? 16 : 0);
        int vlength = (int)(20.0 * (double)scaling);
        Dimension psize = new Dimension(wtotal, htotal);
        Dimension gsize = new Dimension(wplot, hplot);
        this.setGroup(new String[]{"plot:size.pixels", "plot:size.grid", "plot:bounds.graphic", "plot:bounds.title", "plot:bounds.subtitle", "plot:bounds.scale", "plot:bounds.note.left", "plot:bounds.note.center", "plot:bounds.note.right", "plot:font.height.title", "plot:font.height.subtitle", "plot:font.height.notes", "plot:font.height.axes", "plot:font.height.grid", "plot:font.height.contour", "plot:vector.length"}, new Object[]{psize, gsize, this.graphicBounds_, this.titleBounds_, this.subtitleBounds_, this.scaleBounds_, this.noteBoundsLeft_, this.noteBoundsCenter_, this.noteBoundsRight_, Float.valueOf(titleFHeight), Float.valueOf(subtitleFHeight), Float.valueOf(notesFHeight), Float.valueOf(axesFHeight), Float.valueOf(gridFHeight), Float.valueOf(contourFHeight), vlength});
        if (this.data_ != null) {
            ((PanAbstractData2D)this.data_).setSize(wplot, hplot);
        }
        if (this.plot_ != null) {
            this.plot_.setSize(psize);
        }
        this.firePropertyChanged("all");
    }

    public PanAbstractData createData(NcVariable ncvar) {
        if (this.data_ != null) {
            throw new IllegalArgumentException("Plot data object already exists.");
        }
        Dimension dsize = this.getDimension("plot:size.grid");
        NcArray ncarray = PanNetcdfUtilities.createArray(this.plotType_, ncvar, null);
        if (ncarray == null) {
            throw new RuntimeException("Got null array from variable.");
        }
        try {
            switch (this.plotType_) {
                case LON_LAT: {
                    this.data_ = new PanLonLatData(ncarray, dsize);
                    break;
                }
                case LAT_VERT: {
                    this.data_ = new PanLatVertData((NcArray2D)ncarray, dsize);
                    break;
                }
                case LON_VERT: {
                    this.data_ = new PanLonVertData((NcArray2D)ncarray, dsize);
                    break;
                }
                case TIME_LAT: {
                    this.data_ = new PanTimeLatData((NcArray2D)ncarray, dsize);
                }
            }
        }
        catch (Exception exc) {
            logger_.error("There was an error preparing the data, {}", exc);
            exc.printStackTrace();
            String msg = exc.toString().replaceAll(".*: ", "");
            if (msg.indexOf("EOF") > -1) {
                msg = "End of file exception.";
            }
            throw new RuntimeException(msg);
        }
        return this.data_;
    }

    public PanAbstractPlot createPlot() {
        if (this.data_ == null) {
            throw new RuntimeException("Data object not yet created.");
        }
        switch (this.plotType_) {
            case LON_LAT: {
                this.plot_ = new PanLonLatPlot(this, (PanLonLatData)this.data_);
                break;
            }
            case LAT_VERT: {
                this.plot_ = new PanLatVertPlot(this, (PanLatVertData)this.data_);
                break;
            }
            case LON_VERT: {
                this.plot_ = new PanLonVertPlot(this, (PanLonVertData)this.data_);
                break;
            }
            case TIME_LAT: {
                this.plot_ = new PanTimeLatPlot(this, (PanTimeLatData)this.data_);
            }
        }
        this.plot_.setSize(this.getDimension("plot:size.pixels"));
        this.setString("plot:caption.title", this.data_.getArray(0).getLongName());
        double dmin = this.data_.getMinimumValue();
        double dmax = this.data_.getMaximumValue();
        if (this.getBoolean("plot:scale.log10")) {
            dmin = Math.pow(10.0, dmin);
            dmax = Math.pow(10.0, dmax);
        }
        double dmag = 0.75 * Math.max(1.0, Math.max(Math.abs(dmin), Math.abs(dmax)));
        this.setDouble("plot:scale.minimum", dmin);
        this.setDouble("plot:scale.maximum", dmax);
        this.setDouble("plot:vector.value", dmag);
        if (this.plotType_ == PanPlotType.LAT_VERT || this.plotType_ == PanPlotType.LON_VERT) {
            double max;
            double min = ((PanXVertData)this.data_).getTopBound();
            if (min > (max = ((PanXVertData)this.data_).getBottomBound())) {
                double foo = min;
                min = max;
                max = foo;
            } else if (min == max) {
                max = min + 0.01;
            }
            this.setDouble("plot:yaxis.min", min);
            this.setDouble("plot:yaxis.max", max);
        }
        return this.plot_;
    }

    @Override
    public Object put(final String key, final Object value) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (onEDT) {
            Object o = this.beginPut(key, value);
            this.finishPut();
            return o;
        }
        if (onEDT && this.pframe_ != null) {
            String s = key.replaceAll(".*\\.", "");
            Task task = new Task("Setting parameter " + s){

                @Override
                public Object beginTask() {
                    return PanPlotMeta.this.beginPut(key, value);
                }

                @Override
                public void finishTask() {
                    PanPlotMeta.this.finishPut();
                }
            };
            this.pframe_.addTask(task);
            return null;
        }
        Object o = this.beginPut(key, value);
        this.finishPut();
        return o;
    }

    private Object beginPut(String key, Object value) {
        try {
            if (this.isProjectionNameKey(key) || this.isProjectionParamKey(key)) {
                this.handleProjectionParam(key, value);
            }
            return super.put(key, value);
        }
        catch (Exception exc) {
            return null;
        }
    }

    private void finishPut() {
        if (this.pframe_ == null) {
            return;
        }
        this.refreshPlotControls();
        this.refreshPlot();
    }

    @Override
    public Object setGroup(final String[] keys, final Object[] values) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (onEDT) {
            Object o = this.beginSetGroup(keys, values);
            this.finishSetGroup();
            return o;
        }
        if (onEDT && this.pframe_ != null) {
            Task task = new Task("Setting parameter group"){

                @Override
                public Object beginTask() {
                    return PanPlotMeta.this.beginSetGroup(keys, values);
                }

                @Override
                protected void finishTask() {
                    PanPlotMeta.this.finishSetGroup();
                }
            };
            this.pframe_.addTask(task);
            return null;
        }
        Object o = this.beginSetGroup(keys, values);
        this.finishSetGroup();
        return o;
    }

    private Object beginSetGroup(String[] keys, Object[] values) {
        int i;
        for (i = 0; i < keys.length; ++i) {
            if (!this.isProjectionNameKey(keys[i])) continue;
            this.handleProjectionName((String)values[i]);
        }
        for (i = 0; i < keys.length; ++i) {
            if (!this.isProjectionParamKey(keys[i])) continue;
            this.handleProjectionParam(keys[i], values[i]);
        }
        return super.setGroup(keys, values);
    }

    private void finishSetGroup() {
        if (this.pframe_ == null) {
            return;
        }
        this.refreshPlotControls();
        this.refreshPlot();
    }

    private boolean isProjectionNameKey(String key) {
        return key.equals("plot:lonlat.map.projection");
    }

    private boolean isProjectionParamKey(String key) {
        return key.equals("plot:lonlat.map.center.lon") || key.equals("plot:lonlat.map.center.lat") || key.equals("plot:lonlat.map.param.0") || key.equals("plot:lonlat.map.param.1") || key.equals("plot:lonlat.map.param.2") || key.equals("plot:lonlat.map.param.3") || key.equals("plot:lonlat.map.param.4");
    }

    private void handleProjectionName(String name) {
        if (!(this.plot_ instanceof PanLonLatPlot)) {
            return;
        }
        this.projmeta_.setProjection(name);
        AbstractProjection proj = this.projmeta_.getProjection();
        int pcount = proj.getParameterCount();
        for (int i = 0; i < pcount; ++i) {
            String pkeyx = "plot:lonlat.map.param." + i;
            String value = this.projmeta_.getExtraParameter(i);
            super.set(pkeyx, value);
        }
    }

    protected boolean handleProjectionParam(String pkey, Object value) {
        if (this.isProjectionNameKey(pkey)) {
            this.handleProjectionName((String)value);
        } else if (pkey.equals("plot:lonlat.map.center.lon")) {
            if (value instanceof Double) {
                this.projmeta_.setCenterLon((Double)value);
            } else {
                this.projmeta_.setCenterLon(TextUtilities.parseDouble(value.toString()));
            }
        } else if (pkey.equals("plot:lonlat.map.center.lat")) {
            if (value instanceof Double) {
                this.projmeta_.setCenterLat((Double)value);
            } else {
                this.projmeta_.setCenterLat(TextUtilities.parseDouble(value.toString()));
            }
        } else if (pkey.equals("plot:lonlat.map.param.0") || pkey.equals("plot:lonlat.map.param.1") || pkey.equals("plot:lonlat.map.param.2") || pkey.equals("plot:lonlat.map.param.3") || pkey.equals("plot:lonlat.map.param.4")) {
            int pid = new Integer(pkey.substring(pkey.length() - 1));
            if (value == null) {
                return this.projmeta_.setExtraParameter(pid, null);
            }
            return this.projmeta_.setExtraParameter(pid, value.toString());
        }
        return true;
    }

    @Override
    public void setBoolean(String pkey, boolean pvalue) {
        if (pkey.equals("plot:scale.interpolate")) {
            this.setDataInterpolated(pvalue, null);
        } else {
            super.setBoolean(pkey, pvalue);
        }
    }

    @Override
    public void setInt(String pkey, int pvalue) {
        if (pkey.equals("plot:size.factor")) {
            super.setInt("plot:size.factor", pvalue);
            this.updateLayout(pvalue);
        } else {
            super.setInt(pkey, pvalue);
        }
    }

    @Override
    public void setString(String pkey, String pvalue) {
        if (pkey.equals("plot:scale.units")) {
            this.setDataUnits(pvalue, null);
        } else {
            super.setString(pkey, pvalue);
        }
    }

    private void refreshPlotControls() {
        if (this.pframe_ == null) {
            return;
        }
        final PanControlsTabbedPane pc = this.pframe_.getControls();
        if (pc == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                pc.refresh();
                pc.repaint();
            }
        });
    }

    private void refreshPlot() {
        if (this.pframe_ == null) {
            return;
        }
        final PanPlotHolder ph = this.pframe_.getPlotHolder();
        if (ph == null) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ph.repaint();
            }
        });
    }

    public synchronized void setDataVariable(final int idx, final NcArray nca, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ != null) {
            if (this.pframe_ == null) {
                this.beginSetDataVariable(idx, nca);
                this.finishSetDataVariable(idx);
            } else {
                Task task = new Task("Adding variable"){

                    @Override
                    public Object beginTask() {
                        PanPlotMeta.this.beginSetDataVariable(idx, nca);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        PanPlotMeta.this.finishSetDataVariable(idx);
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
    }

    private void beginSetDataVariable(int idx, NcArray nca) {
        this.data_.addVariable(idx, nca);
    }

    private void finishSetDataVariable(int idx) {
        this.data_.fireDataChanged("variable");
        if (this.pframe_ == null) {
            return;
        }
        this.pframe_.updateArrayDataPanel(idx);
        this.refreshPlotControls();
        this.refreshPlot();
    }

    public synchronized void setDataSlice(final int varnum, final int dimnum, final int index, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ != null) {
            if (this.pframe_ == null) {
                this.beginSetDataSlice(varnum, dimnum, index);
                this.finishSetDataSlice();
            } else {
                Task task = new Task("Changing array slice"){

                    @Override
                    public Object beginTask() {
                        PanPlotMeta.this.beginSetDataSlice(varnum, dimnum, index);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        PanPlotMeta.this.finishSetDataSlice();
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
    }

    private void beginSetDataSlice(int varnum, int dimnum, int index) {
        this.data_.setSlice(varnum, dimnum, index);
    }

    private void finishSetDataSlice() {
        this.data_.fireDataChanged("slice");
        this.refreshPlot();
    }

    public synchronized void setDataCombination(final PanCombinationType ctype, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ != null) {
            if (this.pframe_ == null || onEDT) {
                this.beginSetDataCombination(ctype);
                this.finishSetDataCombination();
            } else {
                Task task = new Task("Changing array combination type"){

                    @Override
                    public Object beginTask() {
                        PanPlotMeta.this.beginSetDataCombination(ctype);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        PanPlotMeta.this.finishSetDataCombination();
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
        super.set("plot:combination", ctype);
    }

    private void beginSetDataCombination(PanCombinationType ctype) {
        this.data_.setCombinationType(ctype);
    }

    private void finishSetDataCombination() {
        this.data_.fireDataChanged("combination");
        this.refreshPlot();
    }

    public synchronized void setDataInterpolated(final boolean interpolated, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ != null) {
            if (this.pframe_ == null || onEDT) {
                this.beginSetDataInterpolated(interpolated);
                this.finishSetDataInterpolated();
            } else {
                Task task = new Task("Toggling interpolation"){

                    @Override
                    public Object beginTask() {
                        PanPlotMeta.this.beginSetDataInterpolated(interpolated);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        PanPlotMeta.this.finishSetDataInterpolated();
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
        super.setBoolean("plot:scale.interpolate", interpolated);
    }

    private void beginSetDataInterpolated(boolean interpolated) {
        this.data_.setInterpolated(interpolated);
    }

    private void finishSetDataInterpolated() {
        this.data_.fireDataChanged("interpolate");
        this.refreshPlot();
    }

    public synchronized void setDataUnits(final String units, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ != null) {
            if (this.pframe_ == null || onEDT) {
                this.beginSetDataUnits(units);
                this.finishSetDataUnits();
            } else {
                Task task = new Task("Setting units"){

                    @Override
                    public Object beginTask() {
                        PanPlotMeta.this.beginSetDataUnits(units);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        PanPlotMeta.this.finishSetDataUnits();
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
        super.setString("plot:scale.units", units);
    }

    private void beginSetDataUnits(String units) {
        this.data_.setUnits(units);
    }

    private void finishSetDataUnits() {
        this.data_.fireDataChanged("units");
        this.refreshPlot();
    }

    public synchronized void setDataExponent(final int tenPower, TaskListener tl) {
        boolean onEDT = EventQueue.isDispatchThread();
        if (this.data_ != null) {
            if (this.pframe_ == null || onEDT) {
                this.beginSetDataExponent(tenPower);
                this.finishSetDataExponent();
            } else {
                Task task = new Task("Setting scaling"){

                    @Override
                    public Object beginTask() {
                        PanPlotMeta.this.beginSetDataExponent(tenPower);
                        return null;
                    }

                    @Override
                    protected void finishTask() {
                        PanPlotMeta.this.finishSetDataExponent();
                    }
                };
                if (tl != null) {
                    task.addTaskListener(tl);
                }
                this.pframe_.addTask(task);
            }
        }
        super.setInt("plot:scale.scaling.exponent", tenPower);
    }

    private void beginSetDataExponent(int tenPower) {
        this.data_.setScalingExponent(tenPower);
    }

    private void finishSetDataExponent() {
        this.data_.fireDataChanged("scaling");
        this.refreshPlot();
    }

    public void copySettingsToPrefs() {
        PREFS.setInt("plot:size.factor", this.getInt("plot:size.factor"));
        PREFS.setColor("plot:colors.background", this.getColor("plot:colors.background"));
        PREFS.setColor("plot:colors.invalids", this.getColor("plot:colors.invalids"));
        PREFS.set("plot:colorbar.name", this.get("plot:colorbar.name"));
        PREFS.setBoolean("plot:colorbar.invert", this.getBoolean("plot:colorbar.invert"));
        PREFS.setBoolean("plot:scale.interpolate", this.getBoolean("plot:scale.interpolate"));
        PREFS.setBoolean("plot:scale.autofit", this.getBoolean("plot:scale.autofit"));
        PREFS.set("plot:scale.tick.format", this.getString("plot:scale.tick.format"));
        PREFS.setInt("plot:scale.majordiv", this.getInt("plot:scale.majordiv"));
        PREFS.setInt("plot:scale.minordiv", this.getInt("plot:scale.minordiv"));
        PREFS.setInt("plot:scale.tick.size", this.getInt("plot:scale.tick.size"));
        PREFS.set("plot:scale.outlier", this.getString("plot:scale.outlier"));
        PREFS.set("plot:scale.caption.location", this.getString("plot:scale.caption.location"));
        PREFS.setBoolean("plot:scale.log10", this.getBoolean("plot:scale.log10"));
        PREFS.setBoolean("plot:scale.minmaxnote", this.getBoolean("plot:scale.minmaxnote"));
        PREFS.set("plot:contour.style", this.getString("plot:contour.style"));
        PREFS.setColor("plot:contour.color", this.getColor("plot:contour.color"));
        PREFS.setInt("plot:contour.weight", this.getInt("plot:contour.weight"));
        PREFS.setBoolean("plot:contour.labels", this.getBoolean("plot:contour.labels"));
        PREFS.set("plot:contour.location", this.getString("plot:contour.location"));
        PREFS.set("plot:vector.style", this.getString("plot:vector.style"));
        PREFS.setColor("plot:vector.color", this.getColor("plot:vector.color"));
        PREFS.setInt("plot:vector.weight", this.getInt("plot:vector.weight"));
        PREFS.setInt("plot:vector.spacing", this.getInt("plot:vector.spacing"));
        PREFS.set("plot:font.master", this.getString("plot:font.master"));
        if (this.plotType_ == PanPlotType.LON_LAT) {
            String pname = this.getString("plot:lonlat.map.projection");
            PREFS.set("plot:lonlat.type", this.getString("plot:lonlat.type"));
            PREFS.set("plot:lonlat.map.projection", pname);
            PREFS.setDouble("plot:lonlat.map.center.lon", this.getDouble("plot:lonlat.map.center.lon"));
            PREFS.setDouble("plot:lonlat.map.center.lat", this.getDouble("plot:lonlat.map.center.lat"));
            for (int i = 0; i < 5; ++i) {
                Object o = this.get("plot:lonlat.map.param." + i);
                if (o == null) continue;
                PanProjectionPrefs.setParam(pname, i, o.toString());
            }
            PREFS.setBoolean("plot:lonlat.map.projnote", this.getBoolean("plot:lonlat.map.projnote"));
            PREFS.setDouble("plot:lonlat.map.grid.spacing", this.getDouble("plot:lonlat.map.grid.spacing"));
            PREFS.setColor("plot:lonlat.map.grid.color", this.getColor("plot:lonlat.map.grid.color"));
            PREFS.setInt("plot:lonlat.map.grid.weight", this.getInt("plot:lonlat.map.grid.weight"));
            PREFS.set("plot:lonlat.map.grid.style", this.getString("plot:lonlat.map.grid.style"));
            PREFS.set("plot:lonlat.map.overlay", this.get("plot:lonlat.map.overlay"));
            PREFS.setColor("plot:lonlat.map.overlay.color", this.getColor("plot:lonlat.map.overlay.color"));
            PREFS.setBoolean("plot:lonlat.map.overlay.invert", this.getBoolean("plot:lonlat.map.overlay.invert"));
            PREFS.setInt("plot:lonlat.map.overlay.weight", this.getInt("plot:lonlat.map.overlay.weight"));
            PREFS.setBoolean("plot:lonlat.zonal.lataxis.flipped", this.getBoolean("plot:lonlat.zonal.lataxis.flipped"));
            PREFS.setColor("plot:lonlat.zonal.stroke.color", this.getColor("plot:lonlat.zonal.stroke.color"));
            PREFS.setColor("plot:lonlat.zonal.grid.color", this.getColor("plot:lonlat.zonal.grid.color"));
            PREFS.setInt("plot:lonlat.zonal.grid.weight", this.getInt("plot:lonlat.zonal.grid.weight"));
            PREFS.setDouble("plot:lonlat.zonal.lataxis.max", this.getDouble("plot:lonlat.zonal.lataxis.max"));
            PREFS.setDouble("plot:lonlat.zonal.lataxis.min", this.getDouble("plot:lonlat.zonal.lataxis.min"));
        } else if (this.plotType_ == PanPlotType.LAT_VERT) {
            PREFS.setColor("plot:latvert.grid.color", this.getColor("plot:grid.color"));
            PREFS.setInt("plot:latvert.grid.weight", this.getInt("plot:grid.weight"));
            PREFS.set("plot:latvert.vaxis.units", this.getString("plot:yaxis.units"));
            PREFS.set("plot:latvert.vaxis.format", this.getString("plot:yaxis.pattern"));
            PREFS.setBoolean("plot:latvert.vaxis.flipped", this.getBoolean("plot:yaxis.inverted"));
            PREFS.setBoolean("plot:latvert.lataxis.flipped", this.getBoolean("plot:latvert.lataxis.flipped"));
        } else if (this.plotType_ == PanPlotType.LON_VERT) {
            PREFS.setColor("plot:lonvert.grid.color", this.getColor("plot:grid.color"));
            PREFS.setInt("plot:lonvert.grid.weight", this.getInt("plot:grid.weight"));
            PREFS.set("plot:lonvert.vaxis.units", this.getString("plot:yaxis.units"));
            PREFS.set("plot:lonvert.vaxis.format", this.getString("plot:yaxis.pattern"));
            PREFS.setBoolean("plot:lonvert.vaxis.flipped", this.getBoolean("plot:yaxis.inverted"));
        } else if (this.plotType_ == PanPlotType.TIME_LAT) {
            PREFS.setColor("plot:timelat.grid.color", this.getColor("plot:grid.color"));
            PREFS.setInt("plot:timelat.grid.weight", this.getInt("plot:grid.weight"));
            PREFS.setInt("plot:timelat.taxis.majordiv", this.getInt("plot:xaxis.majordiv"));
            PREFS.setInt("plot:timelat.taxis.minordiv", this.getInt("plot:xaxis.minordiv"));
            PREFS.setDouble("plot:timelat.lataxis.max", this.getDouble("plot:yaxis.max"));
            PREFS.setDouble("plot:timelat.lataxis.min", this.getDouble("plot:yaxis.min"));
        }
        PanPreferencesFrame pf = PanPreferencesFrame.findFrame(false);
        if (pf != null) {
            pf.refresh();
        }
    }

    public synchronized void flush() {
        this.removePlotPropertyListeners();
        this.data_ = null;
        this.plot_ = null;
        this.pframe_ = null;
    }
}

