/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.gui.cursor.CursorUtilities;
import gov.nasa.giss.panoply.PanGuiConstants;
import gov.nasa.giss.panoply.plot.PanAbstractPlot;
import gov.nasa.giss.plot.PlotHolder;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.EventListener;
import javax.swing.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanPlotHolder
extends PlotHolder {
    private static Logger logger_ = LoggerFactory.getLogger(PanPlotHolder.class);
    private static Border focusedBorder_;
    private static Border unfocusedBorder_;

    public PanPlotHolder(PanAbstractPlot plot) {
        super(plot);
        this.setBackground(Color.WHITE);
        if (focusedBorder_ == null) {
            focusedBorder_ = PanGuiConstants.PADDED_FOCUSED_BORDER;
            unfocusedBorder_ = PanGuiConstants.PADDED_UNFOCUSED_BORDER;
        }
        this.setBorder(unfocusedBorder_);
        this.setFocusable(false);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void paint(Graphics g) {
        Cursor oldCursor = null;
        if (EventQueue.isDispatchThread()) {
            oldCursor = this.getCursor();
            CursorUtilities.setWaitCursor(this);
        }
        super.paint(g);
        if (oldCursor != null && EventQueue.isDispatchThread()) {
            this.setCursor(oldCursor);
        }
    }

    public Point2D.Double transformXY2GridCoords(int x, int y) {
        PanAbstractPlot plot = (PanAbstractPlot)this.getPlot();
        Point p = plot.getLocation();
        return plot.transformXY2GridCoords(x - p.x, y - p.y);
    }

    public String describePoint(int x, int y) {
        PanAbstractPlot plot = (PanAbstractPlot)this.getPlot();
        Point p = plot.getLocation();
        return plot.describePoint(x - p.x, y - p.y);
    }

    public void toggleBorderActive(boolean active) {
        if (active) {
            this.setBorder(focusedBorder_);
        } else {
            this.setBorder(unfocusedBorder_);
        }
        Graphics g = this.getGraphics();
        this.getBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        g.dispose();
    }

    public synchronized void flush() {
        for (KeyListener keyListener : this.getKeyListeners()) {
            this.removeKeyListener(keyListener);
        }
        for (EventListener eventListener : this.getMouseListeners()) {
            this.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.getMouseMotionListeners()) {
            this.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        this.removeAll();
    }
}

