/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.panoply.PanAbstractData;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotNote;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.Graphics2D;

public class PanMinMaxNote
extends PanPlotNote {
    private PanAbstractData data_;
    private PrintfFormat formatter_;
    private String formatString_;

    public PanMinMaxNote(PanPlotMeta pmeta, PanAbstractData data) {
        super(pmeta, "");
        this.data_ = data;
        this.localParameterChanged("all");
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        double min = this.data_.getMinimumValue();
        double max = this.data_.getMaximumValue();
        String s = "Data " + "Min = " + this.formatter_.sprintf(min) + ", " + "Max = " + this.formatter_.sprintf(max);
        this.setText(s);
        super.paintPiece(gx, printing);
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.localParameterChanged(pname);
    }

    private void localParameterChanged(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || pname.equals("all");
        if (changeAll || pname.contains("plot:scale.tick.format")) {
            String s = this.pmeta_.getString("plot:scale.tick.format");
            if (s == null) {
                throw new IllegalArgumentException("Null format string");
            }
            this.formatString_ = s;
            this.formatter_ = new PrintfFormat(this.formatString_);
        }
    }
}

