/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanGraphicUtilities;
import gov.nasa.giss.panoply.PanLonLatData;
import gov.nasa.giss.panoply.PanUtilities;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.plot.PanPlotScale;
import gov.nasa.giss.plot.PlotPieceMargins;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;

public class PanLonLatZonalPlot
extends PanPlotPiece {
    private static final BasicStroke HEAVY_STROKE = new BasicStroke(1.5f);
    private static final float BAD_POINT = -9999.0f;
    private PanLonLatData data_;
    private PanPlotScale scale_;
    private boolean southAtLeft_;
    private Color strokeColor_;
    private int gridWeight_ = 100;
    private Color gridColor_;
    private BasicStroke gridStroke_;
    private int yMajorDiv_ = 4;
    private int yMinorDiv_ = 2;
    private boolean logarithmic_;
    private int gridWidth_;
    private int gridHeight_;
    private int gridLeft_;
    private int gridTop_;
    private int gridBottom_;
    private int yAxisX_;
    private int xAxisY_;

    public PanLonLatZonalPlot(PanPlotMeta pmeta, PanLonLatData data, PanPlotScale scale) {
        super(pmeta);
        this.data_ = data;
        this.scale_ = scale;
        this.localParameterChanged("all");
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        Graphics2D g2d = (Graphics2D)gx.create();
        PlotPieceMargins margins = this.getMargins();
        int width = this.getWidth();
        int height = this.getHeight();
        this.gridWidth_ = (int)((double)(width - margins.left - margins.right) * 0.8);
        this.gridHeight_ = (int)((double)(height - margins.top - margins.bottom) * 0.8);
        this.gridLeft_ = margins.left + (int)(0.15 * (double)this.gridWidth_);
        this.gridTop_ = margins.top + (int)(0.1 * (double)this.gridHeight_);
        this.gridBottom_ = this.gridTop_ + this.gridHeight_;
        this.yAxisX_ = this.gridLeft_ - 8;
        this.xAxisY_ = this.gridBottom_ + 8;
        g2d.setFont(this.getFont());
        FontMetrics fm = g2d.getFontMetrics();
        double scaleMin = 0.0;
        double scaleMax = 0.0;
        if (this.pmeta_.getBoolean("plot:scale.autofit")) {
            scaleMin = this.data_.getMinimumValue();
            scaleMax = this.data_.getMaximumValue();
            if (Double.isNaN(scaleMin) || Double.isNaN(scaleMax)) {
                scaleMin = -0.1;
                scaleMax = 0.1;
            }
        } else {
            scaleMin = this.pmeta_.getDouble("plot:scale.minimum");
            scaleMax = this.pmeta_.getDouble("plot:scale.maximum");
        }
        if (this.logarithmic_) {
            if (scaleMin <= 0.0) {
                scaleMin = 1.0E-50;
            }
            if (scaleMax <= 1.0E-50) {
                scaleMax = 1.0E-25;
            }
        }
        int lwidth = 0;
        lwidth = this.logarithmic_ ? this.drawLogarithmicVerticalScale(g2d, scaleMin, scaleMax) : this.drawStandardVerticalScale(g2d, scaleMin, scaleMax);
        String yLabel = this.scale_.getCaption();
        g2d.setColor(this.getForeground());
        g2d.translate(this.yAxisX_ - 2 - lwidth - 10, this.gridBottom_ - (this.gridHeight_ - fm.stringWidth(yLabel)) / 2);
        g2d.rotate(-1.5707963267948966);
        GraphicUtilities.drawString(g2d, yLabel, 0, 0);
        g2d.rotate(1.5707963267948966);
        g2d.translate(-(this.yAxisX_ - 2 - lwidth - 10), -(this.gridBottom_ - (this.gridHeight_ - fm.stringWidth(yLabel)) / 2));
        float afhgt = this.pmeta_.getFloat("plot:font.height.axes");
        int hSteps = 12;
        double leftAxisValue = this.southAtLeft_ ? -90.0 : 90.0;
        double rightAxisValue = this.southAtLeft_ ? 90.0 : -90.0;
        double hScaleDelta = (rightAxisValue - leftAxisValue) / 12.0;
        g2d.setColor(this.getForeground());
        g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
        g2d.drawLine(this.gridLeft_, this.xAxisY_, this.gridLeft_ + this.gridWidth_, this.xAxisY_);
        for (int i = 0; i <= 12; ++i) {
            int value = (int)(leftAxisValue + (double)i * hScaleDelta);
            String label = PanConstants.PFORMAT_4G.sprintf((double)value);
            float tickX = (float)this.gridLeft_ + (float)this.gridWidth_ * (float)i / 12.0f;
            if (i % 2 == 0) {
                GraphicUtilities.drawString(g2d, label, (float)((int)(tickX - (float)(fm.stringWidth(label) / 2))), (float)(this.xAxisY_ + 2) + afhgt);
                g2d.setColor(this.gridColor_);
                g2d.setStroke(this.gridStroke_);
                GraphicUtilities.drawLine(g2d, tickX, this.gridBottom_ - this.gridHeight_, tickX, this.gridBottom_);
            }
            g2d.setColor(this.getForeground());
            g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
            GraphicUtilities.drawLine(g2d, tickX, this.xAxisY_ - 2, tickX, this.xAxisY_ + 2);
        }
        String xLabel = "Latitude (\u00b0N)";
        g2d.setColor(this.getForeground());
        GraphicUtilities.drawString(g2d, xLabel, (float)(this.gridLeft_ + (this.gridWidth_ - fm.stringWidth(xLabel)) / 2), (float)this.xAxisY_ + afhgt + 4.0f + afhgt);
        if (this.logarithmic_) {
            this.drawLogarithmicCurve(g2d, scaleMin, scaleMax);
        } else {
            this.drawStandardCurve(g2d, scaleMin, scaleMax);
        }
        g2d.dispose();
    }

    private int drawStandardVerticalScale(Graphics2D g2d, double scaleMin, double scaleMax) {
        g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
        g2d.setColor(this.getForeground());
        g2d.drawLine(this.yAxisX_, this.gridBottom_ - this.gridHeight_, this.yAxisX_, this.gridBottom_);
        FontMetrics fm = g2d.getFontMetrics();
        float afhgt = this.pmeta_.getFloat("plot:font.height.axes");
        int lwidth = 0;
        double delta = (scaleMax - scaleMin) / (double)this.gridHeight_;
        double invDelta = 1.0 / delta;
        int totalDivs = this.yMinorDiv_ * this.yMajorDiv_;
        double divSize = scaleMax - scaleMin == 0.0 ? 1.0E-25 : (scaleMax - scaleMin) / (double)totalDivs;
        for (int i = 0; i <= totalDivs; ++i) {
            double value = scaleMin + divSize * (double)i;
            String label = this.scale_.getFormatter().sprintf(value);
            float y = (float)((double)this.gridBottom_ - (value - scaleMin) * invDelta);
            g2d.setColor(this.getForeground());
            g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
            GraphicUtilities.drawLine(g2d, this.yAxisX_ - 2, y, this.yAxisX_ + 2, y);
            if (i % this.yMinorDiv_ != 0) continue;
            g2d.setColor(this.getForeground());
            GraphicUtilities.drawString(g2d, label, this.yAxisX_ - 2 - 1 - fm.stringWidth(label), (int)(y + afhgt / 2.0f));
            lwidth = Math.max(lwidth, fm.stringWidth(label));
            g2d.setColor(this.gridColor_);
            g2d.setStroke(this.gridStroke_);
            GraphicUtilities.drawLine(g2d, this.gridLeft_, y, this.gridLeft_ + this.gridWidth_, y);
        }
        return lwidth;
    }

    private int drawLogarithmicVerticalScale(Graphics2D g2d, double scaleMin, double scaleMax) {
        g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
        g2d.setColor(this.getForeground());
        g2d.drawLine(this.yAxisX_, this.gridBottom_ - this.gridHeight_, this.yAxisX_, this.gridBottom_);
        float afhgt = this.pmeta_.getFloat("plot:font.height.axes");
        FontMetrics fm = g2d.getFontMetrics();
        int lwidth = 0;
        double delta = (scaleMax - scaleMin) / (double)this.gridHeight_;
        double invDelta = 1.0 / delta;
        double logScaleMin = Math.log10(scaleMin);
        double logScaleMax = Math.log10(scaleMax);
        int iMin = (int)Math.floor(logScaleMin) - 1;
        int iMax = (int)Math.floor(logScaleMax) + 1;
        float mstep = (float)((double)this.gridHeight_ / (logScaleMax - logScaleMin));
        int intDiv = iMax - iMin;
        int intStep = (intDiv - 2) / 10 + 1;
        block0: for (int j = iMin; j <= iMax; ++j) {
            double value0 = (float)Math.pow(10.0, j);
            String label = this.scale_.getFormatter().sprintf(value0);
            lwidth = Math.max(lwidth, fm.stringWidth(label));
            for (int k = 0; k < 9; ++k) {
                double value = value0 * (1.0 + (double)k);
                if (value < scaleMin) continue;
                if (value > scaleMax) continue block0;
                double logValue = Math.log10(value);
                float y = (float)((double)this.gridBottom_ - (logValue - logScaleMin) * (double)mstep);
                if (y > (float)this.gridBottom_ + 0.1f) continue;
                if (y < (float)(this.gridBottom_ - this.gridHeight_) - 0.1f) continue block0;
                if (k == 0) {
                    if (j % intStep == 0) {
                        g2d.setColor(this.getForeground());
                        GraphicUtilities.drawString(g2d, label, this.yAxisX_ - 2 - 1 - fm.stringWidth(label), (int)(y + afhgt / 2.0f));
                        if ((double)Math.abs(y - (float)this.gridTop_) > 0.25 && (double)Math.abs(y - (float)this.gridBottom_) > 0.25) {
                            g2d.setColor(this.gridColor_);
                            g2d.setStroke(this.gridStroke_);
                            GraphicUtilities.drawLine(g2d, this.gridLeft_, y, this.gridLeft_ + this.gridWidth_, y);
                        }
                    }
                    g2d.setColor(this.getForeground());
                    g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
                    GraphicUtilities.drawLine(g2d, this.yAxisX_ - 2, y, this.yAxisX_ + 2, y);
                    continue;
                }
                if (intDiv > 15) continue;
                g2d.setColor(this.getForeground());
                g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
                GraphicUtilities.drawLine(g2d, this.yAxisX_ - 2, y, this.yAxisX_ + 2, y);
            }
        }
        g2d.setColor(this.gridColor_);
        g2d.setStroke(this.gridStroke_);
        GraphicUtilities.drawLine(g2d, this.gridLeft_, this.gridTop_, this.gridLeft_ + this.gridWidth_, this.gridTop_);
        GraphicUtilities.drawLine(g2d, this.gridLeft_, this.gridBottom_, this.gridLeft_ + this.gridWidth_, this.gridBottom_);
        return lwidth;
    }

    private void drawStandardCurve(Graphics2D g2d, double scaleMin, double scaleMax) {
        g2d.setColor(this.strokeColor_);
        g2d.setStroke(HEAVY_STROKE);
        double xScale = (double)this.gridWidth_ / (double)this.data_.getHeight();
        double delta = (scaleMax - scaleMin) / (double)this.gridHeight_;
        double invDelta = 1.0 / delta;
        float lastY = -9999.0f;
        int dheight = this.data_.getHeight();
        GeneralPath path = new GeneralPath();
        for (int j = 0; j < dheight; ++j) {
            double value = this.southAtLeft_ ? this.data_.getRowAverage(dheight - 1 - j) : this.data_.getRowAverage(j);
            float y = Double.isNaN(value) ? -9999.0f : (Double.isInfinite(value) ? (value < 0.0 ? (float)this.gridBottom_ + 10000.0f : (float)this.gridBottom_ - 10000.0f) : (float)((double)this.gridBottom_ - (value - scaleMin) * invDelta));
            if (y == -9999.0f) {
                lastY = -9999.0f;
                continue;
            }
            float x = (float)((double)this.gridLeft_ + xScale * (double)j + 1.0);
            if (lastY != -9999.0f) {
                path.lineTo(x, y);
            } else if (y != -9999.0f) {
                path.moveTo(x, y);
            }
            lastY = y;
        }
        g2d.draw(path);
    }

    private void drawLogarithmicCurve(Graphics2D g2d, double scaleMin, double scaleMax) {
        g2d.setColor(this.strokeColor_);
        g2d.setStroke(HEAVY_STROKE);
        double logScaleMin = Math.log10(scaleMin);
        double logScaleMax = Math.log10(scaleMax);
        double xScale = (double)this.gridWidth_ / (double)this.data_.getHeight();
        double delta = (logScaleMax - logScaleMin) / (double)this.gridHeight_;
        double invDelta = 1.0 / delta;
        float lastY = -9999.0f;
        int dheight = this.data_.getHeight();
        GeneralPath path = new GeneralPath();
        for (int j = 0; j < dheight; ++j) {
            double value = this.southAtLeft_ ? this.data_.getLogOfRowAverage(dheight - 1 - j) : this.data_.getLogOfRowAverage(j);
            float y = Double.isNaN(value) ? -9999.0f : (Double.isInfinite(value) ? (value < 0.0 ? (float)this.gridBottom_ + 10000.0f : (float)this.gridBottom_ - 10000.0f) : (float)((double)this.gridBottom_ - (value - logScaleMin) * invDelta));
            if (y == -9999.0f) {
                lastY = -9999.0f;
                continue;
            }
            float x = (float)((double)this.gridLeft_ + xScale * (double)j + 1.0);
            if (lastY != -9999.0f) {
                path.lineTo(x, y);
            } else if (y != -9999.0f) {
                path.moveTo(x, y);
            }
            lastY = y;
        }
        g2d.draw(path);
    }

    public synchronized void flush() {
        this.pmeta_ = null;
        this.data_ = null;
        this.scale_ = null;
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.localParameterChanged(pname);
    }

    private void localParameterChanged(String pname) {
        boolean changeAll;
        if (pname.equals("plot:lonlat.type") && this.pmeta_.getString("plot:lonlat.type").toLowerCase().indexOf("map") > -1) {
            return;
        }
        boolean bl = changeAll = pname == null || pname.equals("all");
        if (changeAll || pname.contains("plot:lonlat.type")) {
            this.data_.setGridEdges(-180.0, 90.0, 180.0, -90.0);
        }
        if (changeAll || pname.contains("plot:colors.background")) {
            this.setBackground(this.pmeta_.getColor("plot:colors.background"));
        }
        if (changeAll || pname.contains("plot:lonlat.zonal.stroke.color")) {
            this.strokeColor_ = this.pmeta_.getColor("plot:lonlat.zonal.stroke.color");
        }
        if (changeAll || pname.contains("plot:lonlat.zonal.grid.weight") || pname.contains("plot:colors.background")) {
            this.gridWeight_ = PanUtilities.minmax100(this.pmeta_.getInt("plot:lonlat.zonal.grid.weight"));
            this.gridColor_ = this.getForeground();
            this.gridStroke_ = PanGraphicUtilities.squareMiterStroke(this.gridWeight_);
        }
        if (changeAll || pname.contains("plot:scale.majordiv")) {
            this.yMajorDiv_ = Math.max(1, this.pmeta_.getInt("plot:scale.majordiv"));
            this.yMajorDiv_ = Math.min(20, this.yMajorDiv_);
        }
        if (changeAll || pname.contains("plot:scale.minordiv")) {
            this.yMinorDiv_ = Math.max(1, this.pmeta_.getInt("plot:scale.minordiv"));
            this.yMinorDiv_ = Math.min(20, this.yMinorDiv_);
        }
        if (changeAll || pname.contains("plot:font.master")) {
            Font axesFont;
            String fn = this.pmeta_.getString("plot:font.master");
            float afhgt = this.pmeta_.getFloat("plot:font.height.axes");
            try {
                axesFont = new Font(fn, 0, 8).deriveFont(afhgt);
            }
            catch (Exception exc) {
                axesFont = new Font("SansSerif", 0, 8).deriveFont(afhgt);
            }
            this.setFont(axesFont);
        }
        if (changeAll || pname.contains("plot:lonlat.zonal.lataxis.flipped")) {
            this.southAtLeft_ = this.pmeta_.getBoolean("plot:lonlat.zonal.lataxis.flipped");
        }
        if (changeAll || pname.contains("plot:scale.log10")) {
            this.logarithmic_ = this.pmeta_.getBoolean("plot:scale.log10");
        }
    }
}

