/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.ContourLevel;
import gov.nasa.giss.data.ContourLevels;
import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.Equirectangular;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.panoply.PanContourLocation;
import gov.nasa.giss.panoply.PanLonLatData;
import gov.nasa.giss.panoply.plot.PanAbstractPlot;
import gov.nasa.giss.panoply.plot.PanLonLatMap;
import gov.nasa.giss.panoply.plot.PanLonLatZonalPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotNote;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatPlot
extends PanAbstractPlot {
    private static Logger logger_ = LoggerFactory.getLogger(PanLonLatPlot.class);
    private LLPlotType plotType_ = LLPlotType.MAP;
    private PanLonLatMap map_;
    private PanLonLatZonalPlot zonalPlot_;
    private PanPlotNote projectionNote_;

    public PanLonLatPlot(PanPlotMeta pmeta, PanLonLatData data) {
        super(pmeta, data);
        this.projectionNote_ = new PanPlotNote(pmeta);
        this.projectionNote_.setFontSize(this.pmeta_.getFloat("plot:font.height.notes"));
        this.attach(this.projectionNote_);
        this.localParameterChanged("all");
    }

    private void showMap() {
        this.plotType_ = LLPlotType.MAP;
        if (this.map_ == null) {
            this.map_ = new PanLonLatMap(this.pmeta_, (PanLonLatData)this.data_);
            this.attach(this.map_);
        }
        if (this.zonalPlot_ != null) {
            this.zonalPlot_.setVisible(false);
        }
        this.placeMap();
        this.map_.setVisible(true);
        this.scale_.setVisible(true);
    }

    private void showZonalAverage() {
        this.plotType_ = LLPlotType.ZONAL;
        if (this.zonalPlot_ == null) {
            this.zonalPlot_ = new PanLonLatZonalPlot(this.pmeta_, (PanLonLatData)this.data_, this.scale_);
            this.attach(this.zonalPlot_);
        }
        if (this.map_ != null) {
            this.map_.setVisible(false);
        }
        this.placeZonalPlot();
        this.zonalPlot_.setVisible(true);
        this.scale_.setVisible(false);
    }

    public boolean isMap() {
        return this.plotType_ == LLPlotType.MAP;
    }

    public boolean isAzimuthalMap() {
        return this.isMap() && this.getProjection().isAzimuthal();
    }

    public boolean isZoomableMap() {
        return this.isMap() && (this.getProjection() instanceof EquirectangularRegional || this.getProjection() instanceof Equirectangular || this.getProjection().isAzimuthal());
    }

    public PanLonLatMap getMap() {
        return this.map_;
    }

    public AbstractProjection getProjection() {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        return proj;
    }

    public double[] getLonLatBounds() {
        return this.map_.getLonLatBounds();
    }

    public BufferedImage getEquirectImage(boolean fillTransparent, boolean borderVisible) {
        this.needsDataRedraw_ = true;
        this.refreshMap(fillTransparent);
        BufferedImage img = this.map_.getEquirectImage(fillTransparent, borderVisible);
        this.needsDataRedraw_ = true;
        return img;
    }

    private void placeMap() {
        if (this.map_ == null) {
            return;
        }
        Rectangle gbounds = this.pmeta_.getRect("plot:bounds.graphic");
        Dimension gridSize = this.pmeta_.getDimension("plot:size.grid");
        int mw = (gbounds.width - gridSize.width) / 2;
        int mh = (gbounds.height - gridSize.height) / 2;
        this.map_.setLocation(gbounds.x, gbounds.y);
        this.map_.setSize(gbounds.width, gbounds.height);
        this.map_.setMargins(mw, mh, mw, mh);
        this.placeNotes();
    }

    private void placeZonalPlot() {
        if (this.zonalPlot_ == null) {
            return;
        }
        Rectangle gbounds = this.pmeta_.getRect("plot:bounds.graphic");
        Rectangle sbounds = this.pmeta_.getRect("plot:bounds.scale");
        this.zonalPlot_.setLocation(gbounds.x, gbounds.y);
        this.zonalPlot_.setSize(gbounds.width, gbounds.height + sbounds.height);
        this.zonalPlot_.setMargins(0);
    }

    private void placeNotes() {
        if (this.plotType_ == LLPlotType.MAP && this.map_ != null) {
            Rectangle rectc = this.pmeta_.getRect("plot:bounds.note.center");
            Rectangle rectl = this.pmeta_.getRect("plot:bounds.note.left");
            Rectangle rectr = this.pmeta_.getRect("plot:bounds.note.right");
            this.projectionNote_.setVisible(this.pmeta_.getBoolean("plot:lonlat.map.projnote"));
            this.minMaxNote_.setVisible(this.pmeta_.getBoolean("plot:scale.minmaxnote"));
            if (this.projectionNote_.isVisible() && this.minMaxNote_.isVisible()) {
                this.projectionNote_.setBounds(rectl);
                this.minMaxNote_.setBounds(rectr);
                this.projectionNote_.setHorizontalAlignment(PanPlotNote.HAlignment.LEFT);
                this.minMaxNote_.setHorizontalAlignment(PanPlotNote.HAlignment.RIGHT);
            } else if (this.minMaxNote_.isVisible()) {
                this.minMaxNote_.setBounds(rectc);
                this.minMaxNote_.setHorizontalAlignment(PanPlotNote.HAlignment.CENTER);
            } else if (this.projectionNote_.isVisible()) {
                this.projectionNote_.setBounds(rectc);
                this.projectionNote_.setHorizontalAlignment(PanPlotNote.HAlignment.CENTER);
            }
        } else if (this.zonalPlot_ != null) {
            this.minMaxNote_.setVisible(this.pmeta_.getBoolean("plot:scale.minmaxnote"));
            if (this.minMaxNote_.isVisible()) {
                this.minMaxNote_.setBounds(this.pmeta_.getRect("plot:bounds.note.center"));
                this.minMaxNote_.setHorizontalAlignment(PanPlotNote.HAlignment.CENTER);
            }
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        if (this.map_ != null) {
            this.placeMap();
        }
        if (this.zonalPlot_ != null) {
            this.placeZonalPlot();
        }
        this.placeNotes();
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        super.paintPiece(gx, printing);
        if (this.plotType_ == LLPlotType.MAP) {
            this.refreshMap(false);
        }
    }

    private void refreshMap(boolean fillTransparent) {
        if (this.projectionNote_ != null && this.projectionNote_.isVisible()) {
            PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
            this.projectionNote_.setText(projmeta.getDescription());
        }
        if (this.needsDataRedraw_) {
            this.paintDataImage(fillTransparent);
            this.map_.setSource(this.dataImage_);
            this.needsRecontour_ = true;
        }
        ContourLevels levels = null;
        if (this.needsRecontour_ && this.contourWeight_ > 0) {
            double[] tvalues = this.smeta_.getContourTickValues();
            this.contours_.setLevelValues(tvalues);
            levels = this.contours_.getLevels();
            if (PanContourLocation.MINOR.matches(this.pmeta_.getString("plot:contour.location"))) {
                double[] mvalues = this.smeta_.getMajorTickValues();
                block0: for (ContourLevel level : levels) {
                    double value = level.getValue();
                    level.setLabeled(false);
                    for (int i = 0; i < mvalues.length; ++i) {
                        if (value != mvalues[i]) continue;
                        level.setLabeled(true);
                        continue block0;
                    }
                }
            }
            this.map_.setContours(levels);
            this.needsRecontour_ = false;
        }
    }

    public PointLL transformXY2LL(Point p) {
        return this.transformXY2LL(p.x, p.y);
    }

    public PointLL transformXY2LL(int x, int y) {
        if (this.plotType_ == LLPlotType.ZONAL) {
            return null;
        }
        if (this.map_ == null) {
            return null;
        }
        return this.map_.transformXY2LL(x - this.map_.getLocation().x, y - this.map_.getLocation().y);
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        if (this.plotType_ == LLPlotType.ZONAL) {
            return null;
        }
        if (this.map_ == null) {
            return null;
        }
        PointLL ll = this.map_.transformXY2LL(x - (double)this.map_.getLocation().x, y - (double)this.map_.getLocation().y);
        if (ll == null) {
            return null;
        }
        return new Point2D.Double(ll.getLon(), ll.getLat());
    }

    @Override
    public String describePoint(int x, int y) {
        PointLL ll = this.transformXY2LL(x, y);
        if (ll == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        ((PanLonLatData)this.data_).describeData(sb, ll);
        return sb.toString();
    }

    @Override
    public synchronized void flush() {
        if (this.map_ != null) {
            this.map_.flush();
            this.map_ = null;
        }
        if (this.zonalPlot_ != null) {
            this.zonalPlot_.flush();
            this.zonalPlot_ = null;
        }
        super.flush();
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.localParameterChanged(pname);
    }

    private void localParameterChanged(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || pname.equals("all");
        if (changeAll || pname.contains("plot:lonlat.type")) {
            if (this.pmeta_.getString("plot:lonlat.type").toLowerCase().indexOf("map") > -1) {
                this.showMap();
            } else {
                this.showZonalAverage();
            }
        }
        if (changeAll || pname.contains("plot:lonlat.type") || pname.contains("plot:scale.interpolate") || pname.contains("plot:scale.log10")) {
            this.needsDataRedraw_ = true;
        }
        if (this.plotType_ == LLPlotType.MAP && (pname.contains("plot:lonlat.type") || pname.contains("plot:lonlat.map.projection") || pname.contains("plot:lonlat.map.center.lon") || pname.contains("plot:lonlat.map.center.lat") || pname.contains("plot:lonlat.map.param.0") || pname.contains("plot:lonlat.map.param.1") || pname.contains("plot:lonlat.map.param.2") || pname.contains("plot:lonlat.map.param.3") || pname.contains("plot:lonlat.map.param.4") || pname.contains("plot:scale.log10"))) {
            this.needsDataRedraw_ = true;
            this.needsRecontour_ = true;
            this.showMap();
        }
        if (changeAll || pname.contains("plot:lonlat.map.projnote") || pname.contains("plot:scale.minmaxnote")) {
            this.placeNotes();
        }
    }

    private static enum LLPlotType {
        MAP,
        ZONAL;

    }
}

