/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.ContourLevel;
import gov.nasa.giss.data.ContourLevels;
import gov.nasa.giss.data.ContourLine;
import gov.nasa.giss.geom.PointLL;
import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.map.ProjectionFactory;
import gov.nasa.giss.map.overlay.AbstractOverlay;
import gov.nasa.giss.map.overlay.MaskOverlay;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.Equirectangular;
import gov.nasa.giss.map.proj.EquirectangularRegional;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanContourStyle;
import gov.nasa.giss.panoply.PanGraphicUtilities;
import gov.nasa.giss.panoply.PanGridStyle;
import gov.nasa.giss.panoply.PanLonLatData;
import gov.nasa.giss.panoply.PanUtilities;
import gov.nasa.giss.panoply.PanVectorStyle;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.plot.PanProjectionMeta;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanLonLatMap
extends PanPlotPiece {
    private static Logger logger_ = LoggerFactory.getLogger(PanLonLatMap.class);
    private static final BasicStroke BORDER_STROKE = new BasicStroke(1.5f);
    private static final double COS45 = Math.cos(Math.toRadians(45.0));
    private static final double RAD135 = Math.toRadians(135.0);
    private BufferedImage source_;
    private double llTop_ = 90.0;
    private double llRight_ = 190.0;
    private double llBottom_ = -90.0;
    private double llLeft_ = -180.0;
    private Color gridColor_;
    private BasicStroke gridStroke_;
    private int gridWeight_;
    private double gridSpacing_;
    private boolean gridLabeled_;
    private AbstractOverlay overlay;
    private int overlayWeight_;
    private Color overlayColor_;
    private BasicStroke overlayStroke_;
    private boolean omaskInverted_;
    private boolean contoursLabeled_;
    private int contourWeight_;
    private ContourLevels contourLevels_;
    private BasicStroke contourStrokeSolid_;
    private BasicStroke contourStrokeDotted_;
    private Font contourFont_;
    private Font gridFont_;
    private PanVectorStyle vectorStyle_;
    private int vectorWeight_;
    private Color vectorColor_;
    private BasicStroke vectorStroke_;
    private PrintfFormat scaleFormatter_ = new PrintfFormat("%G");
    private BufferedImage maskedImage_;
    private PanLonLatData data_;

    public PanLonLatMap(PanPlotMeta pmeta, PanLonLatData data) {
        super(pmeta);
        this.data_ = data;
        this.setOpaque(true);
        this.localParameterChanged("all");
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.maskedImage_ = null;
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        projmeta.setSize(width, height);
        projmeta.setMargins(this.getMargins().left, this.getMargins().top);
        this.updateGridEdges();
    }

    @Override
    public void setMargins(int left, int top, int right, int bottom) {
        super.setMargins(left, top, right, bottom);
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        projmeta.setSize(this.getWidth(), this.getHeight());
        projmeta.setMargins(left, top);
        this.updateGridEdges();
    }

    @Override
    protected synchronized void paintPiece(Graphics2D g2d, boolean printing) {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        proj.setBorderStroke(BORDER_STROKE);
        this.paintMap(g2d, printing, proj);
    }

    private void paintMap(Graphics2D gx, boolean printing, AbstractProjection projection) {
        Graphics2D g2d = (Graphics2D)gx.create();
        if (this.overlay != null && this.overlay instanceof MaskOverlay && this.overlayWeight_ > 0) {
            MaskOverlay mask = (MaskOverlay)this.overlay;
            if (this.maskedImage_ == null) {
                this.maskedImage_ = new BufferedImage(this.source_.getWidth(), this.source_.getHeight(), 2);
            }
            int maskWidth = mask.getWidth();
            int maskHeight = mask.getHeight();
            Graphics2D tg2d = this.maskedImage_.createGraphics();
            tg2d.drawImage((Image)this.source_, 0, 0, this);
            this.drawMaskOverlay(tg2d);
            tg2d.dispose();
            projection.setSource(this.maskedImage_, this.llTop_, this.llRight_, this.llBottom_, this.llLeft_);
        } else {
            projection.setSource(this.source_, this.llTop_, this.llRight_, this.llBottom_, this.llLeft_);
        }
        projection.paintMap(g2d);
        if (this.overlay != null && this.overlay instanceof OutlineOverlay && this.overlayWeight_ > 0) {
            projection.setPathColor(this.overlayColor_);
            projection.setPathStroke(this.overlayStroke_);
            projection.drawPath(g2d, ((OutlineOverlay)this.overlay).getPoints());
        }
        this.drawContours(g2d, projection);
        this.drawVectors(g2d, projection);
        if (this.gridStroke_ != null && this.gridWeight_ > 0 && this.gridSpacing_ > 0.0) {
            projection.setGridSpacing(this.gridSpacing_);
            projection.setGridColor(this.gridColor_);
            projection.setGridStroke(this.gridStroke_);
            projection.setGridLabeled(this.gridLabeled_);
            projection.setGridFont(this.gridFont_);
            projection.drawGrid(g2d);
        }
        projection.drawBorder(g2d);
        g2d.dispose();
    }

    private void drawMaskOverlay(Graphics2D g2d) {
        double lon1;
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        BufferedImage mask = ((MaskOverlay)this.overlay).getMask(this.overlayColor_, this.omaskInverted_);
        int srcWidth = this.source_.getWidth();
        int srcHeight = this.source_.getHeight();
        int maskWidth = ((MaskOverlay)this.overlay).getWidth();
        int maskHeight = ((MaskOverlay)this.overlay).getHeight();
        g2d.setClip(0, 0, srcWidth, srcHeight);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.01f * (float)this.overlayWeight_));
        double xRatio = (double)srcWidth / (this.llRight_ - this.llLeft_);
        double yRatio = (double)srcHeight / (this.llBottom_ - this.llTop_);
        double lat1 = 90.0;
        double coplon = proj.getCenter().getLon();
        for (lon1 = -180.0; lon1 < coplon - 180.0; lon1 += 360.0) {
        }
        while (lon1 > coplon + 180.0) {
            lon1 -= 360.0;
        }
        double x1 = (lon1 - this.llLeft_) * xRatio;
        double x2 = (lon1 + 360.0 - this.llLeft_) * xRatio;
        double y1 = (lat1 - this.llTop_) * yRatio;
        double y2 = (lat1 - 180.0 - this.llTop_) * yRatio;
        g2d.drawImage(mask, (int)x1, (int)y1, (int)x2, (int)y2, 0, 0, maskWidth, maskHeight, this);
        if (x2 < (double)srcWidth) {
            double x3 = (lon1 + 720.0 - this.llLeft_) * xRatio;
            g2d.drawImage(mask, (int)x2, (int)y1, (int)x3, (int)y2, 0, 0, maskWidth, maskHeight, this);
        } else if (x1 > 0.0) {
            double x3 = (lon1 - 360.0 - this.llLeft_) * xRatio;
            g2d.drawImage(mask, (int)x3, (int)y1, (int)x1, (int)y2, 0, 0, maskWidth, maskHeight, this);
        }
    }

    protected void drawContours(Graphics2D g2d, AbstractProjection proj) {
        if (this.contourWeight_ < 1) {
            return;
        }
        String style = this.pmeta_.getString("plot:contour.style").toLowerCase();
        if (style.indexOf("none") > -1) {
            return;
        }
        if (this.contourLevels_ == null) {
            return;
        }
        int levelcount = this.contourLevels_.size();
        if (levelcount == 0) {
            return;
        }
        Color color = this.pmeta_.getColor("plot:contour.color");
        for (ContourLevel level : this.contourLevels_) {
            double value = level.getValue();
            String label = this.scaleFormatter_.sprintf(value);
            BasicStroke stroke = style.equalsIgnoreCase(PanContourStyle.DOTNEG.getValue()) ? (value < 0.0 ? this.contourStrokeDotted_ : this.contourStrokeSolid_) : (style.equalsIgnoreCase(PanContourStyle.DOTTED.getValue()) ? this.contourStrokeDotted_ : this.contourStrokeSolid_);
            int levelsize = level.size();
            for (int ii = 0; ii < levelsize; ++ii) {
                ContourLine line = (ContourLine)level.elementAt(ii);
                Point2D.Double[] points = line.toArray(new Point2D.Double[0]);
                PointLL[] llPoints = new PointLL[points.length];
                for (int iii = 0; iii < points.length; ++iii) {
                    if (points[iii] == null) {
                        llPoints[iii] = null;
                        continue;
                    }
                    Point2D.Double ll = this.data_.getXY(points[iii].x, points[iii].y);
                    llPoints[iii] = new PointLL(ll.x, ll.y);
                }
                if (this.contoursLabeled_ && level.isLabeled()) {
                    proj.drawPath(g2d, llPoints, stroke, color, label, this.contourFont_);
                    continue;
                }
                proj.drawPath(g2d, llPoints, stroke, color);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void drawVectors(Graphics2D g2d, AbstractProjection proj) {
        int ystart;
        boolean negativeAngle;
        double baseAngleRad;
        if (this.vectorWeight_ < 1) {
            return;
        }
        if (this.vectorStyle_ == PanVectorStyle.NONE) {
            return;
        }
        double maxMag = this.pmeta_.getDouble("plot:vector.value");
        if (maxMag <= 0.0) {
            return;
        }
        Color color = this.vectorColor_;
        BasicStroke stroke = this.vectorStroke_;
        g2d.setColor(color);
        g2d.setStroke(stroke);
        int swidth = this.source_.getWidth();
        int sheight = this.source_.getHeight();
        int iheight = this.getHeight();
        int iwidth = this.getWidth();
        int vlength = this.pmeta_.getInt("plot:vector.length");
        int hlength = vlength / 4;
        double spacePct = 0.01 * (double)this.pmeta_.getInt("plot:vector.spacing");
        int spacing = (int)((double)vlength * spacePct);
        String dir1 = this.pmeta_.getString("plot:lonlat.map.vector.direction1");
        String dir2 = this.pmeta_.getString("plot:lonlat.map.vector.direction2");
        if (dir2.equalsIgnoreCase("north")) {
            baseAngleRad = Math.toRadians(0.0);
            if (dir1.equalsIgnoreCase("east")) {
                negativeAngle = false;
            } else {
                if (!dir1.equalsIgnoreCase("west")) return;
                negativeAngle = true;
            }
        } else if (dir2.equalsIgnoreCase("east")) {
            baseAngleRad = Math.toRadians(90.0);
            if (dir1.equalsIgnoreCase("south")) {
                negativeAngle = false;
            } else {
                if (!dir1.equalsIgnoreCase("north")) return;
                negativeAngle = true;
            }
        } else if (dir2.equalsIgnoreCase("south")) {
            baseAngleRad = Math.toRadians(180.0);
            if (dir1.equalsIgnoreCase("west")) {
                negativeAngle = false;
            } else {
                if (!dir1.equalsIgnoreCase("east")) return;
                negativeAngle = true;
            }
        } else {
            if (!dir2.equalsIgnoreCase("west")) return;
            baseAngleRad = Math.toRadians(270.0);
            if (dir1.equalsIgnoreCase("north")) {
                negativeAngle = false;
            } else {
                if (!dir1.equalsIgnoreCase("south")) return;
                negativeAngle = true;
            }
        }
        GeneralPath arrow = new GeneralPath();
        int xstart = iwidth / 2 - spacing * (iwidth / 2 / spacing);
        for (int y = ystart = iheight / 2 - spacing * (iheight / 2 / spacing); y < iheight; y += spacing) {
            for (int x = xstart; x < iwidth; x += spacing) {
                float ytip;
                float xtip;
                double factor;
                double length;
                double angleRad;
                double mag;
                double lon;
                PointLL lonlat = this.transformXY2LL(x, y);
                if (lonlat == null) continue;
                double lat = lonlat.getLat();
                for (lon = lonlat.getLon(); lon < this.llLeft_; lon += 360.0) {
                }
                while (lon > this.llRight_) {
                    lon -= 360.0;
                }
                double row = (lat - this.llTop_) * (double)sheight / (this.llBottom_ - this.llTop_);
                double col = (lon - this.llLeft_) * (double)swidth / (this.llRight_ - this.llLeft_);
                if (col < 0.0 || Double.isNaN(mag = this.data_.valueAt((int)col, (int)row)) || Double.isNaN(angleRad = this.data_.angleAt((int)col, (int)row))) continue;
                angleRad = negativeAngle ? baseAngleRad - angleRad : baseAngleRad + angleRad;
                if (Double.isNaN(angleRad = proj.transformLLAngle2XYAngle(lonlat, angleRad)) || (length = (double)vlength * (factor = mag / maxMag)) == 0.0) continue;
                float xorig = (float)((double)x + 0.5);
                float yorig = (float)((double)y + 0.5);
                if (this.vectorStyle_ == PanVectorStyle.UPDOT) {
                    if (factor > 1.0) {
                        factor = 1.0;
                    }
                    double radius = 2.0 * factor;
                    g2d.fill(new Ellipse2D.Double((double)xorig - radius, (double)yorig - radius, radius * 2.0, radius * 2.0));
                }
                if (this.transformXY2LL(xtip = (float)((double)xorig + length * Math.sin(angleRad)), ytip = (float)((double)yorig - length * Math.cos(angleRad))) == null) {
                    float xmin = xorig;
                    float ymin = yorig;
                    float xmax = xtip;
                    float ymax = ytip;
                    for (int iterate = 0; iterate < 5; ++iterate) {
                        xtip = 0.5f * (xmin + xmax);
                        ytip = 0.5f * (ymin + ymax);
                        if (this.transformXY2LL(xtip, ytip) == null) {
                            xmax = xtip;
                            ymax = ytip;
                            continue;
                        }
                        xmin = xtip;
                        ymin = ytip;
                    }
                    GraphicUtilities.drawLine(g2d, xorig, yorig, xtip, ytip);
                    continue;
                }
                GraphicUtilities.drawLine(g2d, xorig, yorig, xtip, ytip);
                if (this.vectorStyle_ != PanVectorStyle.ARROW) continue;
                double hlengthX = (float)((double)hlength * COS45 * Math.min(1.0, factor));
                float x1 = (float)((double)xtip + hlengthX * Math.sin(angleRad - RAD135));
                float y1 = (float)((double)ytip - hlengthX * Math.cos(angleRad - RAD135));
                float x2 = (float)((double)xtip + hlengthX * Math.sin(angleRad + RAD135));
                float y2 = (float)((double)ytip - hlengthX * Math.cos(angleRad + RAD135));
                GraphicUtilities.drawLine(g2d, x1, y1, xtip, ytip);
                GraphicUtilities.drawLine(g2d, x2, y2, xtip, ytip);
            }
        }
    }

    public void setSource(BufferedImage source) {
        this.source_ = source;
    }

    public void setContours(ContourLevels levels) {
        this.contourLevels_ = levels;
    }

    public PointLL transformXY2LL(Point p) {
        return this.transformXY2LL(p.getX(), p.getY());
    }

    public PointLL transformXY2LL(int x, int y) {
        return this.transformXY2LL((double)x, (double)y);
    }

    public PointLL transformXY2LL(double x, double y) {
        if (x < 0.0 || y < 0.0 || x > (double)this.getWidth() || y > (double)this.getHeight()) {
            return null;
        }
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        PointLL ll = proj.transformXY2LL((int)x, (int)y);
        return ll;
    }

    public synchronized void flush() {
        this.maskedImage_ = null;
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.localParameterChanged(pname);
    }

    private void localParameterChanged(String pname) {
        String s;
        boolean changeAll;
        if (pname.contains("plot:lonlat.type") && this.pmeta_.getString("plot:lonlat.type").toLowerCase().indexOf("map") <= -1) {
            return;
        }
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        if (proj == null) {
            return;
        }
        boolean bl = changeAll = pname == null || pname.equals("all");
        if (changeAll || pname.contains("plot:lonlat.map.projection")) {
            // empty if block
        }
        if (changeAll || pname.contains("plot:lonlat.map.center.lon") || pname.contains("plot:lonlat.map.center.lat") || pname.contains("plot:lonlat.map.param.0") || pname.contains("plot:lonlat.map.param.1") || pname.contains("plot:lonlat.map.param.2") || pname.contains("plot:lonlat.map.param.3") || pname.contains("plot:lonlat.map.param.4")) {
            // empty if block
        }
        if (changeAll || pname.contains("plot:lonlat.type") || pname.contains("plot:lonlat.map.projection") || pname.contains("plot:lonlat.map.center.lon") || pname.contains("plot:lonlat.map.center.lat") || pname.contains("plot:lonlat.map.param.0") || pname.contains("plot:lonlat.map.param.1") || pname.contains("plot:lonlat.map.param.2") || pname.contains("plot:lonlat.map.param.3") || pname.contains("plot:lonlat.map.param.4")) {
            this.updateGridEdges();
        }
        if (changeAll || pname.contains("plot:colors.background")) {
            this.setBackground(this.pmeta_.getColor("plot:colors.background"));
            proj.setBackground(this.getBackground());
            proj.setForeground(this.getForeground());
        }
        if (changeAll || pname.contains("plot:lonlat.map.grid.spacing") || pname.contains("plot:lonlat.map.grid.color") || pname.contains("plot:lonlat.map.grid.weight") || pname.contains("plot:lonlat.map.grid.style")) {
            this.gridSpacing_ = this.pmeta_.getDouble("plot:lonlat.map.grid.spacing");
            this.gridWeight_ = PanUtilities.minmax100(this.pmeta_.getInt("plot:lonlat.map.grid.weight"));
            this.gridColor_ = this.pmeta_.getColor("plot:lonlat.map.grid.color");
            String gs = this.pmeta_.getString("plot:lonlat.map.grid.style");
            this.gridStroke_ = PanGridStyle.SOLID.matches(gs) ? PanGraphicUtilities.squareMiterStroke(this.gridWeight_) : (PanGridStyle.DASHED.matches(gs) ? PanGraphicUtilities.buttMiterStroke(this.gridWeight_, new float[]{5.0f, 6.0f, 5.0f, 6.0f}, 2.5f) : (PanGridStyle.DOTTED.matches(gs) ? PanGraphicUtilities.buttMiterStroke(this.gridWeight_, new float[]{2.0f, 2.0f, 2.0f, 2.0f}, 1.0f) : null));
        }
        if (changeAll || pname.contains("plot:lonlat.map.grid.label")) {
            this.gridLabeled_ = this.pmeta_.getBoolean("plot:lonlat.map.grid.label");
        }
        if (changeAll || pname.contains("plot:lonlat.map.overlay") || pname.contains("plot:lonlat.map.overlay.color") || pname.contains("plot:lonlat.map.overlay.weight") || pname.contains("plot:lonlat.map.overlay.invert")) {
            this.overlay = (AbstractOverlay)this.pmeta_.get("plot:lonlat.map.overlay");
            this.overlayWeight_ = PanUtilities.minmax100(this.pmeta_.getInt("plot:lonlat.map.overlay.weight"));
            this.overlayColor_ = this.pmeta_.getColor("plot:lonlat.map.overlay.color");
            this.overlayStroke_ = PanGraphicUtilities.roundStroke(this.overlayWeight_);
            this.omaskInverted_ = this.pmeta_.getBoolean("plot:lonlat.map.overlay.invert");
        }
        if (changeAll || pname.contains("plot:contour.color") || pname.contains("plot:contour.weight") || pname.contains("plot:contour.style")) {
            s = this.pmeta_.getString("plot:contour.style");
            this.contourWeight_ = s.toLowerCase().indexOf("none") > -1 ? 0 : PanUtilities.minmax100(this.pmeta_.getInt("plot:contour.weight"));
            this.contourStrokeSolid_ = PanGraphicUtilities.roundStroke(this.contourWeight_);
            this.contourStrokeDotted_ = PanGraphicUtilities.roundStroke(this.contourWeight_, PanConstants.DOT_PATTERN);
        }
        if (changeAll || pname.contains("plot:contour.labels")) {
            this.contoursLabeled_ = this.pmeta_.getBoolean("plot:contour.labels");
        }
        if (changeAll || pname.contains("plot:combination") || pname.contains("plot:vector.color") || pname.contains("plot:vector.weight") || pname.contains("plot:vector.style")) {
            boolean vectorsEnabled;
            PanCombinationType ctype = (PanCombinationType)this.pmeta_.get("plot:combination");
            boolean bl2 = vectorsEnabled = ctype != null && ctype == PanCombinationType.VECTOR_A1_A2;
            if (vectorsEnabled) {
                String vs = this.pmeta_.getString("plot:vector.style").toLowerCase();
                if (PanVectorStyle.ARROW.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.ARROW;
                    this.vectorWeight_ = PanUtilities.minmax100(this.pmeta_.getInt("plot:vector.weight"));
                } else if (PanVectorStyle.UPDOT.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.UPDOT;
                    this.vectorWeight_ = PanUtilities.minmax100(this.pmeta_.getInt("plot:vector.weight"));
                } else {
                    this.vectorStyle_ = PanVectorStyle.NONE;
                    this.vectorWeight_ = 0;
                }
            } else {
                this.vectorWeight_ = 0;
            }
            if (this.vectorWeight_ > 0) {
                this.vectorColor_ = this.pmeta_.getColor("plot:vector.color");
                this.vectorStroke_ = PanGraphicUtilities.buttMiterStroke(this.vectorWeight_);
            } else {
                this.vectorColor_ = null;
                this.vectorStroke_ = null;
            }
        }
        if (changeAll || pname.contains("plot:font.master")) {
            String fn = this.pmeta_.getString("plot:font.master");
            float gfhgt = this.pmeta_.getFloat("plot:font.height.grid");
            float cfhgt = this.pmeta_.getFloat("plot:font.height.contour");
            try {
                this.gridFont_ = new Font(fn, 0, 8).deriveFont(gfhgt);
                this.contourFont_ = new Font(fn, 0, 8).deriveFont(cfhgt);
            }
            catch (Exception exc) {
                this.gridFont_ = new Font("SansSerif", 0, 8).deriveFont(gfhgt);
                this.contourFont_ = new Font("SansSerif", 0, 8).deriveFont(cfhgt);
            }
        }
        if (changeAll || pname.contains("plot:scale.tick.format")) {
            s = this.pmeta_.getString("plot:scale.tick.format");
            if (s == null) {
                throw new IllegalArgumentException("Null format string");
            }
            this.scaleFormatter_ = new PrintfFormat(s);
        }
    }

    public BufferedImage getEquirectImage(boolean fillTransparent, boolean borderVisible) {
        int w = this.getWidth();
        int h = this.getHeight();
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        AbstractProjection proj = projmeta.getProjection();
        AbstractProjection eqproj = proj instanceof Equirectangular ? ProjectionFactory.create("Equirectangular", w, h) : new EquirectangularRegional(w, h);
        if (eqproj instanceof EquirectangularRegional) {
            EquirectangularRegional eqr = (EquirectangularRegional)eqproj;
            eqr.setCenter((this.llLeft_ + this.llRight_) * 0.5, (this.llBottom_ + this.llTop_) * 0.5);
            eqr.setWidth(this.llRight_ - this.llLeft_);
            eqr.setHeight(this.llTop_ - this.llBottom_);
        } else {
            eqproj.setCenter(0.0, 0.0);
        }
        if (fillTransparent) {
            eqproj.setBackground(new Color(0x999999));
        } else {
            eqproj.setBackground(this.getBackground());
        }
        eqproj.setForeground(this.getForeground());
        eqproj.setZoom(1.0);
        if (borderVisible) {
            eqproj.setBorderStroke(BORDER_STROKE);
        } else {
            eqproj.setBorderStroke(null);
        }
        eqproj.setLonGridSpacing(proj.getLonGridSpacing());
        eqproj.setLatGridSpacing(proj.getLatGridSpacing());
        eqproj.setGridColor(proj.getGridColor());
        eqproj.setGridStroke(proj.getGridStroke());
        eqproj.setGridLabeled(proj.isGridLabeled());
        eqproj.setPathPoints(proj.getPathPoints());
        eqproj.setPathColor(proj.getPathColor());
        eqproj.setPathStroke(proj.getPathStroke());
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g2d = img.createGraphics();
        this.paintMap(g2d, false, eqproj);
        g2d.dispose();
        return img;
    }

    public synchronized double[] getLonLatBounds() {
        return new double[]{this.llLeft_, this.llTop_, this.llRight_, this.llBottom_};
    }

    public synchronized void updateGridEdges() {
        PanProjectionMeta projmeta = this.pmeta_.getProjectionMeta();
        double[] edges = projmeta.getGridEdges();
        this.llLeft_ = edges[0];
        this.llTop_ = edges[1];
        this.llRight_ = edges[2];
        this.llBottom_ = edges[3];
        this.data_.setGridEdges(edges);
    }
}

