/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanLatVertData;
import gov.nasa.giss.panoply.PanVectorStyle;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanXVertPlot;
import gov.nasa.giss.plot.PlotPieceMargins;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class PanLatVertPlot
extends PanXVertPlot {
    private static final double RAD_0 = Math.toRadians(0.0);
    private static final double RAD_90 = Math.toRadians(90.0);
    private static final double RAD_180 = Math.toRadians(180.0);
    private static final double RAD_270 = Math.toRadians(280.0);
    private static final double COS45 = Math.cos(Math.toRadians(45.0));
    private static final double RAD135 = Math.toRadians(135.0);
    private double minLat_ = -90.0;
    private double maxLat_ = 90.0;

    public PanLatVertPlot(PanPlotMeta pmeta, PanLatVertData data) {
        super(pmeta, data);
        this.localParameterChanged("all");
    }

    @Override
    protected void drawGridXAxis(Graphics2D g2d, int left, int top, int right, int bottom) {
        float afhgt = this.pmeta_.getFloat("plot:font.height.axes");
        g2d.setFont(this.axisTickFont_);
        FontMetrics fm = g2d.getFontMetrics();
        int xTotalDiv = this.xMajorDiv_ * this.xMinorDiv_;
        double xDelta = (this.rBound_ - this.lBound_) / (double)xTotalDiv;
        for (int i = 0; i <= xTotalDiv; ++i) {
            float x = (float)((double)(this.gridWidth_ * i) / (double)xTotalDiv);
            if (i % this.xMinorDiv_ == 0) {
                g2d.setColor(this.getForeground());
                double axisVal = this.lBound_ + xDelta * (double)i;
                String label = PanConstants.PFORMAT_4G.sprintf(axisVal);
                GraphicUtilities.drawString(g2d, label, (float)(left + (int)x - fm.stringWidth(label) / 2), (float)(bottom + 2) + afhgt);
                if (i > 0 && i < xTotalDiv && this.gridWeight_ > 0) {
                    g2d.setColor(this.gridColor_);
                    g2d.setStroke(this.gridStroke_);
                    GraphicUtilities.drawLine(g2d, (float)left + x, top, (float)left + x, bottom);
                }
            }
            if (i <= 0 || i >= xTotalDiv) continue;
            int tt = i % this.xMinorDiv_ == 0 ? (int)((double)afhgt * 2.0 / 3.0) : (int)((double)afhgt / 3.0);
            g2d.setColor(this.getForeground());
            g2d.setStroke(PanConstants.ONEPT_SQUARE_STROKE);
            GraphicUtilities.drawLine(g2d, (float)left + x, top, (float)left + x, top + tt);
            GraphicUtilities.drawLine(g2d, (float)left + x, bottom, (float)left + x, bottom - tt);
        }
        g2d.setColor(this.getForeground());
        g2d.setFont(this.axisNameFont_);
        fm = g2d.getFontMetrics();
        GraphicUtilities.drawString(g2d, this.userXLabel_, (float)(left + (this.gridWidth_ - fm.stringWidth(this.userXLabel_)) / 2), (float)(bottom + 2) + afhgt + 6.0f + afhgt);
    }

    @Override
    protected void drawVectors(Graphics2D g2d) {
        boolean negativeAngle;
        double baseAngleRad;
        if (this.vectorWeight_ < 1) {
            return;
        }
        if (this.vectorStyle_ == PanVectorStyle.NONE) {
            return;
        }
        double maxMag = this.pmeta_.getDouble("plot:vector.value");
        if (maxMag <= 0.0) {
            return;
        }
        Color color = this.vectorColor_;
        BasicStroke stroke = this.vectorStroke_;
        g2d.setColor(color);
        g2d.setStroke(stroke);
        int swidth = this.gridWidth_;
        int sheight = this.gridHeight_;
        int vlength = this.pmeta_.getInt("plot:vector.length");
        int hlength = vlength / 4;
        double spacePct = 0.01 * (double)this.pmeta_.getInt("plot:vector.spacing");
        int spacing = (int)((double)vlength * spacePct);
        String dir1 = this.pmeta_.getString("plot:latvert.vector.direction1");
        String dir2 = this.pmeta_.getString("plot:latvert.vector.direction2");
        if (dir2.equalsIgnoreCase("up")) {
            baseAngleRad = RAD_0;
            negativeAngle = dir1.equalsIgnoreCase("south");
        } else if (dir2.equalsIgnoreCase("north")) {
            baseAngleRad = RAD_90;
            negativeAngle = dir1.equalsIgnoreCase("up");
        } else if (dir2.equalsIgnoreCase("down")) {
            baseAngleRad = RAD_180;
            negativeAngle = dir1.equalsIgnoreCase("north");
        } else if (dir2.equalsIgnoreCase("south")) {
            baseAngleRad = RAD_270;
            negativeAngle = dir1.equalsIgnoreCase("down");
        } else {
            return;
        }
        if (this.flipImageLR_) {
            negativeAngle = !negativeAngle;
        }
        GeneralPath arrow = new GeneralPath();
        int xstart = this.gridWidth_ / 2 - spacing * (this.gridWidth_ / 2 / spacing);
        int ystart = this.gridHeight_ / 2 - spacing * (this.gridHeight_ / 2 / spacing);
        g2d.translate(this.gridXMargin_, this.gridYMargin_);
        for (int y = ystart; y < this.gridHeight_; y += spacing) {
            float yorig = this.flipImageTB_ ? (float)((double)(this.gridHeight_ - y) + 0.5) : (float)((double)y + 0.5);
            for (int x = xstart; x < this.gridWidth_; x += spacing) {
                float xorig;
                double angleRad;
                double mag;
                if (x < 0 || y < 0 || Double.isNaN(mag = this.data_.valueAt(x, y)) || Double.isNaN(angleRad = this.data_.angleAt(x, y))) continue;
                angleRad = negativeAngle ? baseAngleRad - angleRad : baseAngleRad + angleRad;
                double factor = mag / maxMag;
                double length = (double)vlength * factor;
                if (length == 0.0) continue;
                float f = xorig = this.flipImageLR_ ? (float)((double)(this.gridWidth_ - x) + 0.5) : (float)((double)x + 0.5);
                if (this.vectorStyle_ == PanVectorStyle.UPDOT) {
                    if (factor > 1.0) {
                        factor = 1.0;
                    }
                    double radius = 2.0 * factor;
                    g2d.fill(new Ellipse2D.Double((double)xorig - radius, (double)yorig - radius, radius * 2.0, radius * 2.0));
                }
                float xtip = (float)((double)xorig - length * Math.sin(angleRad));
                float ytip = (float)((double)yorig - length * Math.cos(angleRad));
                if (xtip < 0.0f || ytip < 0.0f || xtip > (float)this.gridWidth_ || ytip > (float)this.gridHeight_) {
                    float xmin = xorig;
                    float ymin = yorig;
                    float xmax = xtip;
                    float ymax = ytip;
                    for (int iterate = 0; iterate < 5; ++iterate) {
                        xtip = 0.5f * (xmin + xmax);
                        ytip = 0.5f * (ymin + ymax);
                        if (xtip < 0.0f || ytip < 0.0f || xtip > (float)this.gridWidth_ || ytip > (float)this.gridHeight_) {
                            xmax = xtip;
                            ymax = ytip;
                            continue;
                        }
                        xmin = xtip;
                        ymin = ytip;
                    }
                    GraphicUtilities.drawLine(g2d, xorig, yorig, xtip, ytip);
                    continue;
                }
                GraphicUtilities.drawLine(g2d, xorig, yorig, xtip, ytip);
                if (this.vectorStyle_ != PanVectorStyle.ARROW) continue;
                double hlengthX = (float)((double)hlength * COS45 * Math.min(1.0, factor));
                float x1 = (float)((double)xtip - hlengthX * Math.sin(angleRad - RAD135));
                float y1 = (float)((double)ytip - hlengthX * Math.cos(angleRad - RAD135));
                float x2 = (float)((double)xtip - hlengthX * Math.sin(angleRad + RAD135));
                float y2 = (float)((double)ytip - hlengthX * Math.cos(angleRad + RAD135));
                GraphicUtilities.drawLine(g2d, x1, y1, xtip, ytip);
                GraphicUtilities.drawLine(g2d, x2, y2, xtip, ytip);
            }
        }
        g2d.translate(-this.gridXMargin_, -this.gridYMargin_);
    }

    @Override
    public Point2D.Double transformXY2GridCoords(double x, double y) {
        PlotPieceMargins margins = this.getMargins();
        y -= (double)(margins.top + this.gridYMargin_);
        if ((x -= (double)(margins.left + this.gridXMargin_)) < 0.0 || y < 0.0 || x > (double)this.gridWidth_ || y > (double)this.gridHeight_) {
            return null;
        }
        return ((PanLatVertData)this.data_).transformXY2GridCoords(x, y);
    }

    @Override
    public String describePoint(int x, int y) {
        Rectangle gbounds = this.pmeta_.getRect("plot:bounds.graphic");
        if ((x -= gbounds.x + this.gridXMargin_) < 0 || (y -= gbounds.y + this.gridYMargin_) < 0 || x > this.gridWidth_ || y > this.gridHeight_) {
            return null;
        }
        StringBuilder sb = new StringBuilder("");
        ((PanLatVertData)this.data_).describeData(sb, x, y, this.flipImageLR_, this.flipImageTB_);
        return sb.toString();
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.localParameterChanged(pname);
    }

    private void localParameterChanged(String pname) {
        boolean changeAll;
        boolean bl = changeAll = pname == null || pname.equals("all");
        if (changeAll || pname.contains("plot:xaxis.max") || pname.contains("plot:xaxis.min") || pname.contains("plot:latvert.lataxis.flipped")) {
            this.minLat_ = this.pmeta_.getDouble("plot:xaxis.min");
            this.maxLat_ = this.pmeta_.getDouble("plot:xaxis.max");
            this.flipImageLR_ = this.pmeta_.getBoolean("plot:latvert.lataxis.flipped");
            if (this.flipImageLR_) {
                this.lBound_ = this.minLat_;
                this.rBound_ = this.maxLat_;
            } else {
                this.lBound_ = this.maxLat_;
                this.rBound_ = this.minLat_;
            }
            ((PanLatVertData)this.data_).setLatRange(this.minLat_, this.maxLat_);
        }
        this.needsDataRedraw_ = true;
        this.needsRecontour_ = true;
    }
}

