/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.graphics.colortable.AbstractColorTable;
import gov.nasa.giss.panoply.PanAbstractData2D;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanScaleMeta;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanDataImage2D
extends BufferedImage {
    private static Logger logger_ = LoggerFactory.getLogger(PanDataImage2D.class);
    private static final PanPreferences PREFS = PanPreferences.getPrefs();
    private PanPlotMeta pmeta_;
    private PanAbstractData2D data_;
    private PanScaleMeta smeta_;

    public PanDataImage2D(PanPlotMeta pmeta, PanAbstractData2D data, PanScaleMeta scaleDescription) {
        super(data.getWidth(), data.getHeight(), 2);
        this.pmeta_ = pmeta;
        this.data_ = data;
        this.smeta_ = scaleDescription;
    }

    public void paintData(boolean flipDataLR, boolean flipDataTB, boolean transparentFill) {
        Graphics2D g2d = this.createGraphics();
        int iwidth = this.getWidth();
        int jheight = this.getHeight();
        g2d.setColor(this.pmeta_.getColor("plot:colors.background"));
        GraphicUtilities.fillRect(g2d, 0.0f, 0.0f, iwidth, jheight);
        double scaleMin = this.smeta_.getMinimum();
        double scaleMax = this.smeta_.getMaximum();
        boolean logarithmic = this.pmeta_.getBoolean("plot:scale.log10");
        if (logarithmic) {
            scaleMin = Math.log10(scaleMin);
            scaleMax = Math.log10(scaleMax);
        }
        AbstractColorTable ct = (AbstractColorTable)this.pmeta_.get("plot:colorbar.name");
        boolean ctInverted = this.pmeta_.getBoolean("plot:colorbar.invert");
        int colorCount = ct.getColorCount();
        double delta = (scaleMax - scaleMin) / (double)colorCount;
        double invDelta = 1.0 / delta;
        int invalidsRGB = 0;
        invalidsRGB = transparentFill ? 0x999999 : this.pmeta_.getColor("plot:colors.invalids").getRGB();
        PanAbstractData2D data2D = this.data_;
        for (int j = 0; j < jheight; ++j) {
            for (int i = 0; i < iwidth; ++i) {
                int ii = flipDataLR ? iwidth - i - 1 : i;
                int jj = flipDataTB ? jheight - j - 1 : j;
                double value = logarithmic ? data2D.logOfValueAt(ii, jj) : data2D.valueAt(ii, jj);
                if (Double.isNaN(value)) {
                    this.setRGB(i, j, invalidsRGB);
                    continue;
                }
                if (Double.isInfinite(value)) {
                    this.setRGB(i, j, invalidsRGB);
                    continue;
                }
                if (value < scaleMin) {
                    this.setRGB(i, j, ct.getMinOutlierRGB(ctInverted));
                    continue;
                }
                if (value > scaleMax) {
                    this.setRGB(i, j, ct.getMaxOutlierRGB(ctInverted));
                    continue;
                }
                int cbin = Math.min((int)((value - scaleMin) * invDelta), colorCount - 1);
                cbin = Math.max(cbin, 0);
                this.setRGB(i, j, ct.getRGBAt(cbin, ctInverted));
            }
        }
        g2d.dispose();
    }
}

