/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.ContourLevel;
import gov.nasa.giss.data.ContourLine;
import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.panoply.PanAbstractData2D;
import gov.nasa.giss.panoply.PanCombinationType;
import gov.nasa.giss.panoply.PanContourStyle;
import gov.nasa.giss.panoply.PanGraphicUtilities;
import gov.nasa.giss.panoply.PanUtilities;
import gov.nasa.giss.panoply.PanVectorStyle;
import gov.nasa.giss.panoply.plot.PanAbstractPlot;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.plot.PlotPieceMargins;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PanAbstractPlot2D
extends PanAbstractPlot {
    private static Logger logger_ = LoggerFactory.getLogger(PanAbstractPlot2D.class);
    private static final double HALF_PI = 1.5707963267948966;
    protected int gridWidth_;
    protected int gridHeight_;
    protected int gridXMargin_;
    protected int gridYMargin_;
    protected int gridWeight_;
    protected BasicStroke gridStroke_;
    protected Color gridColor_;
    protected String userXLabel_;
    protected String userYLabel_;
    protected int xMajorDiv_ = 1;
    protected int xMinorDiv_ = 1;
    protected int yMajorDiv_ = 1;
    protected int yMinorDiv_ = 1;
    protected Font axisNameFont_;
    protected Font axisTickFont_;
    private boolean logarithmic_;
    protected PanVectorStyle vectorStyle_;
    protected int vectorWeight_;
    protected Color vectorColor_;
    protected BasicStroke vectorStroke_;

    public PanAbstractPlot2D(PanPlotMeta pmeta, PanAbstractData2D data) {
        super(pmeta, data);
        this.localParameterChanged("all");
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        boolean mmvis = this.pmeta_.getBoolean("plot:scale.minmaxnote");
        this.minMaxNote_.setVisible(mmvis);
        if (mmvis) {
            PlotPieceMargins margins = this.getMargins();
            Rectangle notesRect = this.pmeta_.getRect("plot:bounds.note.center");
            this.minMaxNote_.setLocation(margins.left + notesRect.x, margins.top + notesRect.y);
            this.minMaxNote_.setSize(notesRect.width, notesRect.height);
        }
        Rectangle gbounds = this.pmeta_.getRect("plot:bounds.graphic");
        Dimension gridSize = this.pmeta_.getDimension("plot:size.grid");
        this.gridWidth_ = gridSize.width;
        this.gridHeight_ = gridSize.height;
        float afhgt = this.pmeta_.getFloat("plot:font.height.axes");
        int graphicHeight = (int)((float)this.gridHeight_ + afhgt + 12.0f + afhgt);
        this.gridXMargin_ = (gbounds.width - gridSize.width) / 2;
        this.gridYMargin_ = (gbounds.height - graphicHeight) / 2;
        if (this.needsDataRedraw_) {
            this.paintDataImage(false);
            this.needsRecontour_ = true;
        }
        super.paintPiece(gx, printing);
        Graphics2D g2d = (Graphics2D)gx.create();
        PlotPieceMargins margins = this.getMargins();
        g2d.translate(margins.left, margins.top);
        g2d.translate(gbounds.x, gbounds.y);
        g2d.drawImage((Image)this.dataImage_, this.gridXMargin_, this.gridYMargin_, this);
        this.drawContours(g2d, this.gridXMargin_, this.gridYMargin_);
        if (this.vectorWeight_ > 0 && this.vectorStyle_ != PanVectorStyle.NONE) {
            this.drawVectors(g2d);
        }
        this.drawGrid(g2d);
        g2d.dispose();
    }

    protected abstract void drawGrid(Graphics2D var1);

    protected abstract void drawVectors(Graphics2D var1);

    protected void drawContours(Graphics2D g2d, int ixMargin, int iyMargin) {
        if (this.contourWeight_ < 1) {
            return;
        }
        String style = this.pmeta_.getString("plot:contour.style").toLowerCase();
        if (style.indexOf("none") > -1) {
            return;
        }
        if (this.needsRecontour_) {
            double[] tvalues = this.smeta_.getContourTickValues();
            this.contours_.setLevelValues(tvalues);
            this.contourLevels_ = this.contours_.getLevels();
            if (this.pmeta_.getString("plot:contour.location").equalsIgnoreCase("minor")) {
                double[] mvalues = this.smeta_.getMajorTickValues();
                block0: for (ContourLevel level : this.contourLevels_) {
                    double value = level.getValue();
                    level.setLabeled(false);
                    for (int i = 0; i < mvalues.length; ++i) {
                        if (value != mvalues[i]) continue;
                        level.setLabeled(true);
                        continue block0;
                    }
                }
            }
            this.needsRecontour_ = false;
        }
        if (this.contourLevels_ == null) {
            return;
        }
        int levelcount = this.contourLevels_.size();
        if (levelcount == 0) {
            return;
        }
        g2d.setColor(this.pmeta_.getColor("plot:contour.color"));
        g2d.setFont(this.contourFont_);
        FontMetrics fm = g2d.getFontMetrics();
        float fleft = ixMargin;
        float ftop = iyMargin;
        float fwidth = this.pmeta_.getDimension((String)"plot:size.grid").width;
        float fheight = this.pmeta_.getDimension((String)"plot:size.grid").height;
        for (ContourLevel level : this.contourLevels_) {
            ContourLine line;
            int lineSize;
            level.sort();
            double value = level.getValue();
            if (this.logarithmic_) {
                value = Math.pow(10.0, value);
            }
            String label = this.scaleFormatter_.sprintf(value);
            BasicStroke stroke = style.equalsIgnoreCase(PanContourStyle.DOTNEG.toString()) ? (value < 0.0 ? this.contourStrokeDotted_ : this.contourStrokeSolid_) : (style.equalsIgnoreCase(PanContourStyle.DOTTED.toString()) ? this.contourStrokeDotted_ : this.contourStrokeSolid_);
            g2d.setStroke(stroke);
            int levelsize = level.size();
            int labelcount = levelsize <= 8 ? levelsize : Math.max(6, levelsize / 2);
            for (int jj = 0; jj < levelsize && (lineSize = (line = (ContourLine)level.elementAt(jj)).size()) >= 2; ++jj) {
                float py;
                float px;
                Polygon lpoly = null;
                if (this.pmeta_.getBoolean("plot:contour.labels") && level.isLabeled() && lineSize > 50 && jj <= labelcount) {
                    double dx;
                    String ltext = this.scaleFormatter_.sprintf(value);
                    int twidth = fm.stringWidth(ltext);
                    int ixx = lineSize * (jj % 3 + 1) / 4;
                    Point2D.Double p0 = (Point2D.Double)line.elementAt(ixx);
                    Point2D.Double pa = (Point2D.Double)line.elementAt(ixx - 3);
                    Point2D.Double pb = (Point2D.Double)line.elementAt(ixx + 3);
                    double dy = this.flipImageTB_ ? pa.y - pb.y : pb.y - pa.y;
                    double rad = Math.atan2(dy, dx = this.flipImageLR_ ? pa.x - pb.x : pb.x - pa.x);
                    if (rad > 1.5707963267948966) {
                        rad -= Math.PI;
                    }
                    if (rad < -1.5707963267948966) {
                        rad += Math.PI;
                    }
                    px = fleft + (float)(this.flipImageLR_ ? (double)fwidth - p0.x : p0.x);
                    py = ftop + (float)(this.flipImageTB_ ? (double)fheight - p0.y : p0.y);
                    float hw = (float)(0.5 * (double)twidth);
                    float hh = (float)(0.5 * (double)fm.getAscent());
                    lpoly = this.makeContourLabelPolygon(px, py, twidth, fm.getAscent(), (float)rad);
                    g2d.translate(px, py);
                    g2d.rotate(rad);
                    GraphicUtilities.drawString(g2d, ltext, -hw, hh);
                    g2d.rotate(-rad);
                    g2d.translate(-px, -py);
                }
                GeneralPath path = new GeneralPath();
                Point2D.Double pt0 = (Point2D.Double)line.elementAt(0);
                px = fleft + (float)(this.flipImageLR_ ? (double)fwidth - pt0.x : pt0.x);
                py = ftop + (float)(this.flipImageTB_ ? (double)fheight - pt0.y : pt0.y);
                path.moveTo(px, py);
                Iterator i$ = line.iterator();
                while (i$.hasNext()) {
                    Point2D.Double ptobj;
                    Point2D.Double pt = ptobj = (Point2D.Double)i$.next();
                    px = fleft + (float)(this.flipImageLR_ ? (double)fwidth - pt.x : pt.x);
                    py = ftop + (float)(this.flipImageTB_ ? (double)fheight - pt.y : pt.y);
                    if (lpoly != null && lpoly.contains(px, py)) {
                        if (path.getCurrentPoint() != null) {
                            g2d.draw(path);
                        }
                        path.reset();
                        continue;
                    }
                    if (path.getCurrentPoint() != null) {
                        path.lineTo(px, py);
                        continue;
                    }
                    path.moveTo(px, py);
                }
                if (path.getCurrentPoint() == null) continue;
                g2d.draw(path);
            }
        }
    }

    private Polygon makeContourLabelPolygon(float px, float py, float w, float h, float angle) {
        float hw = (float)(0.6 * (double)w);
        float hh = (float)(0.6 * (double)h);
        float cosA = (float)Math.cos(angle);
        float sinA = (float)Math.sin(angle);
        int px1 = (int)(px + hw * cosA - hh * sinA);
        int px2 = (int)(px + hw * cosA + hh * sinA);
        int px3 = (int)(px - hw * cosA + hh * sinA);
        int px4 = (int)(px - hw * cosA - hh * sinA);
        int py1 = (int)(py + hw * sinA + hh * cosA);
        int py2 = (int)(py + hw * sinA - hh * cosA);
        int py3 = (int)(py - hw * sinA - hh * cosA);
        int py4 = (int)(py - hw * sinA + hh * cosA);
        Polygon lpoly = new Polygon(new int[]{px1, px2, px3, px4}, new int[]{py1, py2, py3, py4}, 4);
        return lpoly;
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.localParameterChanged(pname);
    }

    private void localParameterChanged(String pname) {
        int divs;
        boolean changeAll;
        boolean bl = changeAll = pname == null || pname.equals("all");
        if (changeAll || pname.contains("plot:grid.color") || pname.contains("plot:grid.weight")) {
            this.gridWeight_ = PanUtilities.minmax100(this.pmeta_.getInt("plot:grid.weight"));
            this.gridColor_ = this.pmeta_.getColor("plot:grid.color");
            this.gridStroke_ = PanGraphicUtilities.squareMiterStroke(this.gridWeight_);
        }
        if (changeAll || pname.contains("plot:xaxis.majordiv")) {
            divs = this.pmeta_.getInt("plot:xaxis.majordiv");
            divs = Math.min(divs, 25);
            this.xMajorDiv_ = divs = Math.max(divs, 1);
        }
        if (changeAll || pname.contains("plot:xaxis.minordiv")) {
            divs = this.pmeta_.getInt("plot:xaxis.minordiv");
            divs = Math.min(divs, 25);
            this.xMinorDiv_ = divs = Math.max(divs, 1);
        }
        if (changeAll || pname.contains("plot:yaxis.majordiv")) {
            divs = this.pmeta_.getInt("plot:yaxis.majordiv");
            divs = Math.min(divs, 25);
            this.yMajorDiv_ = divs = Math.max(divs, 1);
        }
        if (changeAll || pname.contains("plot:yaxis.minordiv")) {
            divs = this.pmeta_.getInt("plot:yaxis.minordiv");
            divs = Math.min(divs, 25);
            this.yMinorDiv_ = divs = Math.max(divs, 1);
        }
        if (changeAll || pname.contains("plot:xaxis.label.usertext")) {
            this.userXLabel_ = this.pmeta_.getString("plot:xaxis.label.usertext");
        }
        if (changeAll || pname.contains("plot:yaxis.label.usertext")) {
            this.userYLabel_ = this.pmeta_.getString("plot:yaxis.label.usertext");
        }
        if (changeAll || pname.contains("plot:font.master")) {
            String fn = this.pmeta_.getString("plot:font.master");
            float afhgt = this.pmeta_.getFloat("plot:font.height.axes");
            try {
                this.axisNameFont_ = new Font(fn, 0, 8);
            }
            catch (Exception exc) {
                this.axisNameFont_ = new Font("SansSerif", 0, 8);
            }
            this.axisNameFont_ = this.axisNameFont_.deriveFont(afhgt);
            this.axisTickFont_ = this.axisNameFont_.deriveFont(0.8f * this.axisNameFont_.getSize2D());
        }
        if (changeAll || pname.contains("plot:scale.minmaxnote")) {
            // empty if block
        }
        if (changeAll || pname.contains("plot:scale.interpolate") || pname.contains("plot:scale.log10")) {
            this.logarithmic_ = this.pmeta_.getBoolean("plot:scale.log10");
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("plot:combination") || pname.contains("plot:vector.color") || pname.contains("plot:vector.weight") || pname.contains("plot:vector.style")) {
            boolean vectorsEnabled;
            PanCombinationType ctype = (PanCombinationType)this.pmeta_.get("plot:combination");
            boolean bl2 = vectorsEnabled = ctype != null && ctype == PanCombinationType.VECTOR_A1_A2;
            if (vectorsEnabled) {
                String vs = this.pmeta_.getString("plot:vector.style").toLowerCase();
                if (PanVectorStyle.ARROW.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.ARROW;
                    this.vectorWeight_ = PanUtilities.minmax100(this.pmeta_.getInt("plot:vector.weight"));
                } else if (PanVectorStyle.UPDOT.matches(vs)) {
                    this.vectorStyle_ = PanVectorStyle.UPDOT;
                    this.vectorWeight_ = PanUtilities.minmax100(this.pmeta_.getInt("plot:vector.weight"));
                } else {
                    this.vectorStyle_ = PanVectorStyle.NONE;
                    this.vectorWeight_ = 0;
                }
            } else {
                this.vectorWeight_ = 0;
            }
            if (this.vectorWeight_ > 0) {
                this.vectorColor_ = this.pmeta_.getColor("plot:vector.color");
                this.vectorStroke_ = PanGraphicUtilities.buttMiterStroke(this.vectorWeight_);
            } else {
                this.vectorColor_ = null;
                this.vectorStroke_ = null;
            }
        }
    }

    class ColorArea {
        public int colorval_;
        public Area area_;

        ColorArea(int colorval, Area area) {
            this.colorval_ = colorval;
            this.area_ = area;
        }
    }
}

