/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.plot;

import gov.nasa.giss.data.ContourLevels;
import gov.nasa.giss.data.Contours2D;
import gov.nasa.giss.data.DataEvent;
import gov.nasa.giss.data.DataListener;
import gov.nasa.giss.graphics.GraphicUtilities;
import gov.nasa.giss.panoply.PanAbstractData2D;
import gov.nasa.giss.panoply.PanConstants;
import gov.nasa.giss.panoply.PanGraphicUtilities;
import gov.nasa.giss.panoply.PanPreferences;
import gov.nasa.giss.panoply.PanUtilities;
import gov.nasa.giss.panoply.plot.PanDataImage2D;
import gov.nasa.giss.panoply.plot.PanMinMaxNote;
import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plot.PanPlotNote;
import gov.nasa.giss.panoply.plot.PanPlotPiece;
import gov.nasa.giss.panoply.plot.PanPlotScale;
import gov.nasa.giss.panoply.plot.PanScaleMeta;
import gov.nasa.giss.plot.PlotPropertyEvent;
import gov.nasa.giss.plot.PlotPropertyListener;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PanAbstractPlot
extends PanPlotPiece
implements DataListener,
PlotPropertyListener {
    private static Logger logger_ = LoggerFactory.getLogger(PanAbstractPlot.class);
    protected static final PanPreferences PREFS = PanPreferences.getPrefs();
    protected PanAbstractData2D data_;
    protected PanPlotScale scale_;
    private PanPlotNote title_;
    private PanPlotNote subtitle_;
    protected PanDataImage2D dataImage_;
    protected boolean needsDataRedraw_ = true;
    protected boolean flipImageLR_;
    protected boolean flipImageTB_;
    protected boolean needsRecontour_ = true;
    protected Contours2D contours_;
    protected ContourLevels contourLevels_;
    protected int contourWeight_;
    protected BasicStroke contourStrokeSolid_;
    protected BasicStroke contourStrokeDotted_;
    protected Font contourFont_;
    protected PrintfFormat scaleFormatter_ = new PrintfFormat("%G");
    protected PanMinMaxNote minMaxNote_;
    protected PanScaleMeta smeta_;

    private PanAbstractPlot() {
    }

    protected PanAbstractPlot(PanPlotMeta pmeta, PanAbstractData2D data) {
        super(pmeta);
        this.data_ = data;
        this.smeta_ = new PanScaleMeta(pmeta, data);
        this.contours_ = new Contours2D(this.data_);
        this.setOpaque(true);
        this.title_ = new PanPlotNote(pmeta, this.pmeta_.getString("plot:caption.title"));
        this.subtitle_ = new PanPlotNote(pmeta, "");
        this.scale_ = new PanPlotScale(pmeta, this.data_, this.smeta_);
        this.minMaxNote_ = new PanMinMaxNote(pmeta, data);
        this.attach(this.title_);
        this.attach(this.subtitle_);
        this.attach(this.scale_);
        this.attach(this.minMaxNote_);
        this.data_.addDataListener(this);
        this.pmeta_.addPlotPropertyListener(this);
        this.localParameterChanged("all");
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.updateSubtitle();
        this.dataImage_ = new PanDataImage2D(this.pmeta_, this.data_, this.smeta_);
        Rectangle scaleRect = this.pmeta_.getRect("plot:bounds.scale");
        this.scale_.setLocation(scaleRect.x, scaleRect.y);
        this.scale_.setSize(scaleRect.width, scaleRect.height);
        this.minMaxNote_.setFontSize(this.pmeta_.getFloat("plot:font.height.notes"));
        this.needsDataRedraw_ = true;
    }

    public PanPlotMeta getMeta() {
        return this.pmeta_;
    }

    private void updateSubtitle() {
        String s = this.subtitle_.getText();
        float tfh = this.pmeta_.getFloat("plot:font.height.title");
        if (s == null || s.length() == 0) {
            Rectangle titleRect = this.pmeta_.getRect("plot:bounds.title");
            this.title_.setFontSize(tfh);
            this.title_.setLocation(titleRect.x, (int)((double)titleRect.y + (double)tfh / 2.0));
            this.title_.setSize(titleRect.width, titleRect.height);
            this.subtitle_.setLocation(0, 0);
            this.subtitle_.setSize(0, 0);
            this.subtitle_.setVisible(false);
        } else {
            Rectangle titleRect = this.pmeta_.getRect("plot:bounds.title");
            Rectangle subtitleRect = this.pmeta_.getRect("plot:bounds.subtitle");
            this.title_.setFontSize(tfh);
            this.title_.setLocation(titleRect.x, titleRect.y);
            this.title_.setSize(titleRect.width, titleRect.height);
            this.subtitle_.setFontSize(this.pmeta_.getFloat("plot:font.height.subtitle"));
            this.subtitle_.setLocation(subtitleRect.x, subtitleRect.y);
            this.subtitle_.setSize(subtitleRect.width, subtitleRect.height);
            this.subtitle_.setVisible(true);
        }
    }

    @Override
    protected synchronized void paintPiece(Graphics2D gx, boolean printing) {
        Graphics2D g2d = (Graphics2D)gx.create();
        g2d.setColor(this.getBackground());
        GraphicUtilities.fillRect(g2d, 0.0f, 0.0f, this.getWidth(), this.getHeight());
        g2d.dispose();
    }

    protected void paintDataImage(boolean transparentFill) {
        this.dataImage_.paintData(this.flipImageLR_, this.flipImageTB_, transparentFill);
        this.needsDataRedraw_ = false;
    }

    public BufferedImage getImage() {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        this.paintImage(img);
        return img;
    }

    public void paintImage(BufferedImage img) {
        this.needsDataRedraw_ = true;
        Graphics2D g2d = img.createGraphics();
        GraphicUtilities.antialias(g2d);
        this.paint(g2d);
        g2d.dispose();
    }

    protected String getExtremaDescription() {
        StringBuilder sb = new StringBuilder("Data ");
        sb.append("Min = ");
        sb.append(this.scale_.getFormatter().sprintf(this.data_.getMinimumValue()));
        sb.append(", ");
        sb.append("Max = ");
        sb.append(this.scale_.getFormatter().sprintf(this.data_.getMaximumValue()));
        return sb.toString();
    }

    public synchronized void flush() {
        if (this.pmeta_ != null) {
            this.pmeta_.removePlotPropertyListener(this);
        }
        if (this.dataImage_ != null) {
            this.dataImage_.flush();
        }
        this.pmeta_ = null;
        this.data_ = null;
        this.dataImage_ = null;
        this.scale_ = null;
        this.contours_ = null;
        this.minMaxNote_ = null;
    }

    public Point2D.Double transformXY2GridCoords(Point p) {
        return this.transformXY2GridCoords((double)p.x, (double)p.y);
    }

    public Point2D.Double transformXY2GridCoords(Point2D.Double p) {
        return this.transformXY2GridCoords(p.getX(), p.getY());
    }

    public Point2D.Double transformXY2GridCoords(int x, int y) {
        return this.transformXY2GridCoords((double)x, (double)y);
    }

    public abstract Point2D.Double transformXY2GridCoords(double var1, double var3);

    public abstract String describePoint(int var1, int var2);

    @Override
    public void dataChanged(DataEvent e) {
        this.needsDataRedraw_ = true;
        this.needsRecontour_ = true;
    }

    @Override
    public void plotPropertyChanged(PlotPropertyEvent e) {
        if (e == null) {
            return;
        }
        this.parameterChanged(e.getMessage());
    }

    @Override
    protected void parameterChangedSelf(String pname) {
        super.parameterChangedSelf(pname);
        this.localParameterChanged(pname);
    }

    private void localParameterChanged(String pname) {
        String s;
        boolean changeAll;
        boolean bl = changeAll = pname == null || pname.equals("all");
        if (changeAll || pname.contains("plot:colors.background")) {
            this.setBackground(this.pmeta_.getColor("plot:colors.background"));
        }
        if (changeAll || pname.contains("plot:scale.minimum") || pname.contains("plot:scale.maximum")) {
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("plot:scale.autofit")) {
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("plot:caption.title")) {
            this.title_.setText(this.pmeta_.getString("plot:caption.title"));
        }
        if (changeAll || pname.contains("plot:caption.subtitle")) {
            this.subtitle_.setText(this.pmeta_.getString("plot:caption.subtitle"));
            this.updateSubtitle();
        }
        if (changeAll || pname.contains("plot:colorbar.name") || pname.contains("plot:colorbar.invert") || pname.contains("plot:colors.invalids") || pname.contains("plot:colorbar.name")) {
            this.needsDataRedraw_ = true;
        }
        if (changeAll || pname.contains("plot:contour.color") || pname.contains("plot:contour.weight") || pname.contains("plot:contour.style") || pname.contains("plot:contour.location") || changeAll) {
            s = this.pmeta_.getString("plot:contour.style");
            int oldOpacity = this.contourWeight_;
            this.contourWeight_ = s.toLowerCase().indexOf("none") > -1 ? 0 : PanUtilities.minmax100(this.pmeta_.getInt("plot:contour.weight"));
            this.contourStrokeSolid_ = PanGraphicUtilities.roundStroke(this.contourWeight_);
            this.contourStrokeDotted_ = PanGraphicUtilities.roundStroke(this.contourWeight_, PanConstants.DOT_PATTERN);
            if (oldOpacity == 0 && this.contourWeight_ > 0) {
                this.needsRecontour_ = true;
            }
        }
        if (changeAll || pname.contains("plot:contour.labels")) {
            // empty if block
        }
        if (changeAll || pname.contains("plot:contour.location")) {
            this.needsRecontour_ = true;
        }
        if (changeAll || pname.contains("plot:scale.majordiv") || pname.contains("plot:scale.minordiv")) {
            this.needsRecontour_ = true;
        }
        if (changeAll || pname.contains("plot:font.master")) {
            String fn = this.pmeta_.getString("plot:font.master");
            float cfhgt = this.pmeta_.getFloat("plot:font.height.contour");
            try {
                this.contourFont_ = new Font(fn, 0, 8).deriveFont(cfhgt);
            }
            catch (Exception exc) {
                this.contourFont_ = new Font("SansSerif", 0, 8).deriveFont(cfhgt);
            }
        }
        if (changeAll || pname.contains("plot:scale.tick.format")) {
            s = this.pmeta_.getString("plot:scale.tick.format");
            if (s == null) {
                throw new IllegalArgumentException("Null format string");
            }
            this.scaleFormatter_ = new PrintfFormat(s);
        }
    }
}

